/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import simplepets.brainsynder.libs.bslib.nbt.StorageBase;
import simplepets.brainsynder.libs.bslib.nbt.other.IStorageList;
import simplepets.brainsynder.libs.bslib.nbt.other.NBTSizeTracker;

public class StorageTagIntArray
extends StorageBase
implements IStorageList<int[]> {
    private int[] intArray;

    StorageTagIntArray() {
    }

    public StorageTagIntArray(int[] ints) {
        this.intArray = ints;
    }

    public StorageTagIntArray(List<Integer> integerList) {
        this(StorageTagIntArray.toArray(integerList));
    }

    @Override
    public int[] getList() {
        return this.intArray;
    }

    private static int[] toArray(List<Integer> integerList) {
        int[] aint = new int[integerList.size()];
        for (int i = 0; i < integerList.size(); ++i) {
            Integer integer = integerList.get(i);
            aint[i] = integer == null ? 0 : integer;
        }
        return aint;
    }

    @Override
    void write(DataOutput output) throws IOException {
        output.writeInt(this.intArray.length);
        for (int i : this.intArray) {
            output.writeInt(i);
        }
    }

    @Override
    void read(DataInput input, int depth, NBTSizeTracker sizeTracker) throws IOException {
        sizeTracker.read(192L);
        int i = input.readInt();
        sizeTracker.read(32 * i);
        this.intArray = new int[i];
        for (int j = 0; j < i; ++j) {
            this.intArray[j] = input.readInt();
        }
    }

    @Override
    public byte getId() {
        return 11;
    }

    @Override
    public String toString() {
        StringBuilder stringbuilder = new StringBuilder("[I;");
        for (int i = 0; i < this.intArray.length; ++i) {
            if (i != 0) {
                stringbuilder.append(',');
            }
            stringbuilder.append(this.intArray[i]);
        }
        return stringbuilder.append(']').toString();
    }

    @Override
    public StorageTagIntArray copy() {
        int[] aint = new int[this.intArray.length];
        System.arraycopy(this.intArray, 0, aint, 0, this.intArray.length);
        return new StorageTagIntArray(aint);
    }

    @Override
    public boolean equals(Object instance) {
        return super.equals(instance) && Arrays.equals(this.intArray, ((StorageTagIntArray)instance).intArray);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Arrays.hashCode(this.intArray);
    }

    public int[] getIntArray() {
        return this.intArray;
    }
}

