/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.inventory.ItemStack;
import simplepets.brainsynder.libs.bslib.nbt.StorageBase;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagByte;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagByteArray;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagDouble;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagFloat;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagInt;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagIntArray;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagList;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagLong;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagShort;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagString;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagTools;
import simplepets.brainsynder.libs.bslib.nbt.other.IStorageList;
import simplepets.brainsynder.libs.bslib.nbt.other.NBTSizeTracker;
import simplepets.brainsynder.libs.bslib.nbt.other.StorageColorType;
import simplepets.brainsynder.libs.bslib.utils.Colorize;

public class StorageTagCompound
extends StorageBase {
    private static final Pattern PATTERN = Pattern.compile("[A-Za-z0-9._+-]+");
    private final Map<String, StorageBase> tagMap = new HashMap<String, StorageBase>();
    private final List<String> booleans = new ArrayList<String>();

    private static void writeEntry(String name, StorageBase data, DataOutput output) throws IOException {
        output.writeByte(data.getId());
        if (data.getId() != 0) {
            output.writeUTF(name);
            data.write(output);
        }
    }

    private static byte readType(DataInput input, NBTSizeTracker sizeTracker) throws IOException {
        return input.readByte();
    }

    private static String readKey(DataInput input, NBTSizeTracker sizeTracker) throws IOException {
        return input.readUTF();
    }

    static StorageBase readNBT(byte id, String key, DataInput input, int depth, NBTSizeTracker sizeTracker) throws IOException {
        StorageBase nbtbase = StorageBase.createNewByType(id);
        try {
            nbtbase.read(input, depth, sizeTracker);
            return nbtbase;
        }
        catch (IOException ioexception) {
            throw new IOException(ioexception);
        }
    }

    protected static String match(String s) {
        return PATTERN.matcher(s).matches() ? s : StorageTagString.configure(s);
    }

    static void escape(String s, StringBuffer sb) {
        block9: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '/': {
                    sb.append("\\/");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        String ss = Integer.toHexString(ch);
                        sb.append("\\u");
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            sb.append('0');
                        }
                        sb.append(ss.toUpperCase());
                        continue block9;
                    }
                    sb.append(ch);
                }
            }
        }
    }

    @Override
    void write(DataOutput output) throws IOException {
        for (String s : this.tagMap.keySet()) {
            StorageBase nbtbase = this.tagMap.get(s);
            StorageTagCompound.writeEntry(s, nbtbase, output);
        }
        output.writeByte(0);
    }

    @Override
    void read(DataInput input, int depth, NBTSizeTracker sizeTracker) throws IOException {
        byte b0;
        sizeTracker.read(384L);
        if (depth > 512) {
            throw new RuntimeException("Tried to read NBT tag with too high complexity, depth > 512");
        }
        this.tagMap.clear();
        while ((b0 = StorageTagCompound.readType(input, sizeTracker)) != 0) {
            String s = StorageTagCompound.readKey(input, sizeTracker);
            sizeTracker.read(224L + 16L * (long)s.length());
            StorageBase nbtbase = StorageTagCompound.readNBT(b0, s, input, depth + 1, sizeTracker);
            if (this.tagMap.put(s, nbtbase) == null) continue;
            sizeTracker.read(288L);
        }
    }

    public Set<String> getKeySet() {
        return this.tagMap.keySet();
    }

    @Override
    public byte getId() {
        return 10;
    }

    public int getSize() {
        return this.tagMap.size();
    }

    public StorageTagCompound set(String key, Object object) {
        if (object instanceof Boolean) {
            this.setBoolean(key, (Boolean)object);
        } else if (object instanceof Integer) {
            this.setInteger(key, (Integer)object);
        } else if (object instanceof Byte) {
            this.setByte(key, (Byte)object);
        } else if (object instanceof Float) {
            this.setFloat(key, ((Float)object).floatValue());
        } else if (object instanceof Double) {
            this.setDouble(key, (Double)object);
        } else if (object instanceof Long) {
            this.setLong(key, (Long)object);
        } else if (object instanceof Short) {
            this.setShort(key, (Short)object);
        } else if (object instanceof Location) {
            this.setLocation(key, (Location)object);
        } else if (object instanceof Enum) {
            this.setEnum(key, (Enum)object);
        } else if (object instanceof Color) {
            this.setColor(key, (Color)object);
        } else if (object instanceof byte[]) {
            this.setByteArray(key, (byte[])object);
        } else if (object instanceof int[]) {
            this.setIntArray(key, (int[])object);
        } else if (object instanceof String) {
            this.setString(key, (String)object);
        } else if (object instanceof ItemStack) {
            this.setItemStack(key, (ItemStack)object);
        } else if (object instanceof UUID) {
            this.setUniqueId(key, (UUID)object);
        }
        return this;
    }

    public StorageTagCompound setTag(String key, StorageBase value) {
        this.tagMap.put(key, value);
        return this;
    }

    public StorageTagCompound setByte(String key, byte value) {
        this.tagMap.put(key, new StorageTagByte(value));
        return this;
    }

    public StorageTagCompound setShort(String key, short value) {
        this.tagMap.put(key, new StorageTagShort(value));
        return this;
    }

    public StorageTagCompound setInteger(String key, int value) {
        this.tagMap.put(key, new StorageTagInt(value));
        return this;
    }

    public StorageTagCompound setLong(String key, long value) {
        this.tagMap.put(key, new StorageTagLong(value));
        return this;
    }

    public StorageTagCompound setUniqueId(String key, UUID value) {
        this.setString(key, value.toString());
        return this;
    }

    public UUID getUniqueId(String key) {
        if (this.hasKey(key + "Most", 99) && this.hasKey(key + "Least", 99)) {
            return new UUID(this.getLong(key + "Most"), this.getLong(key + "Least"));
        }
        if (this.hasKey(key)) {
            String raw = this.getString(key);
            try {
                return UUID.fromString(raw);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return UUID.randomUUID();
    }

    public StorageTagCompound setFloat(String key, float value) {
        this.tagMap.put(key, new StorageTagFloat(value));
        return this;
    }

    public StorageTagCompound setDouble(String key, double value) {
        this.tagMap.put(key, new StorageTagDouble(value));
        return this;
    }

    public StorageTagCompound setString(String key, String value) {
        this.tagMap.put(key, new StorageTagString(value));
        return this;
    }

    public StorageTagCompound setByteArray(String key, byte[] value) {
        this.tagMap.put(key, new StorageTagByteArray(value));
        return this;
    }

    public StorageTagCompound setIntArray(String key, int[] value) {
        this.tagMap.put(key, new StorageTagIntArray(value));
        return this;
    }

    public StorageTagCompound setBoolean(String key, boolean value) {
        this.tagMap.put(key, new StorageTagByte((byte)(value ? 1 : 0)));
        this.booleans.add(key);
        return this;
    }

    public boolean isBoolean(String key) {
        return this.booleans.contains(key);
    }

    public StorageBase getTag(String key) {
        return this.tagMap.get(key);
    }

    public byte getTagId(String key) {
        StorageBase nbtbase = this.tagMap.get(key);
        return nbtbase == null ? (byte)0 : nbtbase.getId();
    }

    public boolean hasKey(String key) {
        return this.tagMap.containsKey(key);
    }

    public boolean hasKey(String key, int type) {
        byte i = this.getTagId(key);
        if (i == type) {
            return true;
        }
        if (type != 99) {
            return false;
        }
        return i == 1 || i == 2 || i == 3 || i == 4 || i == 5 || i == 6;
    }

    public StorageTagCompound setLocation(String key, Location location) {
        StorageTagCompound compound = new StorageTagCompound();
        compound.setString("world", location.getWorld().getName());
        compound.setDouble("x", location.getX());
        compound.setDouble("y", location.getY());
        compound.setDouble("z", location.getZ());
        compound.setFloat("yaw", location.getYaw());
        compound.setFloat("pitch", location.getPitch());
        this.setTag(key, compound);
        return this;
    }

    public Location getLocation(String key) {
        StorageTagCompound compound = this.getCompoundTag(key);
        World world = Bukkit.getWorld((String)compound.getString("world", "world"));
        double x = compound.getDouble("x", 0.0);
        double y = compound.getDouble("y", 0.0);
        double z = compound.getDouble("z", 0.0);
        float yaw = compound.getFloat("yaw", 0.0f);
        float pitch = compound.getFloat("pitch", 0.0f);
        return new Location(world, x, y, z, yaw, pitch);
    }

    public Location getLocation(String key, Location fallback) {
        return this.hasKey(key) ? this.getLocation(key) : fallback;
    }

    public StorageTagCompound setColor(String key, Color color) {
        return this.setColor(key, color, StorageColorType.COMPOUND);
    }

    public StorageTagCompound setColor(String key, Color color, StorageColorType type) {
        switch (type) {
            case HEX: {
                this.setString(key, Colorize.toHex(color.getRed(), color.getGreen(), color.getBlue()));
                break;
            }
            case INT: {
                this.setInteger(key, color.asRGB());
                break;
            }
            case STRING: {
                this.setString(key, color.getRed() + "," + color.getGreen() + "," + color.getBlue());
                break;
            }
            case COMPOUND: {
                StorageTagCompound compound = new StorageTagCompound();
                compound.setInteger("r", color.getRed());
                compound.setInteger("g", color.getGreen());
                compound.setInteger("b", color.getBlue());
                this.setTag(key, compound);
            }
        }
        return this;
    }

    public Color getColor(String key) {
        return this.getColor(key, Color.RED);
    }

    public Color getColor(String key, Color fallback) {
        if (!this.hasKey(key)) {
            return fallback;
        }
        StorageBase base = this.getTag(key);
        if (base instanceof StorageTagCompound) {
            int b;
            int g;
            StorageTagCompound compound = this.getCompoundTag(key);
            int r = compound.getInteger("r", 0);
            if (r > 255) {
                r = 255;
            }
            if (r < 0) {
                r = 0;
            }
            if ((g = compound.getInteger("g", 0)) > 255) {
                r = 255;
            }
            if (g < 0) {
                r = 0;
            }
            if ((b = compound.getInteger("b", 0)) > 255) {
                r = 255;
            }
            if (b < 0) {
                r = 0;
            }
            return Color.fromRGB((int)r, (int)g, (int)b);
        }
        if (base instanceof StorageTagInt) {
            return Color.fromRGB((int)((StorageTagInt)base).getInt());
        }
        if (base instanceof StorageTagString) {
            StorageTagString tagString = (StorageTagString)base;
            String string = tagString.getString();
            if (string.startsWith("#")) {
                return Color.fromRGB((int)Integer.valueOf(string.substring(1, 3), 16), (int)Integer.valueOf(string.substring(3, 5), 16), (int)Integer.valueOf(string.substring(5, 7), 16));
            }
            if (string.contains(",")) {
                String[] args = string.split(",");
                int r = 255;
                int g = 255;
                int b = 255;
                if (args.length >= 3) {
                    r = Integer.parseInt(args[0].trim());
                    g = Integer.parseInt(args[1].trim());
                    b = Integer.parseInt(args[2].trim());
                }
                return Color.fromRGB((int)r, (int)g, (int)b);
            }
            try {
                int rgb = Integer.parseInt(string);
                return Color.fromRGB((int)rgb);
            }
            catch (NumberFormatException e) {
                return fallback;
            }
        }
        return fallback;
    }

    public StorageTagCompound setEnum(String key, Enum anEnum) {
        this.setString(key, anEnum.name());
        return this;
    }

    public <E extends Enum> E getEnum(String key, Class<E> type) {
        return this.getEnum(key, type, null);
    }

    public <E extends Enum> E getEnum(String key, Class<E> type, E fallback) {
        if (!this.hasKey(key)) {
            return fallback;
        }
        return Enum.valueOf(type, this.getString(key));
    }

    public byte getByte(String key) {
        StorageBase storage = this.tagMap.get(key);
        if (storage.getId() == 1) {
            return ((StorageTagByte)storage).getByte();
        }
        return 0;
    }

    public byte getByte(String key, byte fallback) {
        return this.hasKey(key) ? this.getByte(key) : fallback;
    }

    public short getShort(String key) {
        return Short.parseShort(this.getValue(key));
    }

    public short getShort(String key, short fallback) {
        return this.hasKey(key) ? this.getShort(key) : fallback;
    }

    public int getInteger(String key) {
        return Integer.parseInt(this.getValue(key));
    }

    public int getInteger(String key, int fallback) {
        return this.hasKey(key) ? this.getInteger(key) : fallback;
    }

    public long getLong(String key) {
        return Long.parseLong(this.getValue(key));
    }

    public long getLong(String key, long fallback) {
        return this.hasKey(key) ? this.getLong(key) : fallback;
    }

    public float getFloat(String key) {
        return Float.parseFloat(this.getValue(key));
    }

    public float getFloat(String key, float fallback) {
        return this.hasKey(key) ? this.getFloat(key) : fallback;
    }

    public double getDouble(String key) {
        return Double.parseDouble(this.getValue(key));
    }

    public double getDouble(String key, double fallback) {
        return this.hasKey(key) ? this.getDouble(key) : fallback;
    }

    public String getString(String key) {
        return this.getValue(key);
    }

    public String getString(String key, String fallback) {
        return this.hasKey(key) ? this.getValue(key) : fallback;
    }

    public String getValue(String key) {
        try {
            if (this.hasKey(key)) {
                return this.fetchValue(this.tagMap.get(key));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return "";
    }

    private String fetchValue(StorageBase base) {
        if (base instanceof StorageTagByte) {
            byte tagByte = ((StorageTagByte)base).getByte();
            if (tagByte == 0 || tagByte == 1) {
                return String.valueOf(tagByte == 1);
            }
            return String.valueOf(tagByte);
        }
        if (base instanceof StorageTagByteArray) {
            return Arrays.toString(((StorageTagByteArray)base).getByteArray());
        }
        if (base instanceof StorageTagDouble) {
            return String.valueOf(((StorageTagDouble)base).getDouble());
        }
        if (base instanceof StorageTagFloat) {
            return String.valueOf(((StorageTagFloat)base).getFloat());
        }
        if (base instanceof StorageTagInt) {
            return String.valueOf(((StorageTagInt)base).getInt());
        }
        if (base instanceof StorageTagIntArray) {
            return Arrays.toString(((StorageTagIntArray)base).getIntArray());
        }
        if (base instanceof StorageTagLong) {
            return String.valueOf(((StorageTagLong)base).getLong());
        }
        if (base instanceof StorageTagShort) {
            return String.valueOf(((StorageTagShort)base).getShort());
        }
        if (base instanceof StorageTagString) {
            return String.valueOf(base.getString());
        }
        if (base instanceof StorageTagList) {
            StorageTagList list = (StorageTagList)base;
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < list.tagCount(); ++i) {
                builder.append(this.fetchValue(list.get(i)));
            }
            return builder.toString();
        }
        return base.getString();
    }

    public byte[] getByteArray(String key) {
        try {
            if (this.hasKey(key, 7)) {
                return (byte[])((IStorageList)((Object)this.tagMap.get(key))).getList();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return new byte[0];
    }

    public int[] getIntArray(String key) {
        try {
            if (this.hasKey(key, 11)) {
                return (int[])((IStorageList)((Object)this.tagMap.get(key))).getList();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return new int[0];
    }

    public StorageTagCompound getCompoundTag(String key) {
        try {
            if (this.hasKey(key, 10)) {
                return (StorageTagCompound)this.tagMap.get(key);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return new StorageTagCompound();
    }

    public StorageTagList getTagList(String key, int type) {
        try {
            if (this.getTagId(key) == 9) {
                StorageTagList nbttaglist = (StorageTagList)this.tagMap.get(key);
                if (!nbttaglist.hasNoTags() && nbttaglist.getTagType() != type) {
                    return new StorageTagList();
                }
                return nbttaglist;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return new StorageTagList();
    }

    public boolean getBoolean(String key) {
        return this.getByte(key) != 0;
    }

    public boolean getBoolean(String key, boolean fallback) {
        return this.hasKey(key) ? this.getBoolean(key) : fallback;
    }

    public StorageTagCompound setItemStack(String key, ItemStack item) {
        this.setTag(key, StorageTagTools.fromItemStack(item));
        return this;
    }

    public ItemStack getItemStack(String key) {
        return this.getItemStack(key, new ItemStack(Material.AIR));
    }

    public ItemStack getItemStack(String key, ItemStack fallback) {
        if (!this.hasKey(key)) {
            return fallback;
        }
        return StorageTagTools.toItemStack(this.getCompoundTag(key));
    }

    @Override
    public String toString() {
        StringBuilder stringbuilder = new StringBuilder("{");
        Set<String> collection = this.tagMap.keySet();
        for (String s : collection) {
            if (stringbuilder.length() != 1) {
                stringbuilder.append(',');
            }
            stringbuilder.append(StorageTagCompound.match(s)).append(':').append(this.tagMap.get(s));
        }
        return stringbuilder.append('}').toString();
    }

    @Override
    public boolean hasNoTags() {
        return this.tagMap.isEmpty();
    }

    @Override
    public StorageTagCompound copy() {
        StorageTagCompound nbttagcompound = new StorageTagCompound();
        for (String s : this.tagMap.keySet()) {
            nbttagcompound.setTag(s, this.tagMap.get(s).copy());
        }
        return nbttagcompound;
    }

    @Override
    public boolean equals(Object instance) {
        return super.equals(instance) && Objects.equals(this.tagMap.entrySet(), ((StorageTagCompound)instance).tagMap.entrySet());
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.tagMap.hashCode();
    }

    public StorageTagCompound remove(String key) {
        if (this.hasKey(key)) {
            this.tagMap.remove(key);
        }
        this.booleans.remove(key);
        return this;
    }

    public StorageTagCompound merge(StorageTagCompound other) {
        for (String s : other.tagMap.keySet()) {
            StorageBase nbtbase = other.tagMap.get(s);
            if (nbtbase.getId() == 10) {
                if (this.hasKey(s, 10)) {
                    StorageTagCompound nbttagcompound = this.getCompoundTag(s);
                    nbttagcompound.merge((StorageTagCompound)nbtbase);
                    continue;
                }
                this.setTag(s, nbtbase.copy());
                continue;
            }
            this.setTag(s, nbtbase.copy());
        }
        return this;
    }
}

