/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import simplepets.brainsynder.libs.bslib.nbt.StorageBase;
import simplepets.brainsynder.libs.bslib.nbt.other.IStorageList;
import simplepets.brainsynder.libs.bslib.nbt.other.NBTSizeTracker;

public class StorageTagByteArray
extends StorageBase
implements IStorageList<byte[]> {
    private byte[] data;

    StorageTagByteArray() {
    }

    public StorageTagByteArray(byte[] data) {
        this.data = data;
    }

    public StorageTagByteArray(List<Byte> byteList) {
        this(StorageTagByteArray.toArray(byteList));
    }

    @Override
    public byte[] getList() {
        return this.data;
    }

    private static byte[] toArray(List<Byte> byteList) {
        byte[] abyte = new byte[byteList.size()];
        for (int i = 0; i < byteList.size(); ++i) {
            Byte obyte = byteList.get(i);
            abyte[i] = obyte == null ? (byte)0 : obyte;
        }
        return abyte;
    }

    @Override
    void write(DataOutput output) throws IOException {
        output.writeInt(this.data.length);
        output.write(this.data);
    }

    @Override
    void read(DataInput input, int depth, NBTSizeTracker sizeTracker) throws IOException {
        sizeTracker.read(192L);
        int i = input.readInt();
        sizeTracker.read(8 * i);
        this.data = new byte[i];
        input.readFully(this.data);
    }

    @Override
    public byte getId() {
        return 7;
    }

    @Override
    public String toString() {
        StringBuilder stringbuilder = new StringBuilder("[B;");
        for (int i = 0; i < this.data.length; ++i) {
            if (i != 0) {
                stringbuilder.append(',');
            }
            stringbuilder.append(this.data[i]).append('B');
        }
        return stringbuilder.append(']').toString();
    }

    @Override
    public StorageBase copy() {
        byte[] abyte = new byte[this.data.length];
        System.arraycopy(this.data, 0, abyte, 0, this.data.length);
        return new StorageTagByteArray(abyte);
    }

    @Override
    public boolean equals(Object instance) {
        return super.equals(instance) && Arrays.equals(this.data, ((StorageTagByteArray)instance).data);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Arrays.hashCode(this.data);
    }

    public byte[] getByteArray() {
        return this.data;
    }
}

