/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.nbt;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import simplepets.brainsynder.libs.bslib.nbt.StorageBase;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagEnd;
import simplepets.brainsynder.libs.bslib.nbt.other.NBTSizeTracker;

public class CompressedStreamTools {
    public static StorageBase readCompressedBase(InputStream is) throws IOException {
        StorageBase base;
        try (DataInputStream datainputstream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(is)));){
            base = CompressedStreamTools.read(datainputstream, NBTSizeTracker.INFINITE);
        }
        return base;
    }

    public static StorageTagCompound readCompressed(InputStream is) throws IOException {
        StorageBase nbtbase = CompressedStreamTools.readCompressedBase(is);
        if (nbtbase instanceof StorageTagCompound) {
            return (StorageTagCompound)nbtbase;
        }
        throw new IOException("Root tag must be a named compound tag");
    }

    public static void writeCompressed(StorageBase compound, OutputStream outputStream) throws IOException {
        try (DataOutputStream dataoutputstream = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(outputStream)));){
            CompressedStreamTools.writeTag(compound, dataoutputstream);
        }
    }

    public static StorageBase read(DataInputStream inputStream) throws IOException {
        return CompressedStreamTools.read(inputStream, NBTSizeTracker.INFINITE);
    }

    public static StorageBase read(DataInput input, NBTSizeTracker accounter) throws IOException {
        return CompressedStreamTools.read(input, 0, accounter);
    }

    @Deprecated
    public static void write(StorageBase compound, DataOutput output) throws IOException {
        CompressedStreamTools.writeTag(compound, output);
    }

    public static void writeTag(StorageBase tag, DataOutput output) throws IOException {
        output.writeByte(tag.getId());
        if (tag.getId() != 0) {
            output.writeUTF("");
            tag.write(output);
        }
    }

    private static StorageBase read(DataInput input, int depth, NBTSizeTracker accounter) throws IOException {
        byte b0 = input.readByte();
        if (b0 == 0) {
            return new StorageTagEnd();
        }
        input.readUTF();
        StorageBase nbtbase = StorageBase.createNewByType(b0);
        try {
            nbtbase.read(input, depth, accounter);
            return nbtbase;
        }
        catch (IOException ioexception) {
            throw new IOException(ioexception);
        }
    }
}

