/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.menu;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;
import simplepets.brainsynder.libs.bslib.menu.Icon;
import simplepets.brainsynder.libs.bslib.menu.OptionClickEvent;
import simplepets.brainsynder.libs.bslib.menu.OptionPage;
import simplepets.brainsynder.libs.bslib.utils.Colorize;

public class IconMenu
implements Listener,
InventoryHolder {
    private final String title;
    private final int size;
    private int currentPage;
    private final int pageCount;
    private OptionPage[] optionPages;
    private Plugin core;
    private UUID player;
    private Inventory inventory;

    public IconMenu(String title, int size, int pageCount, Plugin core) {
        this.title = title;
        this.size = size;
        this.core = core;
        this.player = null;
        this.inventory = null;
        this.optionPages = new OptionPage[pageCount];
        for (int i = 0; i < this.optionPages.length; ++i) {
            this.optionPages[i] = new OptionPage(size);
        }
        this.currentPage = 0;
        this.pageCount = pageCount;
        core.getServer().getPluginManager().registerEvents((Listener)this, core);
    }

    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.player);
    }

    public IconMenu setIcon(int page, int position, Icon icon) {
        this.optionPages[page].optionIcons[position] = icon;
        return this;
    }

    public void open(Player player) {
        this.player = player.getUniqueId();
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.size, (String)Colorize.translateBungeeHex(this.title));
        this.updateContents();
        player.openInventory(this.inventory);
    }

    public void openNextPage() {
        if (this.currentPage + 1 >= this.pageCount) {
            return;
        }
        ++this.currentPage;
        this.updatePage();
    }

    public void openPreviousPage() {
        if (this.currentPage - 1 < 0) {
            return;
        }
        --this.currentPage;
        this.updatePage();
    }

    public void openPage(int page) {
        if (page >= this.pageCount || page < 0) {
            return;
        }
        this.currentPage = page;
        this.updatePage();
    }

    public void updatePage() {
        this.updateContents();
        this.getPlayer().updateInventory();
    }

    private void updateContents() {
        for (int i = 0; i < this.size; ++i) {
            Icon icon = this.optionPages[this.currentPage].optionIcons[i];
            if (icon != null) {
                this.inventory.setItem(i, icon.item);
                continue;
            }
            this.inventory.clear(i);
        }
    }

    public void destroy() {
        HandlerList.unregisterAll((Listener)this);
        this.core = null;
        this.optionPages = null;
        this.player = null;
        this.inventory = null;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInventoryClosed(InventoryCloseEvent event) {
        this.destroy();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getInventory().getHolder() == this) {
            event.setCancelled(true);
            int slot = event.getRawSlot();
            OptionPage currentPage = this.optionPages[this.currentPage];
            if (slot >= 0 && slot < this.size && currentPage.optionIcons[slot] != null) {
                Icon icon = currentPage.optionIcons[slot];
                OptionClickEvent e = new OptionClickEvent((Player)event.getWhoClicked(), slot, this.currentPage, icon);
                Player p = (Player)event.getWhoClicked();
                icon.activate(p, e);
                if (e.willClose()) {
                    Bukkit.getScheduler().scheduleSyncDelayedTask(this.core, () -> ((Player)p).closeInventory(), 1L);
                }
                if (e.willDestroy()) {
                    this.destroy();
                }
            }
        }
    }

    public Inventory getInventory() {
        return null;
    }
}

