/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.item.meta;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.inventory.meta.ItemMeta;
import simplepets.brainsynder.libs.bslib.ServerVersion;
import simplepets.brainsynder.libs.bslib.SupportedVersion;
import simplepets.brainsynder.libs.bslib.item.MetaHandler;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagList;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagTools;
import simplepets.brainsynder.libs.bslib.reflection.Reflection;

@SupportedVersion(version=ServerVersion.v1_14_R1)
public class CrossbowMetaHandler
extends MetaHandler {
    private Method setProjectiles = null;
    private Method getProjectiles = null;

    public CrossbowMetaHandler(ItemMeta meta) {
        super(meta);
        Class clazz = Reflection.getBukkitClass("inventory.meta.CrossbowMeta");
        if (clazz == null) {
            return;
        }
        this.getProjectiles = Reflection.getMethod(clazz, "getChargedProjectiles", new Class[0]);
        this.setProjectiles = Reflection.getMethod(clazz, "setChargedProjectiles", List.class);
    }

    @Override
    public void fromItemMeta(ItemMeta meta) {
        if (this.getProjectiles == null) {
            return;
        }
        StorageTagCompound compound = new StorageTagCompound();
        List projectiles = (List)Reflection.invoke(this.getProjectiles, meta, new Object[0]);
        if (projectiles.isEmpty()) {
            return;
        }
        StorageTagList list = new StorageTagList();
        projectiles.forEach(stack -> list.appendTag(StorageTagTools.fromItemStack(stack)));
        compound.setTag("projectiles", list);
        this.updateCompound(compound);
    }

    @Override
    public void fromCompound(StorageTagCompound compound) {
        super.fromCompound(compound);
        if (this.setProjectiles == null) {
            return;
        }
        this.modifyMeta(value -> {
            if (compound.hasKey("projectiles")) {
                StorageTagList stored = (StorageTagList)compound.getTag("projectiles");
                ArrayList list = new ArrayList();
                stored.getTagList().forEach(storageBase -> list.add(StorageTagTools.toItemStack((StorageTagCompound)storageBase)));
                Reflection.invoke(this.setProjectiles, value, list);
            }
            return value;
        });
    }
}

