/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.item;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.KnowledgeBookMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;
import simplepets.brainsynder.libs.bslib.item.MetaHandler;
import simplepets.brainsynder.libs.bslib.item.meta.BannerMetaHandler;
import simplepets.brainsynder.libs.bslib.item.meta.BookMetaHandler;
import simplepets.brainsynder.libs.bslib.item.meta.CrossbowMetaHandler;
import simplepets.brainsynder.libs.bslib.item.meta.FireworkMetaHandler;
import simplepets.brainsynder.libs.bslib.item.meta.KnowledgeBookMetaHandler;
import simplepets.brainsynder.libs.bslib.item.meta.LeatherArmorMetaHandler;
import simplepets.brainsynder.libs.bslib.item.meta.MapMetaHandler;
import simplepets.brainsynder.libs.bslib.item.meta.PotionMetaHandler;
import simplepets.brainsynder.libs.bslib.item.meta.SkullMetaHandler;
import simplepets.brainsynder.libs.bslib.item.meta.TropicalFishBucketMetaHandler;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;

class ItemTools {
    ItemTools() {
    }

    protected static PlayerProfile createProfile(String data) {
        return ItemTools.createProfile("", data);
    }

    protected static PlayerProfile createProfile(String owner, String data) {
        PlayerProfile profile = Bukkit.createPlayerProfile((UUID)UUID.randomUUID(), (String)(owner.isEmpty() ? "Steve" : owner));
        PlayerTextures textures = profile.getTextures();
        try {
            textures.setSkin(new URL(data));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        profile.setTextures(textures);
        return profile;
    }

    protected static PlayerProfile getGameProfile(SkullMeta meta) {
        return meta.getOwnerProfile();
    }

    protected static String getTexture(PlayerProfile profile) {
        return profile.getTextures().getSkin().toString();
    }

    static MetaHandler getHandler(ItemMeta meta) {
        if (meta == null) {
            return null;
        }
        MetaHandler handler = null;
        if (meta instanceof BannerMeta) {
            handler = new BannerMetaHandler((BannerMeta)meta);
        }
        if (meta instanceof BookMeta) {
            handler = new BookMetaHandler((BookMeta)meta);
        }
        if (meta instanceof FireworkMeta) {
            handler = new FireworkMetaHandler((FireworkMeta)meta);
        }
        if (meta instanceof KnowledgeBookMeta) {
            handler = new KnowledgeBookMetaHandler((KnowledgeBookMeta)meta);
        }
        if (meta instanceof LeatherArmorMeta) {
            handler = new LeatherArmorMetaHandler((LeatherArmorMeta)meta);
        }
        if (meta instanceof MapMeta) {
            handler = new MapMetaHandler((MapMeta)meta);
        }
        if (meta instanceof PotionMeta) {
            handler = new PotionMetaHandler((PotionMeta)meta);
        }
        if (meta instanceof SkullMeta) {
            handler = new SkullMetaHandler((SkullMeta)meta);
        }
        if (ItemTools.isInstance(meta, "TropicalFishBucketMeta")) {
            handler = new TropicalFishBucketMetaHandler(meta);
        }
        if (ItemTools.isInstance(meta, "CrossbowMeta")) {
            handler = new CrossbowMetaHandler(meta);
        }
        if (handler != null && !handler.isSupported()) {
            return null;
        }
        return handler;
    }

    private static boolean isInstance(ItemMeta meta, String name) {
        if (meta.getClass().getInterfaces() == null) {
            return false;
        }
        if (meta.getClass().getInterfaces().length == 0) {
            return false;
        }
        Class<?> metaClass = meta.getClass().getInterfaces()[0];
        String className = metaClass.getSimpleName().replace("Meta", "").replace("Craft", "") + "Meta";
        return name.equals(className);
    }

    static StorageTagCompound toCompound(ItemMeta meta) {
        StorageTagCompound compound = new StorageTagCompound();
        MetaHandler handler = ItemTools.getHandler(meta);
        if (handler != null) {
            compound = handler.getCompound();
        }
        return compound;
    }

    static ItemMeta fromCompound(ItemMeta meta, StorageTagCompound compound) {
        MetaHandler handler = ItemTools.getHandler(meta);
        if (handler != null) {
            handler.fromCompound(compound);
            meta = handler.getMeta();
        }
        return meta;
    }
}

