/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.files;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import simplepets.brainsynder.libs.bslib.files.Movable;
import simplepets.brainsynder.libs.bslib.files.options.YamlOption;
import simplepets.brainsynder.libs.bslib.utils.AdvString;
import simplepets.brainsynder.libs.bslib.utils.Colorize;

public abstract class YamlFile
implements ConfigurationSection,
Movable {
    private File file;
    private FileConfiguration configuration;
    private FileConfiguration tempConfig;
    private final HashMap<String, String> movedKeys = new HashMap();
    private final HashMap<String, String> comments = new HashMap();
    private final HashMap<String, String> sections = new HashMap();
    private final HashMap<String, AdvString.AlignText> sectionAlign = new HashMap();
    private List<String> currentLines = new ArrayList<String>();

    private void createParentDirs(File file) throws IOException {
        Preconditions.checkNotNull((Object)file);
        File parent = file.getCanonicalFile().getParentFile();
        if (parent != null) {
            parent.mkdirs();
            if (!parent.isDirectory()) {
                throw new IOException("Unable to create parent directories of " + String.valueOf(file));
            }
        }
    }

    public YamlFile(Plugin plugin, String directory, String fileName) {
        this(new File(String.valueOf(plugin.getDataFolder()) + File.separator + directory), fileName);
    }

    public YamlFile(File folder, String fileName) {
        this(new File(folder, fileName));
    }

    public YamlFile(File file) {
        try {
            this.createParentDirs(file);
            if (!file.exists()) {
                file.createNewFile();
            }
            if (!file.canWrite()) {
                file.setWritable(true, false);
            }
            if (!file.canRead()) {
                file.setReadable(true, false);
            }
            if (!file.canExecute()) {
                file.setExecutable(true, false);
            }
            this.file = file;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.reload();
    }

    public void reload() {
        if (this.file == null) {
            return;
        }
        if (!this.file.canWrite()) {
            this.file.setWritable(true, false);
        }
        if (!this.file.canRead()) {
            this.file.setReadable(true, false);
        }
        if (!this.file.canExecute()) {
            this.file.setExecutable(true, false);
        }
        this.currentLines = new ArrayList<String>();
        this.configuration = YamlConfiguration.loadConfiguration((File)this.file);
        this.tempConfig = new YamlConfiguration();
        this.loadDefaults();
        this.configuration.options().copyDefaults(true);
        this.save(true);
        this.writeSections();
        this.writeComments();
        this.save(false);
        try {
            this.configuration.load(this.file);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    public abstract void loadDefaults();

    public void remove(YamlOption option) {
        this.remove(option.getPath());
    }

    public void remove(String key) {
        if (this.configuration.contains(key)) {
            this.set(key, null);
        }
    }

    public void addComment(String path, String comment) {
        String key = this.fetchKey(path);
        if (this.comments.containsKey(key)) {
            return;
        }
        this.comments.put(key, comment);
    }

    public void addSectionHeader(String path, String text) {
        this.sections.put(this.fetchKey(path), text);
    }

    public void addSectionHeader(String path, AdvString.AlignText alignText, String text) {
        this.sections.put(this.fetchKey(path), text);
        this.sectionAlign.put(this.fetchKey(path), alignText);
    }

    public void addDefault(String key, Object value) {
        this.configuration.addDefault(this.fetchKey(key), value);
        this.tempConfig.set(this.fetchKey(key), this.configuration.get(key));
    }

    public List<String> getComments(String s) {
        return null;
    }

    public List<String> getInlineComments(String s) {
        return null;
    }

    public void setComments(String s, List<String> list) {
    }

    public void setInlineComments(String s, List<String> list) {
    }

    public void addDefault(String key, Object value, String comment) {
        this.configuration.addDefault(this.fetchKey(key), value);
        this.tempConfig.set(this.fetchKey(key), this.configuration.get(key));
        this.addComment(key, comment);
    }

    public void addDefault(YamlOption option) {
        this.configuration.addDefault(option.getPath(), option.getDefault());
        this.tempConfig.set(option.getPath(), this.configuration.get(option.getPath()));
        if (!option.getComment().isEmpty()) {
            this.addComment(option.getPath(), option.getComment());
        }
    }

    public void addDefault(YamlOption option, String comment) {
        this.configuration.addDefault(option.getPath(), option.getDefault());
        this.tempConfig.set(option.getPath(), this.configuration.get(option.getPath()));
        this.addComment(option.getPath(), comment);
    }

    private void writeComments() {
        for (String path : this.comments.keySet()) {
            String[] divisions = path.split("\\.");
            this.writeComment(path, divisions, 0, 0);
        }
    }

    private void writeComment(String path, String[] divisions, int iteration, int startingLine) {
        StringBuilder indent = new StringBuilder();
        for (int j = 0; j < iteration; ++j) {
            indent.append("  ");
        }
        for (int i = startingLine; i < this.currentLines.size(); ++i) {
            String line = this.currentLines.get(i);
            if (!line.startsWith(indent.toString())) {
                return;
            }
            if (line.startsWith("#") || !line.startsWith(String.valueOf(indent) + divisions[iteration]) && !line.startsWith(String.valueOf(indent) + "'" + divisions[iteration] + "'")) continue;
            if (++iteration == divisions.length) {
                String[] rawComment;
                int currentLine = i;
                if (iteration == 1) {
                    this.currentLines.add(currentLine, "");
                    ++currentLine;
                }
                for (String commentPart : rawComment = this.comments.get(this.fetchKey(path)).split("\n")) {
                    this.currentLines.add(currentLine, String.valueOf(indent) + "# " + commentPart);
                    ++currentLine;
                }
                break;
            }
            this.writeComment(this.fetchKey(path), divisions, iteration, i + 1);
        }
    }

    private void writeSections() {
        for (String path : this.sections.keySet()) {
            String[] divisions = path.split("\\.");
            this.writeSection(path, divisions, 0);
        }
    }

    private void writeSection(String path, String[] divisions, int iteration) {
        StringBuilder indent = new StringBuilder();
        for (int j = 0; j < iteration; ++j) {
            indent.append("  ");
        }
        for (int i = 0; i < this.currentLines.size(); ++i) {
            String line = this.currentLines.get(i);
            if (!line.startsWith(String.valueOf(indent) + divisions[iteration]) && !line.startsWith(String.valueOf(indent) + "'" + divisions[iteration] + "'")) continue;
            if (++iteration == divisions.length) {
                String section = this.sections.get(this.fetchKey(path));
                StringBuilder length = new StringBuilder();
                length.append("###");
                ArrayList<String> sectionList = new ArrayList<String>(Arrays.asList(section.split("\n")));
                int largestString = ((String)sectionList.get(0)).length();
                for (String s : sectionList) {
                    if (s.length() <= largestString) continue;
                    largestString = s.length();
                }
                for (int j = 0; j < largestString; ++j) {
                    length.append("#");
                }
                length.append("###");
                this.currentLines.add(i, String.valueOf(indent) + length.toString());
                for (int l = sectionList.size() - 1; l > -1; --l) {
                    String s;
                    s = (String)sectionList.get(l);
                    this.currentLines.add(i, String.valueOf(indent) + "#  " + AdvString.getPaddedString(s, ' ', largestString, this.sectionAlign.getOrDefault(path, AdvString.AlignText.CENTER)) + "  #");
                }
                this.currentLines.add(i, String.valueOf(indent) + length.toString());
                this.currentLines.add(i, "");
                break;
            }
            this.writeSection(this.fetchKey(path), divisions, iteration);
        }
    }

    private void save(boolean isConfig) {
        try {
            if (isConfig) {
                String currentLine;
                this.tempConfig.save(this.file);
                FileInputStream stream = new FileInputStream(this.file);
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, Charsets.UTF_8));
                while ((currentLine = reader.readLine()) != null) {
                    if (currentLine.startsWith("#")) continue;
                    this.currentLines.add(currentLine);
                }
                reader.close();
            } else {
                FileOutputStream stream = new FileOutputStream(this.file);
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)stream, Charsets.UTF_8));
                for (String line : this.currentLines) {
                    writer.write(line);
                    writer.write("\n");
                }
                writer.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public String getString(YamlOption option, boolean color) {
        return color ? this.translate(this.getString(option)) : this.getString(option);
    }

    public String getString(String tag, boolean color) {
        return color ? this.translate(this.getString(tag)) : this.getString(tag);
    }

    public String getString(String tag) {
        return this.getString(tag, "");
    }

    public String getString(String tag, String fallback) {
        if (!this.contains(tag)) {
            return fallback;
        }
        return this.configuration.getString(this.fetchKey(tag), fallback);
    }

    public String getString(YamlOption option) {
        return this.getString(option.getPath(), String.valueOf(option.getDefault()));
    }

    public boolean isString(String tag) {
        return this.configuration.isString(this.fetchKey(tag));
    }

    public ItemStack getItemStack(String tag) {
        return this.getItemStack(tag, new ItemStack(Material.AIR));
    }

    public ItemStack getItemStack(String tag, ItemStack fallback) {
        if (!this.contains(tag)) {
            return fallback;
        }
        return this.configuration.getItemStack(this.fetchKey(tag), fallback);
    }

    public boolean isItemStack(String tag) {
        return this.configuration.isItemStack(this.fetchKey(tag));
    }

    public Color getColor(String tag) {
        return this.getColor(tag, Color.WHITE);
    }

    public Color getColor(String tag, Color fallback) {
        if (!this.contains(tag)) {
            return fallback;
        }
        return this.configuration.getColor(this.fetchKey(tag), fallback);
    }

    public boolean isColor(String tag) {
        return this.configuration.isColor(this.fetchKey(tag));
    }

    public ConfigurationSection getConfigurationSection(String tag) {
        return this.configuration.getConfigurationSection(this.fetchKey(tag));
    }

    public boolean isConfigurationSection(String tag) {
        return this.configuration.isConfigurationSection(this.fetchKey(tag));
    }

    public ConfigurationSection getDefaultSection() {
        return this.configuration.getDefaultSection();
    }

    public boolean getBoolean(String tag) {
        return this.getBoolean(tag, false);
    }

    public boolean getBoolean(YamlOption option) {
        return this.getBoolean(option.getPath(), (Boolean)option.getDefault());
    }

    public boolean getBoolean(String tag, boolean fallback) {
        if (!this.contains(tag)) {
            return fallback;
        }
        return this.configuration.getBoolean(this.fetchKey(tag), fallback);
    }

    public boolean isBoolean(String tag) {
        return this.configuration.isBoolean(this.fetchKey(tag));
    }

    public int getInt(String tag) {
        return this.getInt(tag, 0);
    }

    public int getInt(YamlOption option) {
        return this.getInt(option.getPath(), Integer.parseInt(String.valueOf(option.getDefault())));
    }

    public int getInt(String tag, int fallback) {
        if (!this.contains(tag)) {
            return fallback;
        }
        return this.configuration.getInt(this.fetchKey(tag), fallback);
    }

    public boolean isInt(String tag) {
        return this.configuration.isInt(this.fetchKey(tag));
    }

    public double getDouble(String tag) {
        return this.getDouble(tag, 0.0);
    }

    public double getDouble(YamlOption option) {
        return this.getDouble(option.getPath(), Double.parseDouble(String.valueOf(option.getDefault())));
    }

    public double getDouble(String tag, double fallback) {
        if (!this.contains(tag)) {
            return fallback;
        }
        return this.configuration.getDouble(this.fetchKey(tag), fallback);
    }

    public boolean isDouble(String tag) {
        return this.configuration.isDouble(this.fetchKey(tag));
    }

    public long getLong(String tag) {
        return this.getLong(tag, 0L);
    }

    public long getLong(YamlOption option) {
        return this.getLong(option.getPath(), Long.parseLong(String.valueOf(option.getDefault())));
    }

    public long getLong(String tag, long fallback) {
        if (!this.contains(tag)) {
            return fallback;
        }
        return this.configuration.getLong(this.fetchKey(tag), fallback);
    }

    public boolean isLong(String tag) {
        return this.configuration.isLong(this.fetchKey(tag));
    }

    public List<?> getList(String tag) {
        return this.configuration.getList(this.fetchKey(tag));
    }

    public List<?> getList(String tag, List<?> fallback) {
        if (!this.contains(tag)) {
            return fallback;
        }
        return this.configuration.getList(this.fetchKey(tag), fallback);
    }

    public boolean isList(String tag) {
        return this.configuration.isList(this.fetchKey(tag));
    }

    public Set<String> getKeys(boolean deep) {
        return this.configuration.getKeys(deep);
    }

    public Map<String, Object> getValues(boolean b) {
        return this.configuration.getValues(b);
    }

    public boolean contains(String tag) {
        return this.configuration.get(this.fetchKey(tag)) != null;
    }

    public boolean contains(YamlOption option) {
        return this.configuration.get(this.fetchKey(option.getPath())) != null;
    }

    public boolean contains(String tag, boolean ignoreDefault) {
        return this.configuration.contains(this.fetchKey(tag), ignoreDefault);
    }

    public boolean isSet(String tag) {
        return this.configuration.isSet(this.fetchKey(tag));
    }

    public String getCurrentPath() {
        return this.configuration.getCurrentPath();
    }

    public String getName() {
        return this.configuration.getName();
    }

    public Configuration getRoot() {
        return this.configuration.getRoot();
    }

    public ConfigurationSection getParent() {
        return this.configuration.getParent();
    }

    public List<String> getStringList(String tag) {
        return this.getStringList(tag, new ArrayList<String>());
    }

    public List<String> getStringList(String tag, List<String> fallback) {
        if (!this.contains(tag)) {
            return fallback;
        }
        return this.configuration.getStringList(this.fetchKey(tag));
    }

    public List<Integer> getIntegerList(String tag) {
        return this.configuration.getIntegerList(this.fetchKey(tag));
    }

    public List<Boolean> getBooleanList(String tag) {
        return this.configuration.getBooleanList(this.fetchKey(tag));
    }

    public List<Double> getDoubleList(String tag) {
        return this.configuration.getDoubleList(this.fetchKey(tag));
    }

    public List<Float> getFloatList(String tag) {
        return this.configuration.getFloatList(this.fetchKey(tag));
    }

    public List<Long> getLongList(String tag) {
        return this.configuration.getLongList(this.fetchKey(tag));
    }

    public List<Byte> getByteList(String tag) {
        return this.configuration.getByteList(this.fetchKey(tag));
    }

    public List<Character> getCharacterList(String tag) {
        return this.configuration.getCharacterList(this.fetchKey(tag));
    }

    public List<Short> getShortList(String tag) {
        return this.configuration.getShortList(this.fetchKey(tag));
    }

    public List<Map<?, ?>> getMapList(String tag) {
        return this.configuration.getMapList(this.fetchKey(tag));
    }

    public <T> T getObject(String s, Class<T> aClass) {
        return (T)this.configuration.getObject(this.fetchKey(s), aClass);
    }

    public <T> T getObject(String s, Class<T> aClass, T t) {
        return (T)this.configuration.getObject(this.fetchKey(s), aClass, t);
    }

    public <T extends ConfigurationSerializable> T getSerializable(String s, Class<T> aClass) {
        return (T)this.configuration.getSerializable(this.fetchKey(s), aClass);
    }

    public <T extends ConfigurationSerializable> T getSerializable(String s, Class<T> aClass, T t) {
        return (T)this.configuration.getSerializable(this.fetchKey(s), aClass, t);
    }

    public Vector getVector(String tag) {
        return this.configuration.getVector(this.fetchKey(tag));
    }

    public Vector getVector(String tag, Vector fallback) {
        if (!this.contains(tag)) {
            return fallback;
        }
        return this.configuration.getVector(this.fetchKey(tag), fallback);
    }

    public boolean isVector(String tag) {
        return this.configuration.isVector(this.fetchKey(tag));
    }

    public OfflinePlayer getOfflinePlayer(String tag) {
        return this.configuration.getOfflinePlayer(this.fetchKey(tag));
    }

    public OfflinePlayer getOfflinePlayer(String tag, OfflinePlayer fallback) {
        if (!this.contains(tag)) {
            return fallback;
        }
        return this.configuration.getOfflinePlayer(this.fetchKey(tag), fallback);
    }

    public boolean isOfflinePlayer(String tag) {
        return this.configuration.isOfflinePlayer(this.fetchKey(tag));
    }

    public ConfigurationSection getSection(String tag) {
        return this.configuration.getConfigurationSection(this.fetchKey(tag));
    }

    public Object get(String tag) {
        return this.configuration.get(this.fetchKey(tag));
    }

    public Object get(YamlOption option) {
        return this.get(option.getPath(), option.getDefault());
    }

    public Object get(String tag, Object fallback) {
        if (!this.contains(tag)) {
            return fallback;
        }
        return this.configuration.get(this.fetchKey(tag));
    }

    private String translate(String msg) {
        return Colorize.translateBungeeHex(msg);
    }

    public void set(YamlOption option, Object data) {
        this.set(option.getPath(), data);
    }

    public void set(String tag, Object data) {
        this.set(tag, data, true);
    }

    public void set(String tag, Object data, boolean save) {
        this.currentLines = new ArrayList<String>();
        this.configuration.set(this.fetchKey(tag), data);
        this.tempConfig.set(this.fetchKey(tag), data);
        if (save) {
            this.save();
        }
    }

    public void save() {
        this.save(true);
        this.writeSections();
        this.writeComments();
        this.save(false);
    }

    public ConfigurationSection createSection(String tag) {
        return this.configuration.createSection(this.fetchKey(tag));
    }

    public ConfigurationSection createSection(String tag, Map<?, ?> fallback) {
        return this.configuration.createSection(this.fetchKey(tag), fallback);
    }

    public void setHeader(String ... header) {
        this.configuration.options().header(Arrays.toString(header));
    }

    public Map<String, Object> getConfigSectionValue(Object o) {
        return this.getConfigSectionValue(o, false);
    }

    public Map<String, Object> getConfigSectionValue(Object o, boolean deep) {
        this.configuration = YamlConfiguration.loadConfiguration((File)this.file);
        Map<String, Object> map = new HashMap<String, Object>();
        if (o == null) {
            return map;
        }
        if (o instanceof ConfigurationSection) {
            map = ((ConfigurationSection)o).getValues(deep);
        } else if (o instanceof Map) {
            map = (Map)o;
        }
        return map;
    }

    @Override
    public boolean move(String oldKey, String newKey) {
        if (this.contains(oldKey)) {
            this.movedKeys.putIfAbsent(oldKey, newKey);
            if (!this.comments.containsKey(newKey) && this.comments.containsKey(oldKey)) {
                this.comments.put(newKey, this.comments.get(oldKey));
            }
            if (!this.sections.containsKey(newKey) && this.sections.containsKey(oldKey)) {
                this.sections.put(newKey, this.sections.get(oldKey));
            }
            this.set(newKey, this.get(oldKey));
            this.set(oldKey, null);
            return true;
        }
        return false;
    }

    @Override
    public void registerMovedKeys(String newKey, String ... oldKeys) {
        Lists.newArrayList((Object[])oldKeys).forEach(oldKey -> this.movedKeys.putIfAbsent((String)oldKey, newKey));
    }

    public String fetchKey(String key) {
        if (key == null) {
            return null;
        }
        if (key.isEmpty()) {
            return key;
        }
        return this.movedKeys.getOrDefault(key, key);
    }

    public Location getLocation(String path) {
        return this.getSerializable(this.fetchKey(path), Location.class);
    }

    public Location getLocation(String path, Location def) {
        return this.getSerializable(this.fetchKey(path), Location.class, def);
    }

    public boolean isLocation(String path) {
        return this.getSerializable(this.fetchKey(path), Location.class) != null;
    }

    public File getFile() {
        return this.file;
    }
}

