/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.files;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.List;
import simplepets.brainsynder.libs.bslib.files.Movable;
import simplepets.brainsynder.libs.bslib.json.Json;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.json.JsonValue;
import simplepets.brainsynder.libs.bslib.json.WriterConfig;

public abstract class JsonFile
implements Movable {
    private final Charset ENCODE = Charsets.UTF_8;
    private JsonObject json;
    protected JsonObject defaults = new JsonObject();
    private final File file;
    private boolean update = false;

    public JsonFile(File file) {
        this(file, true);
    }

    public JsonFile(File file, boolean loadDefaults) {
        this.file = file;
        if (loadDefaults) {
            this.reload();
        }
    }

    public abstract void loadDefaults();

    public void reload() {
        try {
            if (!this.file.getParentFile().exists()) {
                this.file.getParentFile().mkdirs();
            }
            boolean defaultsLoaded = false;
            if (!this.file.exists()) {
                this.loadDefaults();
                defaultsLoaded = true;
                OutputStreamWriter pw = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), this.ENCODE);
                pw.write(this.defaults.toString(WriterConfig.PRETTY_PRINT).replace("&", "&"));
                pw.flush();
                pw.close();
            }
            this.json = (JsonObject)Json.parse(new InputStreamReader((InputStream)new FileInputStream(this.file), this.ENCODE));
            if (!defaultsLoaded) {
                this.loadDefaults();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean save() {
        return this.save(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save(boolean clearFile) {
        String text = this.json.toString(WriterConfig.PRETTY_PRINT).replace("&", "&");
        if (this.file.exists() && clearFile) {
            this.file.delete();
            try {
                this.file.createNewFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), this.ENCODE);
            try {
                fw.write(text);
            }
            finally {
                fw.flush();
                fw.close();
            }
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public List<String> getKeys() {
        return this.json.names();
    }

    public String getName() {
        return this.file.getName().replace(".json", "");
    }

    public boolean containsKey(String key) {
        return this.hasKey(key) || this.hasDefaultKey(key);
    }

    public boolean hasKey(String key) {
        return this.json.names().contains(key);
    }

    private boolean hasDefaultKey(String key) {
        return this.defaults.names().contains(key);
    }

    public JsonValue getValue(String key) {
        JsonValue value = null;
        if (this.hasKey(key)) {
            value = this.json.get(key);
        }
        if (value == null && this.hasDefaultKey(key)) {
            value = this.defaults.get(key);
        }
        return value;
    }

    public JsonValue getDefaultValue(String key) {
        if (!this.hasDefaultKey(key)) {
            return null;
        }
        return this.defaults.get(key);
    }

    public String getString(String key) {
        return this.getString(key, "");
    }

    public String getString(String key, String fallback) {
        JsonValue value = this.getValue(key);
        if (value == null) {
            return fallback;
        }
        return value.asString();
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double fallback) {
        JsonValue value = this.getValue(key);
        if (value == null) {
            return fallback;
        }
        if (value.isString()) {
            return Double.parseDouble(value.asString());
        }
        return value.asDouble();
    }

    public byte getByte(String key) {
        return this.getByte(key, (byte)0);
    }

    public byte getByte(String key, byte fallback) {
        JsonValue value = this.getValue(key);
        if (value == null) {
            return fallback;
        }
        if (value.isString()) {
            return Byte.parseByte(value.asString());
        }
        return (byte)value.asInt();
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean fallback) {
        JsonValue value = this.getValue(key);
        if (value == null) {
            return fallback;
        }
        try {
            if (value.isString()) {
                return Boolean.parseBoolean(value.asString());
            }
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            return fallback;
        }
        return value.asBoolean();
    }

    public short getShort(String key) {
        return this.getShort(key, (short)0);
    }

    public short getShort(String key, short fallback) {
        JsonValue value = this.getValue(key);
        if (value == null) {
            return fallback;
        }
        if (value.isString()) {
            return Short.parseShort(value.asString());
        }
        return (short)value.asLong();
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public float getFloat(String key, float fallback) {
        JsonValue value = this.getValue(key);
        if (value == null) {
            return fallback;
        }
        if (value.isString()) {
            return Float.parseFloat(value.asString());
        }
        return value.asFloat();
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long fallback) {
        JsonValue value = this.getValue(key);
        if (value == null) {
            return fallback;
        }
        if (value.isString()) {
            return Long.parseLong(value.asString());
        }
        return value.asLong();
    }

    public int getInteger(String key) {
        return this.getInteger(key, 0);
    }

    public int getInteger(String key, int fallback) {
        JsonValue value = this.getValue(key);
        if (value == null) {
            return fallback;
        }
        if (value.isString()) {
            return Integer.parseInt(value.asString());
        }
        return value.asInt();
    }

    public void set(String key, int value) {
        this.update = true;
        this.json.set(key, value);
    }

    public void set(String key, long value) {
        this.update = true;
        this.json.set(key, value);
    }

    public void set(String key, float value) {
        this.update = true;
        this.json.set(key, value);
    }

    public void set(String key, short value) {
        this.update = true;
        this.json.set(key, value);
    }

    public void set(String key, byte value) {
        this.update = true;
        this.json.set(key, value);
    }

    public void set(String key, double value) {
        this.update = true;
        this.json.set(key, value);
    }

    public void set(String key, boolean value) {
        this.update = true;
        this.json.set(key, value);
    }

    public void set(String key, String value) {
        this.update = true;
        this.json.set(key, value);
    }

    public void set(String key, JsonValue value) {
        this.update = true;
        this.json.set(key, value);
    }

    public void remove(String key) {
        boolean update = false;
        if (this.defaults.names().contains(key)) {
            update = true;
            this.defaults.remove(key);
        }
        if (this.json.names().contains(key)) {
            update = true;
            this.json.remove(key);
        }
        if (update) {
            this.save();
        }
    }

    public void setDefault(String key, int value) {
        this.defaults.add(key, value);
    }

    public void setDefault(String key, long value) {
        this.defaults.add(key, value);
    }

    public void setDefault(String key, float value) {
        this.defaults.add(key, value);
    }

    public void setDefault(String key, short value) {
        this.defaults.add(key, value);
    }

    public void setDefault(String key, byte value) {
        this.defaults.add(key, value);
    }

    public void setDefault(String key, double value) {
        this.defaults.add(key, value);
    }

    public void setDefault(String key, boolean value) {
        this.defaults.add(key, value);
    }

    public void setDefault(String key, String value) {
        this.defaults.add(key, value);
    }

    public void setDefault(String key, JsonValue value) {
        this.defaults.add(key, value);
    }

    @Override
    public boolean move(String oldKey, String newKey) {
        if (this.hasKey(oldKey)) {
            this.json.set(newKey, this.getValue(oldKey));
            this.json.remove(oldKey);
            this.save();
            return true;
        }
        return false;
    }

    public File getFile() {
        return this.file;
    }
}

