/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.commands;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.StringUtil;
import simplepets.brainsynder.libs.bslib.commands.annotations.ICommand;
import simplepets.brainsynder.libs.bslib.nms.Tellraw;
import simplepets.brainsynder.libs.bslib.utils.Colorize;
import simplepets.brainsynder.libs.bslib.utils.ReturnValue;

public class SubCommand
implements CommandExecutor,
TabCompleter {
    private final Map<Integer, List<String>> tabCompletion = new HashMap<Integer, List<String>>();
    private final Map<Integer, List<Complete>> tabCompletionArg = new HashMap<Integer, List<Complete>>();
    private final List<String> tabKeyWords = new ArrayList<String>();
    private String masterFormat;

    public void run(CommandSender sender) {
        this.run(sender, new String[0]);
    }

    public void run(CommandSender sender, String[] args) {
        this.run(sender);
    }

    public void setMasterFormat(String masterFormat) {
        this.masterFormat = masterFormat;
    }

    public String getMasterFormat() {
        return this.masterFormat;
    }

    protected void registerTabCompleteKeyword(String keyword) {
        this.tabKeyWords.add(keyword);
    }

    public List<String> fetchCompletionsFromKeyword(String keyword, List<String> completions, CommandSender sender, int index, String[] args) {
        return completions;
    }

    public List<String> handleCompletions(List<String> completions, CommandSender sender, int index, String[] args) {
        ICommand command = this.getCommand(this.getClass());
        if (command == null) {
            return completions;
        }
        String usage = command.usage();
        if (usage.isEmpty()) {
            return completions;
        }
        String[] split = usage.split(" ");
        int current = 1;
        for (String value : split) {
            for (String keyword : this.tabKeyWords) {
                if (current != index || !value.contains(keyword)) continue;
                completions.addAll(this.fetchCompletionsFromKeyword(keyword, completions, sender, index, args));
                return completions;
            }
            ++current;
        }
        String string = "";
        if (args.length != 0) {
            string = args[index - 1];
        }
        for (String keyword : this.tabKeyWords) {
            if (!keyword.startsWith(string)) continue;
            completions.addAll(this.fetchCompletionsFromKeyword(keyword, completions, sender, index, args));
            return completions;
        }
        return completions;
    }

    protected void registerCompletion(int length, List<String> replacements) {
        Objects.requireNonNull(replacements, "Arguments cannot be null");
        this.tabCompletion.put(length, replacements);
    }

    protected void registerCompletion(int length, Complete complete) {
        Objects.requireNonNull(complete, "Arguments cannot be null");
        List completes = this.tabCompletionArg.getOrDefault(length, new ArrayList());
        completes.add(complete);
        this.tabCompletionArg.put(length, completes);
    }

    public String getUsageStyle() {
        ICommand command = this.getCommand(this.getClass());
        if (command == null || command.style().isEmpty()) {
            return "/{name} {usage} - {description}";
        }
        return command.style();
    }

    public void sendUsage(CommandSender sender) {
        ICommand command = this.getCommand(this.getClass());
        if (command == null) {
            return;
        }
        String usage = command.usage();
        String description = command.description();
        String style = command.consoleStyle();
        if (sender instanceof Player) {
            style = this.getUsageStyle();
        }
        if (this.masterFormat != null) {
            style = this.masterFormat;
        }
        style = style.replace("{name}", command.name());
        style = style.replace("{usage}", usage.isEmpty() ? "" : usage);
        if (sender instanceof Player) {
            style = Colorize.translateBungeeHex(style.replace(" - {description}", ""));
            Tellraw.fromLegacy(style).tooltip(String.valueOf(ChatColor.GRAY) + description).send((Player)sender);
        } else {
            style = style.replace("{description}", description.isEmpty() ? "" : description);
            sender.sendMessage(Colorize.translateBungeeHex(style.replace("/", " - ")));
        }
    }

    public ICommand getCommand(Class<?> clazz) {
        if (!clazz.isAnnotationPresent(ICommand.class)) {
            return null;
        }
        return clazz.getAnnotation(ICommand.class);
    }

    private boolean failedLastCompletion(String[] args, List<Complete> previous, int index, CommandSender sender, String last) {
        List replace = this.tabCompletion.getOrDefault(index, new ArrayList());
        for (Complete complete : previous) {
            if (complete.handleReplacement(sender, replace, last.toLowerCase(Locale.ENGLISH))) continue;
            return false;
        }
        replace.addAll(this.handleCompletions(Lists.newArrayList(), sender, index, args));
        return replace.isEmpty();
    }

    public Map<Integer, List<String>> getTabCompletion() {
        return this.tabCompletion;
    }

    public void tabComplete(List<String> completions, CommandSender sender, String[] args) {
        List<String> strings;
        List completes;
        Objects.requireNonNull(sender, "Sender cannot be null");
        Objects.requireNonNull(args, "Arguments cannot be null");
        int length = args.length;
        if (length == 0) {
            return;
        }
        try {
            int previous = length - 1;
            if (length - 3 >= 0 && this.failedLastCompletion(args, this.tabCompletionArg.getOrDefault(previous, new ArrayList()), previous, sender, args[length - 3])) {
                return;
            }
        }
        catch (Exception previous) {
            // empty catch block
        }
        String toComplete = args[length - 1].toLowerCase(Locale.ENGLISH);
        ArrayList<String> replacements = this.tabCompletion.getOrDefault(length, new ArrayList());
        if (!(this.tabCompletion.isEmpty() && this.tabCompletionArg.isEmpty() || length - 2 < 0 || (completes = (List)this.tabCompletionArg.getOrDefault(length, new ArrayList())).isEmpty())) {
            for (Complete complete : completes) {
                ArrayList<String> replace;
                if (!complete.handleReplacement(sender, replace = new ArrayList<String>(), args[length - 2].toLowerCase(Locale.ENGLISH))) continue;
                replacements = replace;
                break;
            }
        }
        if (!(strings = this.handleCompletions(Lists.newArrayList(), sender, length, args)).isEmpty()) {
            for (String s : strings) {
                if (replacements.contains(s)) continue;
                replacements.add(s);
            }
        }
        for (String command : replacements) {
            if (command.isEmpty() || !StringUtil.startsWithIgnoreCase((String)net.md_5.bungee.api.ChatColor.stripColor((String)command), (String)net.md_5.bungee.api.ChatColor.stripColor((String)toComplete))) continue;
            completions.add(command);
        }
    }

    public boolean canExecute(CommandSender sender) {
        return true;
    }

    public String messageMaker(String[] args, int start) {
        StringBuilder builder = new StringBuilder();
        for (int i = start; i < args.length; ++i) {
            builder.append(args[i]).append(" ");
        }
        return builder.toString().trim();
    }

    public boolean onCommand(CommandSender sender, Command command, String s, String[] args) {
        if (args.length == 0) {
            if (this.canExecute(sender)) {
                this.run(sender);
            }
        } else if (this.canExecute(sender)) {
            this.run(sender, args);
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String s, String[] args) {
        Objects.requireNonNull(sender, "Sender cannot be null");
        Objects.requireNonNull(args, "Arguments cannot be null");
        ArrayList<String> completions = new ArrayList<String>();
        this.tabComplete(completions, sender, args);
        if (!completions.isEmpty()) {
            return completions;
        }
        return new ArrayList<String>();
    }

    String[] newArgs(String[] args) {
        ArrayList newArgs = new ArrayList();
        Collections.addAll(newArgs, args);
        newArgs.remove(0);
        return newArgs.toArray(new String[newArgs.size()]);
    }

    public void send(Argument argument, ReturnValue<Player> value) {
        ArrayList<String> targets = new ArrayList<String>();
        argument.target(targets);
        targets.forEach(arg -> this.send((String)arg, value));
    }

    public void send(Argument argument, ReturnValue<Player> value, ReturnValue<ReturnType> type) {
        ArrayList<String> targets = new ArrayList<String>();
        argument.target(targets);
        targets.forEach(arg -> this.send((String)arg, value, type));
    }

    public void send(String argument, ReturnValue<Player> value) {
        this.send(argument, value, (ReturnType value1) -> {});
    }

    public void send(String argument, ReturnValue<Player> value, ReturnValue<ReturnType> type) {
        if (argument.equals("@a")) {
            type.run(ReturnType.SUCCESS);
            Bukkit.getOnlinePlayers().forEach(value::run);
            return;
        }
        if (argument.startsWith("team=")) {
            Team team = Bukkit.getScoreboardManager().getMainScoreboard().getTeam(argument.replaceFirst("team=", ""));
            if (team == null) {
                type.run(ReturnType.NO_TEAM);
                return;
            }
            type.run(ReturnType.SUCCESS);
            for (String name : team.getEntries()) {
                Player target = Bukkit.getPlayer((String)name);
                if (target == null) continue;
                value.run(target);
            }
            return;
        }
        try {
            UUID uuid = UUID.fromString(argument);
            Player target = Bukkit.getPlayer((UUID)uuid);
            if (target == null) {
                type.run(ReturnType.NO_PLAYER);
                return;
            }
            type.run(ReturnType.SUCCESS);
            value.run(target);
            return;
        }
        catch (Exception uuid) {
            Player target = Bukkit.getPlayer((String)argument);
            if (target == null) {
                type.run(ReturnType.NO_PLAYER);
                return;
            }
            type.run(ReturnType.SUCCESS);
            value.run(target);
            return;
        }
    }

    public List<String> getOnlinePlayers() {
        ArrayList<String> list = new ArrayList<String>();
        Bukkit.getOnlinePlayers().forEach(player -> list.add(player.getName()));
        return list;
    }

    protected static interface Complete {
        public boolean handleReplacement(CommandSender var1, List<String> var2, String var3);
    }

    public static interface Argument {
        public void target(List<String> var1);
    }

    public static enum ReturnType {
        SUCCESS,
        NO_TEAM,
        NO_PLAYER;

    }
}

