/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib.anvil;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import simplepets.brainsynder.libs.bslib.anvil.AnvilClickEvent;
import simplepets.brainsynder.libs.bslib.anvil.AnvilSlot;
import simplepets.brainsynder.libs.bslib.anvil.IAnvilClickEvent;
import simplepets.brainsynder.libs.bslib.reflection.NMSManager;
import simplepets.brainsynder.libs.bslib.reflection.Reflection;
import simplepets.brainsynder.libs.bslib.utils.Colorize;

public class AnvilGUI {
    private final Plugin plugin;
    private boolean colorrename = true;
    private final Player player;
    private String title;
    private String defaultText = "";
    private Inventory inventory;
    private final HashMap<AnvilSlot, ItemStack> items = new HashMap();
    private final Listener listener;
    private final IAnvilClickEvent handler;
    private Class<?> blockPosition;
    private Class<?> playOutOpenWindow;
    private Class<?> containerAnvil;
    private Class<?> chatMessage;
    private Class<?> human;
    private Class<?> containerAccess;
    private Class<?> containers;
    private Method serializerMethod;
    private boolean useNewVersion;

    private void loadClasses() {
        this.useNewVersion = NMSManager.useNewVersion();
        this.blockPosition = NMSManager.getNMSClass("BlockPosition");
        this.playOutOpenWindow = NMSManager.getNMSClass("PacketPlayOutOpenWindow");
        this.containerAnvil = NMSManager.getNMSClass("ContainerAnvil");
        this.chatMessage = NMSManager.getNMSClass("ChatMessage");
        this.human = NMSManager.getNMSClass("EntityHuman");
        Class<?> chatSerializer = Reflection.getNmsClass("IChatBaseComponent$ChatSerializer", "network.chat");
        this.serializerMethod = Reflection.getMethod(chatSerializer, new String[]{"a", "fromJson"}, String.class);
        if (this.useNewVersion) {
            this.containerAccess = NMSManager.getNMSClass("ContainerAccess");
            this.containers = NMSManager.getNMSClass("Containers");
        }
    }

    public boolean getColorRename() {
        return this.colorrename;
    }

    public void setColorRename(boolean value) {
        this.colorrename = value;
    }

    public Player getPlayer() {
        return this.player;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String builder) {
        this.title = builder;
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public void setDefaultText(String defaultText) {
        this.defaultText = defaultText;
    }

    public ItemStack getSlot(AnvilSlot slot) {
        return this.items.get((Object)slot);
    }

    public void setSlot(AnvilSlot slot, ItemStack stack) {
        this.items.put(slot, stack);
    }

    public String getSlotName(AnvilSlot slot) {
        ItemStack stack = this.getSlot(slot);
        if (stack != null && stack.hasItemMeta()) {
            ItemMeta meta = stack.getItemMeta();
            return meta.hasDisplayName() ? meta.getDisplayName() : "";
        }
        return "";
    }

    public void setSlotName(AnvilSlot slot, String name) {
        ItemStack stack = this.getSlot(slot);
        if (stack != null) {
            ItemMeta meta = stack.getItemMeta();
            meta.setDisplayName(name != null ? Colorize.translateBungeeHex(name) : null);
            stack.setItemMeta(meta);
            this.setSlot(slot, stack);
        }
    }

    public AnvilGUI(Plugin plugin, Player player, IAnvilClickEvent handler) {
        this.plugin = plugin;
        this.loadClasses();
        this.player = player;
        this.handler = handler;
        this.listener = new Listener(){

            @EventHandler
            public void invClick(InventoryClickEvent event) {
                if (event.getInventory().equals((Object)AnvilGUI.this.inventory)) {
                    ItemMeta meta;
                    event.setCancelled(true);
                    if (event.getClick() != ClickType.LEFT && event.getClick() != ClickType.RIGHT) {
                        return;
                    }
                    ItemStack stack = event.getCurrentItem();
                    int slot = event.getRawSlot();
                    String text = null;
                    if (stack != null && stack.hasItemMeta() && (meta = stack.getItemMeta()).hasDisplayName()) {
                        text = meta.getDisplayName();
                    }
                    AnvilClickEvent clickEvent = new AnvilClickEvent(event.getInventory(), AnvilSlot.bySlot(slot), text, stack);
                    AnvilGUI.this.handler.onAnvilClick(clickEvent);
                    if (clickEvent.getWillClose() || clickEvent.getWillDestroy()) {
                        event.getWhoClicked().closeInventory();
                    }
                    if (clickEvent.getWillDestroy()) {
                        HandlerList.unregisterAll((Listener)AnvilGUI.this.listener);
                    }
                }
            }

            @EventHandler
            public void prepare(PrepareAnvilEvent event) {
                if (event.getInventory().equals((Object)AnvilGUI.this.inventory)) {
                    ItemStack stack = event.getResult();
                    if (AnvilGUI.this.colorrename && stack != null && stack.hasItemMeta()) {
                        ItemMeta meta = stack.getItemMeta();
                        if (meta.hasDisplayName()) {
                            meta.setDisplayName(Colorize.translateBungeeHex(meta.getDisplayName()));
                        }
                        stack.setItemMeta(meta);
                        event.setResult(stack);
                    }
                }
            }

            @EventHandler
            public void ICE(InventoryCloseEvent event) {
                if (event.getInventory().equals((Object)AnvilGUI.this.inventory)) {
                    AnvilGUI.this.player.setLevel(AnvilGUI.this.player.getLevel() - 1);
                    AnvilGUI.this.inventory.clear();
                    HandlerList.unregisterAll((Listener)AnvilGUI.this.listener);
                }
            }

            @EventHandler
            public void PQE(PlayerQuitEvent event) {
                if (event.getPlayer().equals((Object)AnvilGUI.this.player)) {
                    AnvilGUI.this.player.setLevel(AnvilGUI.this.player.getLevel() - 1);
                    HandlerList.unregisterAll((Listener)AnvilGUI.this.listener);
                }
            }
        };
        Bukkit.getPluginManager().registerEvents(this.listener, this.plugin);
    }

    public void open() {
        this.open(this.title);
    }

    public void open(String title) {
        this.player.setLevel(this.player.getLevel() + 1);
        Object serializer = Reflection.invoke(this.serializerMethod, null, Colorize.convertParts2Json(Colorize.splitMessageToParts(title)).toString());
        try {
            Object handle = NMSManager.getHandle(this.player);
            if (this.useNewVersion) {
                Method CAM = NMSManager.getMethod("at", this.containerAccess, NMSManager.getNMSClass("World"), this.blockPosition);
                Object CA = this.containerAnvil.getConstructor(Integer.TYPE, NMSManager.getNMSClass("PlayerInventory"), this.containerAccess).newInstance(9, NMSManager.getPlayerField(this.player, "inventory"), CAM.invoke(this.containerAccess, NMSManager.getPlayerField(this.player, "world"), this.blockPosition.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(0, 0, 0)));
                NMSManager.getField(NMSManager.getNMSClass("Container"), "checkReachable").set(CA, false);
                this.inventory = (Inventory)NMSManager.invokeMethod("getTopInventory", NMSManager.invokeMethod("getBukkitView", CA));
                for (AnvilSlot AS : this.items.keySet()) {
                    this.inventory.setItem(AS.getSlot(), this.items.get((Object)AS));
                }
                int ID = (Integer)NMSManager.invokeMethod("nextContainerCounter", handle);
                Object PC = NMSManager.getPlayerField(this.player, "playerConnection");
                Object PPOOW = this.playOutOpenWindow.getConstructor(Integer.TYPE, this.containers, NMSManager.getNMSClass("IChatBaseComponent")).newInstance(ID, NMSManager.getField(this.containers, "ANVIL").get(this.containers), serializer);
                Method SP = NMSManager.getMethod("sendPacket", PC.getClass(), this.playOutOpenWindow);
                SP.invoke(PC, PPOOW);
                Field AC = NMSManager.getField(this.human, "activeContainer");
                if (AC != null) {
                    AC.set(handle, CA);
                    NMSManager.getField(NMSManager.getNMSClass("Container"), "windowId").set(AC.get(handle), ID);
                    NMSManager.getMethod("addSlotListener", AC.get(handle).getClass(), handle.getClass()).invoke(AC.get(handle), handle);
                }
            } else {
                Object CA = this.containerAnvil.getConstructor(NMSManager.getNMSClass("PlayerInventory"), NMSManager.getNMSClass("World"), this.blockPosition, this.human).newInstance(NMSManager.getPlayerField(this.player, "inventory"), NMSManager.getPlayerField(this.player, "world"), this.blockPosition.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(0, 0, 0), handle);
                NMSManager.getField(NMSManager.getNMSClass("Container"), "checkReachable").set(CA, false);
                this.inventory = (Inventory)NMSManager.invokeMethod("getTopInventory", NMSManager.invokeMethod("getBukkitView", CA));
                for (AnvilSlot AS : this.items.keySet()) {
                    this.inventory.setItem(AS.getSlot(), this.items.get((Object)AS));
                }
                int ID = (Integer)NMSManager.invokeMethod("nextContainerCounter", handle);
                Object PC = NMSManager.getPlayerField(this.player, "playerConnection");
                Object PPOOW = this.playOutOpenWindow.getConstructor(Integer.TYPE, String.class, NMSManager.getNMSClass("IChatBaseComponent"), Integer.TYPE).newInstance(ID, "minecraft:anvil", serializer, 0);
                Method SP = NMSManager.getMethod("sendPacket", PC.getClass(), this.playOutOpenWindow);
                SP.invoke(PC, PPOOW);
                Field AC = NMSManager.getField(this.human, "activeContainer");
                if (AC != null) {
                    AC.set(handle, CA);
                    NMSManager.getField(NMSManager.getNMSClass("Container"), "windowId").set(AC.get(handle), ID);
                    NMSManager.getMethod("addSlotListener", AC.get(handle).getClass(), handle.getClass()).invoke(AC.get(handle), handle);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

