/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib;

import simplepets.brainsynder.libs.bslib.ServerVersion;
import simplepets.brainsynder.libs.bslib.SupportedVersion;

public interface VersionRestricted {
    default public boolean isSupported() {
        SupportedVersion support = this.getSupportedVersion();
        if (support == null) {
            return true;
        }
        if (support.maxVersion() != ServerVersion.UNKNOWN) {
            return ServerVersion.isEqualOld(support.maxVersion()) && ServerVersion.isEqualNew(support.version());
        }
        return ServerVersion.isEqualNew(support.version());
    }

    default public String toSupportString() {
        SupportedVersion support = this.getSupportedVersion();
        if (support == null) {
            return "UNKNOWN";
        }
        if (support.maxVersion() != ServerVersion.UNKNOWN) {
            return support.version().name() + " -> " + support.maxVersion().name();
        }
        return support.version().name() + " -> LATEST";
    }

    default public SupportedVersion getSupportedVersion() {
        if (!this.getClass().isAnnotationPresent(SupportedVersion.class)) {
            return null;
        }
        return this.getClass().getAnnotation(SupportedVersion.class);
    }
}

