/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.entity.Display;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Transformation;
import simplepets.brainsynder.libs.bslib.files.StorageFile;

public class TestClass {
    private static void fixSchematic(File schematicFolder) throws IOException {
        for (File file : schematicFolder.listFiles()) {
            if (file.isDirectory()) {
                TestClass.fixSchematic(file);
                continue;
            }
            try {
                StorageFile storage = new StorageFile(file);
                Integer version = storage.getInteger("Version", 0);
                storage.setInteger("Version", 7);
                storage.save();
                System.out.println("Fixed schematic: " + file.getName() + " version: " + version + " -> 7");
            }
            catch (Exception e) {
                System.out.println("- Failed to fix schematic: " + file.getName());
            }
        }
    }

    public static void main(String[] args) throws IOException {
        File schematicFolder = new File("C:\\Users\\Admin\\OneDrive\\Desktop\\Schematics");
        TestClass.fixSchematic(schematicFolder);
    }

    public void spawnImageScreen(Player player, String imageUrl, double scaleFactor) {
        BufferedImage image;
        try {
            image = ImageIO.read(new URL(imageUrl));
        }
        catch (IOException e) {
            player.sendMessage("Error loading image: " + e.getMessage());
            return;
        }
        int originalWidth = image.getWidth();
        int originalHeight = image.getHeight();
        int maxPixels = 25000;
        int scaledWidth = (int)((double)originalWidth * scaleFactor);
        int scaledHeight = (int)((double)originalHeight * scaleFactor);
        double resolutionFactor = Math.sqrt((double)maxPixels / (double)(scaledWidth * scaledHeight));
        int finalWidth = (int)((double)scaledWidth * resolutionFactor);
        int finalHeight = (int)((double)scaledHeight * resolutionFactor);
        double pixelSize = (double)0.1f / resolutionFactor;
        double spacingDivider = 8.0;
        Location location = player.getLocation();
        location.setPitch(0.0f);
        location.setYaw(0.0f);
        for (int x = 0; x < finalWidth; ++x) {
            for (int y = 0; y < finalHeight; ++y) {
                int rgb = image.getRGB(x * originalWidth / finalWidth, (finalHeight - 1 - y) * originalHeight / finalHeight);
                int red = rgb >> 16 & 0xFF;
                int green = rgb >> 8 & 0xFF;
                int blue = rgb & 0xFF;
                Color color = Color.fromRGB((int)red, (int)green, (int)blue);
                this.spawnPixel(color, location.clone().add((double)x * pixelSize / spacingDivider, (double)y * pixelSize / spacingDivider, 0.0), pixelSize);
            }
        }
    }

    private TextDisplay spawnPixel(Color color, Location location, double pixelSize) {
        TextDisplay textDisplay = (TextDisplay)location.getWorld().spawn(location, TextDisplay.class);
        textDisplay.setBackgroundColor(color);
        textDisplay.setText(" ");
        textDisplay.setBrightness(new Display.Brightness(15, 15));
        Transformation transformation = textDisplay.getTransformation();
        transformation.getScale().set(pixelSize, pixelSize / 2.0, pixelSize);
        textDisplay.setTransformation(transformation);
        return textDisplay;
    }

    public void spawnGifScreen(final Player player, String gifUrl, double scaleFactor, int frameDelay) {
        final ArrayList<BufferedImage> frames = new ArrayList<BufferedImage>();
        try {
            ImageInputStream stream = ImageIO.createImageInputStream(new URL(gifUrl).openStream());
            Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("gif");
            if (!readers.hasNext()) {
                player.sendMessage("Error: No GIF reader found.");
                return;
            }
            ImageReader reader = readers.next();
            reader.setInput(stream);
            int numFrames = reader.getNumImages(true);
            for (int i = 0; i < numFrames; ++i) {
                frames.add(reader.read(i));
            }
        }
        catch (IOException e) {
            player.sendMessage("Error loading GIF: " + e.getMessage());
            return;
        }
        if (frames.isEmpty()) {
            player.sendMessage("Error: No frames found in GIF.");
            return;
        }
        BufferedImage firstFrame = (BufferedImage)frames.get(0);
        final int originalWidth = firstFrame.getWidth();
        final int originalHeight = firstFrame.getHeight();
        int maxPixels = 10000;
        int scaledWidth = (int)((double)originalWidth * scaleFactor);
        int scaledHeight = (int)((double)originalHeight * scaleFactor);
        double resolutionFactor = Math.sqrt((double)maxPixels / (double)(scaledWidth * scaledHeight));
        final int finalWidth = (int)((double)scaledWidth * resolutionFactor);
        final int finalHeight = (int)((double)scaledHeight * resolutionFactor);
        double pixelSize = (double)0.1f / resolutionFactor;
        double spacingDivider = 8.0;
        final TextDisplay[][] pixels = new TextDisplay[finalWidth][finalHeight];
        Location location = player.getLocation();
        location.setPitch(0.0f);
        location.setYaw(0.0f);
        for (int x = 0; x < finalWidth; ++x) {
            for (int y = 0; y < finalHeight; ++y) {
                Location pixelLocation = location.clone().add((double)x * pixelSize / spacingDivider, (double)y * pixelSize / spacingDivider, 0.0);
                pixels[x][y] = this.spawnPixel(Color.WHITE, pixelLocation, pixelSize);
            }
        }
        new BukkitRunnable(){
            int frameIndex = 0;

            public void run() {
                if (!player.isOnline()) {
                    this.cancel();
                    return;
                }
                BufferedImage image = (BufferedImage)frames.get(this.frameIndex);
                this.frameIndex = (this.frameIndex + 1) % frames.size();
                for (int x = 0; x < finalWidth; ++x) {
                    for (int y = 0; y < finalHeight; ++y) {
                        int rgb = image.getRGB(x * originalWidth / finalWidth, (finalHeight - 1 - y) * originalHeight / finalHeight);
                        int red = rgb >> 16 & 0xFF;
                        int green = rgb >> 8 & 0xFF;
                        int blue = rgb & 0xFF;
                        Color color = Color.fromRGB((int)red, (int)green, (int)blue);
                        pixels[x][y].setBackgroundColor(color);
                    }
                }
            }
        }.runTaskTimer(null, 0L, (long)frameDelay);
    }
}

