/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.libs.bslib;

import java.util.Objects;
import org.bukkit.Bukkit;
import simplepets.brainsynder.libs.bslib.IVersion;
import simplepets.brainsynder.libs.bslib.reflection.Reflection;
import simplepets.brainsynder.libs.bslib.utils.AdvString;
import simplepets.brainsynder.libs.bslib.utils.Triple;

public enum ServerVersion implements IVersion
{
    UNKNOWN,
    v1_8_R3,
    v1_9_R1,
    v1_9_R2,
    v1_10_R1,
    v1_11_R1,
    v1_12_R1,
    v1_13_R1,
    v1_13_R2,
    v1_14_R1,
    v1_15_R1,
    v1_16_R1,
    v1_16_R2,
    v1_16_R3,
    v1_17("v1_17_R1"),
    v1_17_1(v1_17),
    v1_18("v1_18_R1"),
    v1_18_1(v1_18),
    v1_18_2("v1_18_R2"),
    v1_19("v1_19_R1"),
    v1_19_1(v1_19),
    v1_19_2(v1_19),
    v1_19_3("v1_19_R2"),
    v1_19_4("v1_19_R3"),
    v1_20("v1_20_R1"),
    v1_20_1(v1_20),
    v1_20_2("v1_20_R2"),
    v1_20_3("v1_20_R3"),
    v1_20_4(v1_20_3),
    v1_20_5("v1_20_R4"),
    v1_20_6(v1_20_5),
    v1_21("v1_21_R1"),
    v1_21_1(v1_21),
    v1_21_3("v1_21_R2"),
    v1_21_4("v1_21_R3"),
    v1_21_5("v1_21_R4"),
    v1_21_6("v1_21_R5"),
    v1_21_7(v1_21_6),
    v1_21_8(v1_21_6),
    v1_21_9("v1_21_R6"),
    v1_21_10(v1_21_9),
    v1_21_11("v1_21_R7");

    private final String nms;
    private final ServerVersion parent;
    private static IVersion CURRENT_VERSION;

    private ServerVersion() {
        this.parent = this;
        this.nms = this.name();
    }

    private ServerVersion(String nms) {
        this.parent = this;
        this.nms = nms;
    }

    private ServerVersion(ServerVersion parent) {
        this.parent = parent;
        this.nms = parent.nms;
    }

    private ServerVersion(ServerVersion parent, String nms) {
        this.parent = parent;
        this.nms = nms;
    }

    @Override
    public String getNMS() {
        return this.parent.nms;
    }

    @Override
    public Triple<Integer, Integer, Integer> getVersionParts() {
        if (this.name().equals("UNKNOWN")) {
            return Triple.of(-1, -1, -1);
        }
        String name = this.name().replace("v", "").replace("R", "");
        String[] args = name.split("_");
        int[] ints = new int[]{0, 0, 0};
        if (args.length >= 1) {
            ints[0] = Integer.parseInt(args[0]);
        }
        if (args.length >= 2) {
            ints[1] = Integer.parseInt(args[1]);
        }
        if (args.length >= 3) {
            ints[2] = Integer.parseInt(args[2]);
        }
        return Triple.of(ints[0], ints[1], ints[2]);
    }

    public static <T extends IVersion> T getVersion() {
        return ServerVersion.getVersion(false);
    }

    public static <T extends IVersion> T getVersion(boolean parent) {
        if (CURRENT_VERSION != null) {
            if (parent) {
                return (T)CURRENT_VERSION.getParent();
            }
            return (T)CURRENT_VERSION;
        }
        String mc = AdvString.between("MC: ", ")", Bukkit.getVersion());
        String mcVersion = "v" + mc.replace(".", "_");
        String[] args = mc.split("\\.");
        int[] ints = new int[]{0, 0, 0};
        if (args.length >= 1) {
            ints[0] = Integer.parseInt(args[0]);
        }
        if (args.length >= 2) {
            ints[1] = Integer.parseInt(args[1]);
        }
        if (args.length >= 3) {
            ints[2] = Integer.parseInt(args[2]);
        }
        final Triple<Integer, Integer, Integer> triple = Triple.of(ints[0], ints[1], ints[2]);
        for (ServerVersion version : ServerVersion.values()) {
            if (version.name().equalsIgnoreCase(mcVersion + "_R1")) {
                CURRENT_VERSION = version;
                if (parent) {
                    return (T)version.getParent();
                }
                return (T)version;
            }
            if (version.name().equalsIgnoreCase(mcVersion)) {
                CURRENT_VERSION = version;
                if (parent) {
                    return (T)version.getParent();
                }
                return (T)version;
            }
            if (Reflection.getBukkitPackageVersion().isEmpty() || !version.name().equals(Reflection.getBukkitPackageVersion())) continue;
            CURRENT_VERSION = version;
            return (T)version;
        }
        CURRENT_VERSION = new IVersion(){

            @Override
            public String name() {
                if ((Integer)triple.right == 0) {
                    return "v" + String.valueOf(triple.left) + "_" + String.valueOf(triple.middle);
                }
                return "v" + String.valueOf(triple.left) + "_" + String.valueOf(triple.middle) + "_" + String.valueOf(triple.right);
            }

            @Override
            public String getNMS() {
                return Reflection.getBukkitPackageVersion();
            }

            @Override
            public Triple<Integer, Integer, Integer> getVersionParts() {
                return triple;
            }

            @Override
            public IVersion getParent() {
                return this;
            }
        };
        return (T)CURRENT_VERSION;
    }

    @Override
    public ServerVersion getParent() {
        return this.parent;
    }

    public static boolean isEqualNew(ServerVersion version) {
        Triple<Integer, Integer, Integer> current = ServerVersion.getVersion().getVersionParts();
        Triple<Integer, Integer, Integer> compare = version.getVersionParts();
        if ((Objects.equals(current.left, compare.left) || (Integer)current.left >= (Integer)compare.left) && (Objects.equals(current.middle, compare.middle) || (Integer)current.middle >= (Integer)compare.middle)) {
            if (Objects.equals(current.middle, compare.middle)) {
                return Objects.equals(current.right, compare.right) || (Integer)current.right >= (Integer)compare.right;
            }
            return true;
        }
        return false;
    }

    public static boolean isNewer(ServerVersion version) {
        Triple<Integer, Integer, Integer> current = ServerVersion.getVersion().getVersionParts();
        Triple<Integer, Integer, Integer> compare = version.getVersionParts();
        if ((Objects.equals(current.left, compare.left) || (Integer)current.left > (Integer)compare.left) && (Objects.equals(current.middle, compare.middle) || (Integer)current.middle > (Integer)compare.middle)) {
            if (Objects.equals(current.middle, compare.middle)) {
                return Objects.equals(current.right, compare.right) || (Integer)current.right > (Integer)compare.right;
            }
            return true;
        }
        return false;
    }

    public static boolean isEqual(ServerVersion version) {
        Triple<Integer, Integer, Integer> current = ServerVersion.getVersion().getVersionParts();
        Triple<Integer, Integer, Integer> compare = version.getVersionParts();
        return Objects.equals(current.left, compare.left) && Objects.equals(current.middle, compare.middle) && Objects.equals(current.right, compare.right);
    }

    public static boolean isEqualOld(ServerVersion version) {
        Triple<Integer, Integer, Integer> current = ServerVersion.getVersion().getVersionParts();
        Triple<Integer, Integer, Integer> compare = version.getVersionParts();
        if ((Objects.equals(current.left, compare.left) || (Integer)current.left <= (Integer)compare.left) && (Objects.equals(current.middle, compare.middle) || (Integer)current.middle <= (Integer)compare.middle)) {
            if (Objects.equals(current.middle, compare.middle)) {
                return Objects.equals(current.right, compare.right) || (Integer)current.right <= (Integer)compare.right;
            }
            return true;
        }
        return false;
    }

    public static boolean isOlder(ServerVersion version) {
        Triple<Integer, Integer, Integer> current = ServerVersion.getVersion().getVersionParts();
        Triple<Integer, Integer, Integer> compare = version.getVersionParts();
        if ((Objects.equals(current.left, compare.left) || (Integer)current.left < (Integer)compare.left) && (Objects.equals(current.middle, compare.middle) || (Integer)current.middle < (Integer)compare.middle)) {
            if (Objects.equals(current.middle, compare.middle)) {
                return Objects.equals(current.right, compare.right) || (Integer)current.right < (Integer)compare.right;
            }
            return true;
        }
        return false;
    }

    static {
        CURRENT_VERSION = null;
    }
}

