/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.impl;

import com.google.common.collect.Lists;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import simplepets.brainsynder.api.entity.IEntityPet;
import simplepets.brainsynder.api.pet.CommandReason;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.api.plugin.config.ConfigOption;
import simplepets.brainsynder.api.plugin.utils.IPetUtilities;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.libs.bslib.utils.Colorize;

public class PetUtility
implements IPetUtilities {
    @Override
    public void runPetCommands(CommandReason reason, PetUser owner, PetType type) {
        this.runPetCommands(reason, owner, type, null);
    }

    @Override
    public void runPetCommands(CommandReason reason, PetUser owner, PetType type, Location location) {
        SimplePets.getPetConfigManager().getPetConfig(type).ifPresent(config -> {
            List<String> commands = config.getCommands().getOrDefault((Object)reason, Lists.newArrayList());
            if (owner.getPetEntity(type).isPresent()) {
                commands.forEach(command -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)this.handlePlaceholders(owner, owner.getPetEntity(type).get(), null, (String)command)));
                return;
            }
            commands.forEach(command -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)this.handlePlaceholders(owner, null, location, (String)command)));
        });
    }

    @Override
    public String handlePlaceholders(PetUser owner, IEntityPet entity, Location petLoc, String text) {
        Location ownerLoc = owner.getPlayer().getLocation();
        if (petLoc == null && entity != null) {
            petLoc = entity.getEntity().getLocation();
        }
        if (petLoc != null) {
            text = text.replace("{petX}", String.valueOf(petLoc.getX())).replace("{petY}", String.valueOf(petLoc.getY())).replace("{petZ}", String.valueOf(petLoc.getZ()));
        }
        text = text.replace("{ownerX}", String.valueOf(ownerLoc.getX())).replace("{ownerY}", String.valueOf(ownerLoc.getY())).replace("{ownerZ}", String.valueOf(ownerLoc.getZ())).replace("{ownerName}", owner.getOwnerName()).replace("{petType}", entity.getPetType().getName()).replace("{petUUID}", entity.getEntity().getUniqueId().toString());
        if (entity != null && entity.getPetName().isPresent()) {
            text = text.replace("{petName}", entity.getPetName().get());
        }
        return text;
    }

    @Override
    public String translatePetName(String name) {
        boolean color = ConfigOption.INSTANCE.RENAME_COLOR_ENABLED.getValue();
        boolean magic = ConfigOption.INSTANCE.RENAME_COLOR_MAGIC.getValue();
        if (!magic) {
            name = name.replace("&k", "");
        }
        if (!color) {
            return name;
        }
        name = ConfigOption.INSTANCE.RENAME_COLOR_HEX.getValue() != false ? Colorize.translateBungeeHex(name) : Colorize.translateBukkit(name);
        return name;
    }
}

