/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.files;

import java.util.function.BiConsumer;
import simplepets.brainsynder.PetCore;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.api.plugin.config.ConfigOption;
import simplepets.brainsynder.debug.DebugLevel;
import simplepets.brainsynder.libs.bslib.files.YamlFile;

public class Config
extends YamlFile {
    public Config(PetCore core) {
        super(core.getDataFolder(), "config.yml");
    }

    @Override
    public void loadDefaults() {
        ConfigOption.INSTANCE.getOptions().forEach((key, entry) -> {
            if (entry.getDescription() == null) {
                this.addDefault((String)key, entry.getDefaultValue());
            } else {
                this.addDefault((String)key, entry.getDefaultValue(), entry.getDescription().replace("{default}", String.valueOf(entry.getDefaultValue())));
            }
            if (!entry.getPastPaths().isEmpty()) {
                entry.getPastPaths().forEach(oldKey -> this.move(String.valueOf(oldKey), (String)key));
            }
        });
        this.updateSections();
    }

    public void initValues() {
        ConfigOption.INSTANCE.getOptions().forEach((key, entry) -> {
            Object value = this.get((String)key);
            if (!value.getClass().getSimpleName().equals(entry.getDefaultValue().getClass().getSimpleName())) {
                SimplePets.getDebugLogger().debug(DebugLevel.CRITICAL, "Value of '" + key + "' can not be a '" + value.getClass().getSimpleName() + "' must be a '" + entry.getDefaultValue().getClass().getSimpleName() + "'" + (String)(entry.getExamples() != null ? " Example(s): " + entry.getExamples() : ""));
                value = entry.getDefaultValue();
            }
            entry.setValue(value, false);
        });
    }

    public void setEnum(String key, Enum anEnum) {
        this.set(key, (Object)anEnum.name());
    }

    public <E extends Enum> E getEnum(String key, Class<E> type) {
        return this.getEnum(key, type, null);
    }

    public <E extends Enum> E getEnum(String key, Class<E> type, E fallback) {
        if (!this.contains(key)) {
            return fallback;
        }
        return Enum.valueOf(type, this.getString(key));
    }

    private void updateSections() {
        this.remove("PetItemStorage.Enable");
        this.remove("PetItemStorage.Inventory-Size");
        this.remove("WorldGuard.BypassPermission");
        this.remove("PlotSquared.BypassPermission");
        this.remove("PlotSquared.On-Unclaimed-Plots.Move");
        this.remove("PlotSquared.On-Unclaimed-Plots.Spawn");
        this.remove("PlotSquared.On-Unclaimed-Plots.Riding");
        this.remove("PlotSquared.On-Roads.Move");
        this.remove("PlotSquared.On-Roads.Spawn");
        this.remove("PlotSquared.On-Roads.Riding");
        this.remove("PlotSquared.Block-If-Denied.Move");
        this.remove("PlotSquared.Block-If-Denied.Spawn");
        this.remove("PlotSquared.Block-If-Denied.Riding");
        this.remove("WorldBorder.Block-If-Denied.Move");
        this.remove("WorldBorder.Block-If-Denied.Spawn");
        this.remove("WorldBorder.Block-If-Denied.Riding");
        this.move("Needs-Pet-Permission-To-Open-GUI", "Permissions.Needs-Pet-Permission-for-GUI", this.logMove());
        this.move("Needs-Data-Permissions", "Permissions.Data-Permissions", this.logMove());
        this.move("Needs-Permission", "Permissions.Enabled", this.logMove());
        this.move("Remove-Item-If-No-Permission", "Permissions.Only-Show-Pets-Player-Can-Access", this.logMove());
        this.remove("WorldGuard.Spawning.Always-Allowed");
        this.remove("WorldGuard.Spawning.Blocked-Regions");
        this.remove("WorldGuard.Pet-Entering.Always-Allowed");
        this.remove("WorldGuard.Pet-Entering.Blocked-Regions");
        this.remove("WorldGuard.Pet-Riding.Always-Allowed");
        this.remove("WorldGuard.Pet-Riding.Blocked-Regions");
        this.remove("OldPetRegistering");
        this.remove("MySQL.Options.Auto_Reconnect");
        this.remove("PetToggles.Weight.Enabled");
        this.remove("PetToggles.Weight.Weight_Stacked");
        this.remove("PetToggles.Weight.Max_Weight");
        this.remove("Complete-Mobspawning-Deny-Bypass");
    }

    protected BiConsumer<String, String> logMove() {
        return (oldKey, newKey) -> {
            String name = this.getClass().getSimpleName().replace("File", "");
            SimplePets.getDebugLogger().debug("[" + name + "] Moving '" + oldKey + "' to '" + newKey + "'");
        };
    }
}

