/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.commands.list;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import simplepets.brainsynder.PetCore;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.commands.Permission;
import simplepets.brainsynder.commands.PetSubCommand;
import simplepets.brainsynder.files.MessageFile;
import simplepets.brainsynder.files.options.MessageOption;
import simplepets.brainsynder.libs.bslib.commands.annotations.ICommand;

@ICommand(name="remove", usage="[player] [type]", description="Remove your pet or another players")
@Permission(permission="remove", defaultAllow=true, additionalPermissions={"other"})
public class RemoveCommand
extends PetSubCommand {
    public RemoveCommand(PetCore plugin) {
        super(plugin);
    }

    @Override
    public void run(CommandSender sender, String[] args) {
        Player selected;
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                this.sendUsage(sender);
                return;
            }
            AtomicInteger integer = new AtomicInteger(0);
            this.getPlugin().getUserManager().getPetUser((Player)sender).ifPresent(user -> {
                for (PetType type : PetType.values()) {
                    if (!user.removePet(type)) continue;
                    integer.incrementAndGet();
                }
            });
            sender.sendMessage(MessageFile.getTranslation(MessageOption.REMOVED_ALL_PETS).replace("{count}", String.valueOf(integer.get())));
            return;
        }
        AtomicInteger index = new AtomicInteger(0);
        Player target = null;
        if (this.isUsername(args[index.get()]) && sender.hasPermission(this.getPermission("other")) && (selected = Bukkit.getPlayerExact((String)args[index.get()])) != null) {
            target = selected;
            if (!sender.hasPermission(this.getPermission("other"))) {
                sender.sendMessage(MessageFile.getTranslation(MessageOption.NO_PERMISSION));
                return;
            }
            index.getAndIncrement();
        }
        if (target == null) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You must be a player to run this command for yourself.");
            } else {
                target = (Player)sender;
            }
        }
        Player finalTarget = target;
        if (args.length == index.get()) {
            AtomicInteger integer = new AtomicInteger(0);
            this.getPlugin().getUserManager().getPetUser(finalTarget).ifPresent(user -> {
                for (PetType type : PetType.values()) {
                    if (!user.removePet(type)) continue;
                    integer.incrementAndGet();
                }
            });
            sender.sendMessage(MessageFile.getTranslation(MessageOption.REMOVED_ALL_PETS).replace("{count}", String.valueOf(integer.get())));
            return;
        }
        Optional<PetType> petType = PetType.getPetType(args[index.get()]);
        if (!petType.isPresent()) {
            sender.sendMessage(MessageFile.getTranslation(MessageOption.INVALID_PET_TYPE).replace("{arg}", args[index.get()]));
            return;
        }
        PetType type = petType.get();
        this.getPlugin().getUserManager().getPetUser(finalTarget).ifPresent(user -> {
            if (!user.removePet(type)) {
                sender.sendMessage(MessageFile.getTranslation(MessageOption.REMOVED_PET).replace("{type}", type.getName()));
                return;
            }
            sender.sendMessage(MessageFile.getTranslation(MessageOption.REMOVED_PET).replace("{type}", type.getName()));
        });
    }
}

