/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.commands.list;

import com.google.common.collect.Lists;
import java.util.List;
import org.bukkit.command.CommandSender;
import simplepets.brainsynder.PetCore;
import simplepets.brainsynder.commands.Permission;
import simplepets.brainsynder.commands.PetSubCommand;
import simplepets.brainsynder.files.MessageFile;
import simplepets.brainsynder.files.options.MessageOption;
import simplepets.brainsynder.libs.bslib.commands.annotations.ICommand;
import simplepets.brainsynder.managers.InventoryManager;
import simplepets.brainsynder.managers.ItemManager;

@ICommand(name="reload", usage="[selector]", description="Reloads a selected file/folder")
@Permission(permission="reload", adminCommand=true)
public class ReloadCommand
extends PetSubCommand {
    public ReloadCommand(PetCore plugin) {
        super(plugin);
    }

    @Override
    public List<String> handleCompletions(List<String> completions, CommandSender sender, int index, String[] args) {
        if (index == 1) {
            completions.addAll(Lists.newArrayList((Object[])new String[]{"config", "messages", "inventories", "particles", "pets"}));
        }
        return completions;
    }

    @Override
    public void run(CommandSender sender, String[] args) {
        String type = "";
        if (args.length > 0) {
            type = args[0].toLowerCase();
        }
        switch (type) {
            case "config": {
                this.getPlugin().getConfiguration().reload();
                this.getPlugin().getConfiguration().initValues();
                sender.sendMessage(MessageFile.getTranslation(MessageOption.CONFIG_RELOADED));
                break;
            }
            case "messages": {
                MessageFile.getFile().reload();
                sender.sendMessage(MessageFile.getTranslation(MessageOption.MESSAGES_RELOADED));
                break;
            }
            case "inventories": {
                ((InventoryManager)this.getPlugin().getGUIHandler()).initiate();
                ((ItemManager)this.getPlugin().getItemHandler()).initiate();
                sender.sendMessage(MessageFile.getTranslation(MessageOption.INVENTORIES_RELOADED));
                break;
            }
            case "particles": {
                this.getPlugin().getParticleHandler().reload(this.getPlugin());
                sender.sendMessage(MessageFile.getTranslation(MessageOption.PARTICLES_RELOADED));
                break;
            }
            case "pets": {
                this.getPlugin().reloadPetConfigManager();
                InventoryManager.SELECTION.reloadAvailableTypes();
                sender.sendMessage(MessageFile.getTranslation(MessageOption.PETS_RELOADED));
                break;
            }
            default: {
                this.getPlugin().getConfiguration().reload();
                this.getPlugin().getConfiguration().initValues();
                MessageFile.getFile().reload();
                this.getPlugin().getParticleHandler().reload(this.getPlugin());
                this.getPlugin().reloadPetConfigManager();
                ((InventoryManager)this.getPlugin().getGUIHandler()).initiate();
                ((ItemManager)this.getPlugin().getItemHandler()).initiate();
                sender.sendMessage(MessageFile.getTranslation(MessageOption.ALL_RELOADED));
            }
        }
    }
}

