/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.commands.list;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import java.util.Optional;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import simplepets.brainsynder.PetCore;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.commands.Permission;
import simplepets.brainsynder.commands.PetSubCommand;
import simplepets.brainsynder.files.MessageFile;
import simplepets.brainsynder.files.options.MessageOption;
import simplepets.brainsynder.impl.PetConfiguration;
import simplepets.brainsynder.libs.bslib.commands.annotations.ICommand;
import simplepets.brainsynder.managers.InventoryManager;
import simplepets.brainsynder.managers.ItemManager;

@ICommand(name="regenerate", usage="<selector> [type]", description="Regenerates the a file/folder back to default (ignores plugin addons)")
@Permission(permission="regenerate", adminCommand=true)
public class RegenerateCommand
extends PetSubCommand {
    private final File petsFolder;
    private final File inventoryFolder;
    private final File itemFolder;
    private final File particleFolder;

    public RegenerateCommand(PetCore plugin) {
        super(plugin);
        this.petsFolder = new File(String.valueOf(plugin.getDataFolder()) + File.separator + "Pets");
        this.inventoryFolder = new File(String.valueOf(plugin.getDataFolder()) + File.separator + "Inventories");
        this.itemFolder = new File(String.valueOf(plugin.getDataFolder()) + File.separator + "Items");
        this.particleFolder = new File(String.valueOf(plugin.getDataFolder()) + File.separator + "Particles");
    }

    @Override
    public List<String> handleCompletions(List<String> completions, CommandSender sender, int index, String[] args) {
        if (index == 1) {
            completions.addAll(Lists.newArrayList((Object[])new String[]{"pets", "inventories", "items", "particles", "type"}));
            return completions;
        }
        if (args[0].equalsIgnoreCase("type") && index == 2) {
            completions.addAll(this.getPetTypes());
            return completions;
        }
        return completions;
    }

    @Override
    public void run(final CommandSender sender, String[] args) {
        if (args.length == 0) {
            this.sendUsage(sender);
            return;
        }
        if (args[0].equalsIgnoreCase("pets")) {
            this.deleteFiles(this.petsFolder);
            new BukkitRunnable(this){

                public void run() {
                    ((PetConfiguration)SimplePets.getPetConfigManager()).reset();
                    sender.sendMessage(MessageFile.getTranslation(MessageOption.PET_FILES_REGEN));
                }
            }.runTaskLater((Plugin)this.getPlugin(), 2L);
            return;
        }
        if (args[0].equalsIgnoreCase("inventories")) {
            this.deleteFiles(this.inventoryFolder);
            new BukkitRunnable(){

                public void run() {
                    ((InventoryManager)RegenerateCommand.this.getPlugin().getGUIHandler()).initiate();
                    sender.sendMessage(MessageFile.getTranslation(MessageOption.INV_FILES_REGEN));
                }
            }.runTaskLater((Plugin)this.getPlugin(), 2L);
            return;
        }
        if (args[0].equalsIgnoreCase("items")) {
            this.deleteFiles(this.itemFolder);
            new BukkitRunnable(){

                public void run() {
                    ((ItemManager)RegenerateCommand.this.getPlugin().getItemHandler()).initiate();
                    sender.sendMessage(MessageFile.getTranslation(MessageOption.ITEM_FILES_REGEN));
                }
            }.runTaskLater((Plugin)this.getPlugin(), 2L);
            return;
        }
        if (args[0].equalsIgnoreCase("particles")) {
            this.deleteFiles(this.particleFolder);
            new BukkitRunnable(){

                public void run() {
                    RegenerateCommand.this.getPlugin().getParticleHandler().reload(RegenerateCommand.this.getPlugin());
                    sender.sendMessage(MessageFile.getTranslation(MessageOption.PARTICLE_FILES_REGEN));
                }
            }.runTaskLater((Plugin)this.getPlugin(), 2L);
            return;
        }
        if (args[0].equalsIgnoreCase("type")) {
            if (args.length == 1) {
                this.sendUsage(sender);
                return;
            }
            Optional<PetType> optional = PetType.getPetType(args[1]);
            if (!optional.isPresent()) {
                sender.sendMessage(MessageFile.getTranslation(MessageOption.INVALID_PET_TYPE).replace("{arg}", args[1]));
                return;
            }
            final PetType type = optional.get();
            File petFile = new File(this.petsFolder, type.getName() + ".json");
            petFile.delete();
            new BukkitRunnable(this){

                public void run() {
                    ((PetConfiguration)SimplePets.getPetConfigManager()).reset(type);
                    sender.sendMessage(MessageFile.getTranslation(MessageOption.PET_TYPE_FILE_REGEN).replace("{type}", type.getName()));
                }
            }.runTaskLater((Plugin)this.getPlugin(), 1L);
        }
        this.sendUsage(sender);
    }

    private void deleteFiles(File folder) {
        Lists.newArrayList((Object[])folder.listFiles()).forEach(file -> {
            if (file.isFile()) {
                file.delete();
            }
        });
    }
}

