/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.commands.list;

import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import simplepets.brainsynder.PetCore;
import simplepets.brainsynder.api.pet.IPetConfig;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.commands.Permission;
import simplepets.brainsynder.commands.PetSubCommand;
import simplepets.brainsynder.files.MessageFile;
import simplepets.brainsynder.files.options.MessageOption;
import simplepets.brainsynder.impl.PetConfiguration;
import simplepets.brainsynder.libs.bslib.commands.annotations.ICommand;
import simplepets.brainsynder.libs.bslib.files.JsonFile;
import simplepets.brainsynder.libs.bslib.json.JsonValue;
import simplepets.brainsynder.managers.InventoryManager;

@ICommand(name="petconfig", usage="<type> <key> <value|reset>", description="Modify settings for the selected pet type.")
@Permission(permission="petconfig", adminCommand=true)
public class PetConfigCommand
extends PetSubCommand {
    public PetConfigCommand(PetCore plugin) {
        super(plugin);
    }

    @Override
    public List<String> handleCompletions(List<String> completions, CommandSender sender, int index, String[] args) {
        if (index == 1) {
            for (PetType type2 : PetType.values()) {
                completions.add(type2.getName());
            }
            return completions;
        }
        if (index == 2) {
            PetType.getPetType(args[0]).ifPresent(type -> SimplePets.getPetConfigManager().getPetConfig((PetType)((Object)type)).ifPresent(iPetConfig -> {
                PetConfiguration.PetConfig config = (PetConfiguration.PetConfig)iPetConfig;
                JsonFile jsonFile = config.getJSON();
                jsonFile.getKeys().forEach(key -> {
                    boolean value = this.canModifyKey((String)key, (IPetConfig)iPetConfig);
                    if (value) {
                        completions.add((String)key);
                    }
                });
            }));
            return completions;
        }
        if (index == 3) {
            completions.add("reset");
            PetType.getPetType(args[0]).ifPresent(type -> SimplePets.getPetConfigManager().getPetConfig((PetType)((Object)type)).ifPresent(iPetConfig -> {
                PetConfiguration.PetConfig config = (PetConfiguration.PetConfig)iPetConfig;
                JsonFile jsonFile = config.getJSON();
                String key = args[1];
                String defaultValue = jsonFile.getDefaultValue(key).toString();
                String current = jsonFile.getValue(key).toString();
                completions.add(defaultValue);
                if (!defaultValue.equalsIgnoreCase(current)) {
                    completions.add(current);
                }
            }));
            return completions;
        }
        return super.handleCompletions(completions, sender, index, args);
    }

    @Override
    public void run(CommandSender sender, String[] args) {
        if (args.length == 0 || args.length == 1 || args.length == 2) {
            this.sendUsage(sender);
            return;
        }
        Optional<PetType> petType = PetType.getPetType(args[0]);
        if (petType.isEmpty()) {
            sender.sendMessage(MessageFile.getTranslation(MessageOption.INVALID_PET_TYPE).replace("{arg}", args[0]));
            return;
        }
        PetType type = petType.get();
        String key = args[1];
        String value = args[2];
        this.modifyPetConfig(sender, type, key, value);
    }

    private boolean canModifyKey(String key, IPetConfig iPetConfig) {
        PetConfiguration.PetConfig config = (PetConfiguration.PetConfig)iPetConfig;
        JsonFile jsonFile = config.getJSON();
        if (!jsonFile.hasKey(key)) {
            return false;
        }
        JsonValue original = jsonFile.getValue(key);
        return original.isBoolean() || original.isNumber() || original.isString();
    }

    private void modifyPetConfig(CommandSender sender, PetType type, String key, String newValue) {
        SimplePets.getPetConfigManager().getPetConfig(type).ifPresent(iPetConfig -> {
            PetConfiguration.PetConfig config = (PetConfiguration.PetConfig)iPetConfig;
            JsonFile jsonFile = config.getJSON();
            if (!jsonFile.hasKey(key)) {
                sender.sendMessage(MessageFile.getTranslation(MessageOption.CONFIG_UNKNOWN_KEY).replace("{key}", key));
                return;
            }
            JsonValue original = jsonFile.getDefaultValue(key);
            boolean updated = false;
            boolean reset = false;
            if (newValue.equalsIgnoreCase("reset")) {
                jsonFile.set(key, jsonFile.getDefaultValue(key));
                updated = true;
                reset = true;
            } else if (original.isBoolean()) {
                if (!"true".equalsIgnoreCase(newValue) && !"false".equalsIgnoreCase(newValue)) {
                    sender.sendMessage(MessageFile.getTranslation(MessageOption.CONFIG_INVALID_BOOLEAN).replace("{key}", key).replace("{value}", newValue));
                    return;
                }
                jsonFile.set(key, Boolean.parseBoolean(newValue));
                updated = true;
            } else if (original.isNumber()) {
                if (original.toString().contains(".")) {
                    try {
                        double value = Double.parseDouble(newValue);
                        jsonFile.set(key, value);
                        updated = true;
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(MessageFile.getTranslation(MessageOption.CONFIG_INVALID_DOUBLE).replace("{key}", key).replace("{value}", newValue));
                        return;
                    }
                } else {
                    try {
                        int value = Integer.parseInt(newValue);
                        jsonFile.set(key, value);
                        updated = true;
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(MessageFile.getTranslation(MessageOption.CONFIG_INVALID_INT).replace("{key}", key).replace("{value}", newValue));
                        return;
                    }
                }
            } else if (original.isString()) {
                jsonFile.set(key, newValue);
                updated = true;
            }
            if (updated) {
                jsonFile.save();
                boolean finalReset = reset;
                Bukkit.getScheduler().runTaskLater((Plugin)SimplePets.getPlugin(), () -> {
                    ((PetConfiguration)PetCore.getInstance().getPetConfigManager()).reset();
                    InventoryManager.SELECTION.reloadAvailableTypes();
                    if (finalReset) {
                        sender.sendMessage(MessageFile.getTranslation(MessageOption.CONFIG_VALUE_RESET).replace("{key}", key).replace("{value}", jsonFile.getDefaultValue(key).toString()).replace("{type}", type.getName()));
                    } else {
                        sender.sendMessage(MessageFile.getTranslation(MessageOption.CONFIG_VALUE_UPDATED).replace("{key}", key).replace("{value}", newValue).replace("{type}", type.getName()));
                    }
                }, 5L);
                return;
            }
            sender.sendMessage(MessageFile.getTranslation(MessageOption.CONFIG_UNABLE_TO_UPDATE).replace("{key}", key).replace("{value}", newValue));
        });
    }
}

