/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.commands.list;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import simplepets.brainsynder.PetCore;
import simplepets.brainsynder.api.entity.misc.IEntityControllerPet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.commands.Permission;
import simplepets.brainsynder.commands.PetSubCommand;
import simplepets.brainsynder.files.MessageFile;
import simplepets.brainsynder.files.options.MessageOption;
import simplepets.brainsynder.libs.bslib.commands.annotations.ICommand;
import simplepets.brainsynder.libs.bslib.nbt.JsonToNBT;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.libs.bslib.nbt.other.NBTException;

@ICommand(name="modify", usage="[player] <type> <nbt>", description="Modify the Selected Players' Pet.")
@Permission(permission="modify", additionalPermissions={"other"})
public class ModifyCommand
extends PetSubCommand {
    public ModifyCommand(PetCore plugin) {
        super(plugin);
    }

    @Override
    public void run(CommandSender sender, String[] args) {
        Player selected;
        if (args.length == 0 || args.length == 1 || args.length == 2) {
            this.sendUsage(sender);
            return;
        }
        AtomicInteger argStart = new AtomicInteger(0);
        Player target = null;
        if (this.isUsername(args[argStart.get()]) && sender.hasPermission(this.getPermission("other")) && (selected = Bukkit.getPlayerExact((String)args[argStart.get()])) != null) {
            target = selected;
            if (!sender.hasPermission(this.getPermission("other"))) {
                sender.sendMessage(MessageFile.getTranslation(MessageOption.NO_PERMISSION));
                return;
            }
            argStart.getAndIncrement();
        }
        if (target == null) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You must be a player to run this command for yourself.");
            } else {
                target = (Player)sender;
            }
        }
        SimplePets.getUserManager().getPetUser(target).ifPresent(user -> {
            StorageTagCompound compound;
            Optional<PetType> petType = PetType.getPetType(args[argStart.get()]);
            if (!petType.isPresent()) {
                sender.sendMessage(MessageFile.getTranslation(MessageOption.INVALID_PET_TYPE).replace("{arg}", args[1]));
                return;
            }
            PetType type = petType.get();
            if (!SimplePets.getSpawnUtil().isRegistered(type)) {
                sender.sendMessage(MessageFile.getTranslation(MessageOption.PET_NOT_REGISTERED).replace("{type}", type.getName()));
                return;
            }
            String json = this.messageMaker(args, argStart.get() + 1).replace(" ", "~");
            if ((json = this.formatJson(json)).toLowerCase().contains(":true")) {
                json = json.replaceAll("(?i):true", ":1b");
            }
            if (json.toLowerCase().contains(":false")) {
                json = json.replaceAll("(?i):false", ":0b");
            }
            try {
                compound = JsonToNBT.getTagFromJson(json);
            }
            catch (NBTException e) {
                sender.sendMessage(MessageFile.getTranslation(MessageOption.INVALID_NBT));
                String message = MessageFile.getTranslation(MessageOption.INVALID_NBT_MESSAGE).replace("{message}", e.getMessage().replaceAll("(?i):0b", ":false").replaceAll("(?i):1b", ":true"));
                if (!message.isEmpty()) {
                    sender.sendMessage(message);
                }
                return;
            }
            String message = MessageFile.getTranslation(MessageOption.MODIFY_COMPOUND).replace("{compound}", compound.toString());
            if (!message.isEmpty()) {
                sender.sendMessage(message.replaceAll("(?i):0b", ":false").replaceAll("(?i):1b", ":true"));
            }
            user.getPetEntity(type).ifPresent(entityPet -> {
                block3: {
                    if (entityPet instanceof IEntityControllerPet) {
                        entityPet = ((IEntityControllerPet)entityPet).getVisibleEntity();
                    }
                    try {
                        entityPet.applyCompound(compound);
                        sender.sendMessage(MessageFile.getTranslation(MessageOption.MODIFY_APPLIED).replace("{type}", type.getName()));
                    }
                    catch (Exception e) {
                        sender.sendMessage(MessageFile.getTranslation(MessageOption.INVALID_NBT));
                        String errorMessage = MessageFile.getTranslation(MessageOption.INVALID_NBT_MESSAGE).replace("{message}", e.getMessage().replaceAll("(?i):0b", ":false").replaceAll("(?i):1b", ":true"));
                        if (errorMessage.isEmpty()) break block3;
                        sender.sendMessage(errorMessage);
                    }
                }
            });
        });
    }
}

