/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.commands.list;

import java.util.Optional;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.command.CommandSender;
import simplepets.brainsynder.PetCore;
import simplepets.brainsynder.api.pet.IPetConfig;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.api.plugin.config.ConfigOption;
import simplepets.brainsynder.commands.Permission;
import simplepets.brainsynder.commands.PetSubCommand;
import simplepets.brainsynder.libs.bslib.commands.annotations.ICommand;
import simplepets.brainsynder.libs.bslib.nms.Tellraw;
import simplepets.brainsynder.utils.Utilities;

@ICommand(name="list", description="Lists all the different pet types")
@Permission(permission="list", defaultAllow=true)
public class ListCommand
extends PetSubCommand {
    public ListCommand(PetCore plugin) {
        super(plugin);
    }

    @Override
    public void run(CommandSender sender) {
        Tellraw raw = Tellraw.getInstance("Pet List: ").color("#d1c9c9");
        for (PetType type : PetType.values()) {
            if (type == PetType.UNKNOWN) continue;
            Optional<IPetConfig> config = SimplePets.getPetConfigManager().getPetConfig(type);
            Object tooltip = "";
            ChatColor color = ChatColor.GREEN;
            if (config.isPresent() && !config.get().isEnabled()) {
                color = ChatColor.RED;
                tooltip = String.valueOf(color) + "DISABLED";
            } else if (!type.isSupported()) {
                color = ChatColor.GOLD;
                tooltip = String.valueOf(color) + "NOT SUPPORTED";
            } else if (!SimplePets.getSpawnUtil().isRegistered(type)) {
                color = ChatColor.YELLOW;
                tooltip = String.valueOf(color) + "NOT REGISTERED";
            } else if (type.isInDevelopment() && !ConfigOption.INSTANCE.PET_TOGGLES_DEV_MOBS.getValue().booleanValue()) {
                color = ChatColor.GRAY;
                tooltip = String.valueOf(color) + "IN DEVELOPMENT";
            }
            if (ConfigOption.INSTANCE.MISC_TOGGLES_LIST_RESTRICTIONS.getValue().booleanValue() && (color != ChatColor.GREEN || !Utilities.hasPermission(sender, type.getPermission()))) continue;
            raw.then(type.getName()).color(color);
            if (!((String)tooltip).isEmpty()) {
                raw.tooltip(new String[]{tooltip});
            }
            raw.then(", ").color(ChatColor.of((String)"#d1c9c9"));
        }
        raw.send(sender);
    }
}

