/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.commands.list;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import simplepets.brainsynder.PetCore;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.commands.Permission;
import simplepets.brainsynder.commands.PetSubCommand;
import simplepets.brainsynder.files.MessageFile;
import simplepets.brainsynder.files.options.MessageOption;
import simplepets.brainsynder.libs.bslib.commands.annotations.ICommand;
import simplepets.brainsynder.managers.InventoryManager;

@ICommand(name="data", usage="[player] <type>", description="Opens the Pet Data GUI to customize your pet")
@Permission(permission="data", defaultAllow=true, additionalPermissions={"other"})
public class DataCommand
extends PetSubCommand {
    public DataCommand(PetCore plugin) {
        super(plugin);
    }

    @Override
    public List<String> handleCompletions(List<String> completions, CommandSender sender, int index, String[] args) {
        if (index == 1) {
            if (sender.hasPermission(this.getPermission("other"))) {
                completions.addAll(this.getOnlinePlayers());
            }
            completions.addAll(this.getPetTypes(sender));
            return completions;
        }
        if (index == 2) {
            Player target;
            Optional<PetType> optional = PetType.getPetType(args[0]);
            if (!optional.isPresent() && (target = Bukkit.getPlayer((String)args[0])) != null && sender.hasPermission(this.getPermission("other"))) {
                completions.addAll(this.getPetTypes());
            }
            return completions;
        }
        return super.handleCompletions(completions, sender, index, args);
    }

    @Override
    public void run(CommandSender sender, String[] args) {
        Player selected;
        if (args.length == 0) {
            this.sendUsage(sender);
            return;
        }
        AtomicInteger index = new AtomicInteger(0);
        Player target = null;
        if (this.isUsername(args[index.get()]) && sender.hasPermission(this.getPermission("other")) && (selected = Bukkit.getPlayerExact((String)args[index.get()])) != null) {
            target = selected;
            if (!sender.hasPermission(this.getPermission("other"))) {
                sender.sendMessage(MessageFile.getTranslation(MessageOption.NO_PERMISSION));
                return;
            }
            index.getAndIncrement();
        }
        if (target == null) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You must be a player to run this command for yourself.");
            } else {
                target = (Player)sender;
            }
        }
        Player finalTarget = target;
        SimplePets.getUserManager().getPetUser(target).ifPresent(user -> {
            Optional<PetType> petType = PetType.getPetType(args[index.get()]);
            if (!petType.isPresent()) {
                sender.sendMessage(MessageFile.getTranslation(MessageOption.INVALID_PET_TYPE).replace("{arg}", args[index.get()]));
                return;
            }
            PetType type = petType.get();
            if (!SimplePets.getSpawnUtil().isRegistered(type)) {
                sender.sendMessage(MessageFile.getTranslation(MessageOption.PET_NOT_REGISTERED).replace("{type}", type.getName()));
                return;
            }
            InventoryManager.PET_DATA.setType(finalTarget, type);
            InventoryManager.PET_DATA.open((PetUser)user);
        });
    }
}

