/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.commands.list;

import java.io.File;
import java.util.List;
import java.util.Optional;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import simplepets.brainsynder.PetCore;
import simplepets.brainsynder.addon.AddonCloudData;
import simplepets.brainsynder.addon.AddonLocalData;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.commands.Permission;
import simplepets.brainsynder.commands.PetSubCommand;
import simplepets.brainsynder.files.MessageFile;
import simplepets.brainsynder.files.options.MessageOption;
import simplepets.brainsynder.libs.bslib.commands.annotations.ICommand;
import simplepets.brainsynder.libs.bslib.json.Json;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.web.WebConnector;
import simplepets.brainsynder.managers.AddonManager;
import simplepets.brainsynder.menu.inventory.AddonMenu;

@ICommand(name="addon", usage="[install|reload|update] [addon]", description="Opens a GUI to download/toggle addons for the plugin")
@Permission(permission="addon", adminCommand=true, additionalPermissions={"install", "reload", "update"})
public class AddonCommand
extends PetSubCommand {
    public AddonCommand(PetCore plugin) {
        super(plugin);
    }

    @Override
    public List<String> handleCompletions(List<String> completions, CommandSender sender, int index, String[] args) {
        if (!this.canExecute(sender)) {
            return super.handleCompletions(completions, sender, index, args);
        }
        if (index == 1) {
            if (sender.hasPermission(this.getPermission("reload"))) {
                completions.add("reload");
            }
            if (sender.hasPermission(this.getPermission("update"))) {
                completions.add("update");
            }
            if (sender.hasPermission(this.getPermission("install"))) {
                completions.add("install");
            }
        }
        if (index == 2) {
            if (args[0].equalsIgnoreCase("update")) {
                PetCore.getInstance().getAddonManager().getLocalDataMap().keySet().forEach(localData -> completions.add(localData.getName()));
            }
            if (args[0].equalsIgnoreCase("install")) {
                PetCore.getInstance().getAddonManager().getCloudAddons().forEach(cloudData -> completions.add(cloudData.getName()));
            }
        }
        return super.handleCompletions(completions, sender, index, args);
    }

    @Override
    public void run(final CommandSender sender, String[] args) {
        if (args.length > 0) {
            if (args[0].equalsIgnoreCase("update") && sender.hasPermission(this.getPermission("update"))) {
                AddonManager manager = PetCore.getInstance().getAddonManager();
                if (args.length == 1) {
                    this.sendUsage(sender);
                    return;
                }
                String target = args[1];
                manager.fetchAddon(target).ifPresent(localData -> {
                    String name = localData.getName();
                    WebConnector.getInputStreamString("https://bsdevelopment.org/addons/addons.json", this.getPlugin(), result -> {
                        JsonObject json = (JsonObject)Json.parse(result);
                        if (!json.names().contains(name)) {
                            sender.sendMessage(MessageFile.getTranslation(MessageOption.PREFIX) + " \u00a7c" + name + " is not in the addon database: https://pluginwiki.us/addons/");
                            return;
                        }
                        String url = ((JsonObject)json.get(name)).getString("url", null);
                        if (url == null) {
                            sender.sendMessage(MessageFile.getTranslation(MessageOption.PREFIX) + " \u00a7c" + name + " seems to be missing the download URL (Contact brainsynder)");
                            return;
                        }
                        manager.update((AddonLocalData)localData, url, () -> sender.sendMessage(MessageFile.getTranslation(MessageOption.PREFIX) + " \u00a77" + name + " has been successfully updated!"));
                    });
                });
                return;
            }
            if (args[0].equalsIgnoreCase("install") && sender.hasPermission(this.getPermission("install"))) {
                AddonManager manager = PetCore.getInstance().getAddonManager();
                if (args.length == 1) {
                    this.sendUsage(sender);
                    return;
                }
                String target = args[1];
                Optional<AddonCloudData> cloudOptional = manager.fetchCloudData(target);
                if (cloudOptional.isEmpty()) {
                    sender.sendMessage(MessageFile.getTranslation(MessageOption.PREFIX) + " \u00a7c" + target + " is not a valid addon in our database.");
                    return;
                }
                AddonCloudData cloudData = cloudOptional.get();
                if (manager.fetchAddon(cloudData.getName()).isPresent()) {
                    sender.sendMessage(MessageFile.getTranslation(MessageOption.PREFIX) + " \u00a7c" + target + " is already installed, Looking to update it try: \u00a77/pet addon update " + target);
                    return;
                }
                sender.sendMessage(MessageFile.getTranslation(MessageOption.PREFIX) + " \u00a77Attempting to install: '" + target + "'");
                manager.downloadViaName(cloudData.getName(), cloudData.getDownloadURL(), () -> sender.sendMessage(MessageFile.getTranslation(MessageOption.PREFIX) + " \u00a77" + target + " has been successfully installed!"));
                return;
            }
            if (args[0].equalsIgnoreCase("reload") && sender.hasPermission(this.getPermission("reload"))) {
                final AddonManager manager = PetCore.getInstance().getAddonManager();
                manager.cleanup();
                final File folder = manager.getFolder();
                new BukkitRunnable(this){

                    public void run() {
                        if (!folder.exists()) {
                            return;
                        }
                        for (File file : folder.listFiles()) {
                            manager.loadAddon(file);
                        }
                        sender.sendMessage(MessageFile.getTranslation(MessageOption.PREFIX) + String.valueOf(ChatColor.GRAY) + "All Addons have been reloaded");
                    }
                }.runTaskLater((Plugin)PetCore.getInstance(), 1L);
                return;
            }
        }
        if (!(sender instanceof Player)) {
            this.sendUsage(sender);
            return;
        }
        SimplePets.getUserManager().getPetUser((Player)sender).ifPresent(user -> SimplePets.getGUIHandler().getInventory(AddonMenu.class).ifPresent(selectionMenu -> selectionMenu.open((PetUser)user)));
    }
}

