/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import simplepets.brainsynder.PetCore;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.commands.Permission;
import simplepets.brainsynder.libs.bslib.commands.SubCommand;
import simplepets.brainsynder.libs.bslib.commands.annotations.ICommand;
import simplepets.brainsynder.libs.bslib.nms.Tellraw;

public class PetSubCommand
extends SubCommand {
    private final PetCore plugin;

    public PetSubCommand(PetCore plugin) {
        this.plugin = plugin;
    }

    public PetCore getPlugin() {
        return this.plugin;
    }

    @Override
    public boolean canExecute(CommandSender sender) {
        if (!(sender instanceof Player)) {
            return true;
        }
        if (sender.isOp()) {
            return true;
        }
        if (this.needsPermission()) {
            return sender.hasPermission(this.getPermission());
        }
        return super.canExecute(sender);
    }

    @Override
    public List<String> handleCompletions(List<String> completions, CommandSender sender, int index, String[] args) {
        ICommand command = this.getCommand(this.getClass());
        if (command == null) {
            return completions;
        }
        String usage = command.usage();
        if (usage == null || usage.isEmpty()) {
            return completions;
        }
        String[] split = usage.split(" ");
        int current = 1;
        for (String value : split) {
            if (current == index) {
                if (value.contains("nbt") && sender.hasPermission(this.getPermission("nbt"))) {
                    completions.add("{}");
                }
                if (value.contains("type")) {
                    completions.addAll(this.getPetTypes(sender));
                }
                if (!value.contains("player") || !sender.hasPermission(this.getPermission("other"))) break;
                completions.addAll(this.getOnlinePlayers());
                break;
            }
            ++current;
        }
        return completions;
    }

    public boolean needsPermission() {
        return this.getClass().isAnnotationPresent(Permission.class);
    }

    public String getPermission() {
        if (this.getClass().isAnnotationPresent(Permission.class)) {
            return "pet.commands." + this.getClass().getAnnotation(Permission.class).permission();
        }
        return "";
    }

    public String getPermission(String addition) {
        if (this.getClass().isAnnotationPresent(Permission.class)) {
            return "pet.commands." + this.getClass().getAnnotation(Permission.class).permission() + "." + addition;
        }
        return "";
    }

    @Override
    public List<String> getOnlinePlayers() {
        ArrayList<String> list = new ArrayList<String>();
        Bukkit.getOnlinePlayers().forEach(o -> list.add(o.getName()));
        return list;
    }

    public List<String> getPetTypes() {
        ArrayList<String> list = new ArrayList<String>();
        for (PetType type : PetType.values()) {
            SimplePets.getPetConfigManager().getPetConfig(type).ifPresent(config -> {
                if (!config.isEnabled()) {
                    return;
                }
                if (!type.isSupported()) {
                    return;
                }
                if (!SimplePets.getSpawnUtil().isRegistered(type)) {
                    return;
                }
                list.add(type.getName());
            });
        }
        return list;
    }

    public List<String> getPetTypes(CommandSender sender) {
        ArrayList<String> list = new ArrayList<String>();
        for (PetType type : PetType.values()) {
            SimplePets.getPetConfigManager().getPetConfig(type).ifPresent(config -> {
                if (!config.isEnabled()) {
                    return;
                }
                if (!type.isSupported()) {
                    return;
                }
                if (!SimplePets.getSpawnUtil().isRegistered(type)) {
                    return;
                }
                if (!sender.hasPermission(type.getPermission())) {
                    return;
                }
                list.add(type.getName());
            });
        }
        return list;
    }

    public String formatJson(String json) {
        Pattern pattern = Pattern.compile("\"([^\"]*)\"");
        Matcher matcher = pattern.matcher(json);
        while (matcher.find()) {
            String string = matcher.group(1);
            if (!string.contains(" ")) continue;
            json = json.replace(string, string.replace(" ", "\u25cb!\u25d9"));
        }
        json = json.replace(" ", "");
        return json.replace("\u25cb!\u25d9", " ");
    }

    @Override
    public void sendUsage(CommandSender sender) {
        ICommand command = this.getCommand(this.getClass());
        String usage = command.usage().trim();
        String description = command.description();
        Tellraw raw = Tellraw.getInstance("\u00a7r \u00a7r ");
        raw.then("[] ").color(this.hex2Rgb("#e1eb5b"));
        raw.then("/pet ").color(this.hex2Rgb("#d1c9c9"));
        raw.then(command.name()).color(this.hex2Rgb("#d1c9c9"));
        ArrayList<String> tooltip = new ArrayList<String>();
        if (!description.isEmpty()) {
            tooltip.add(String.valueOf(ChatColor.GRAY) + description);
        }
        if (command.alias().length != 0 && !command.alias()[0].isEmpty()) {
            tooltip.add("&r");
            tooltip.add("&8Alias:");
            for (String alias : command.alias()) {
                tooltip.add(String.valueOf(ChatColor.GRAY) + " - " + alias);
            }
        }
        if (!tooltip.isEmpty()) {
            raw.tooltip(tooltip);
        }
        StringBuilder builder = new StringBuilder();
        if (!usage.isEmpty()) {
            for (char c : usage.replace(" ", "").toCharArray()) {
                if (c == '[' || c == '<') {
                    raw.then(" ");
                }
                if (c == '<' || c == '>') {
                    if (c == '>') {
                        raw.then(builder.toString()).color(this.hex2Rgb("#de9790")).tooltip(String.valueOf(ChatColor.RED) + "REQUIRED");
                        builder = new StringBuilder();
                    }
                    raw.then(Character.valueOf(c)).color(this.hex2Rgb("#b35349"));
                    continue;
                }
                if (c == '[' || c == ']') {
                    if (c == ']') {
                        raw.then(builder.toString()).color(this.hex2Rgb("#e3c79a")).tooltip(String.valueOf(ChatColor.YELLOW) + "OPTIONAL");
                        builder = new StringBuilder();
                    }
                    raw.then(Character.valueOf(c)).color(this.hex2Rgb("#e3aa4f"));
                    continue;
                }
                builder.append(c);
            }
        }
        raw.send(sender);
    }

    private Color hex2Rgb(String hex) {
        if (hex.startsWith("#") && hex.length() == 7) {
            int rgb;
            try {
                rgb = Integer.parseInt(hex.substring(1), 16);
            }
            catch (NumberFormatException var4) {
                throw new IllegalArgumentException("Illegal hex string " + hex);
            }
            return Color.fromRGB((int)rgb);
        }
        return Color.RED;
    }

    public boolean isUsername(String string) {
        return string.length() < 17 && string.length() > 2 && string.replace("_", "").matches("[A-Za-z0-9]+");
    }
}

