/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.api.wrappers.horse;

import java.lang.annotation.Annotation;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.inventory.ItemType;
import simplepets.brainsynder.libs.bslib.EnumVersion;
import simplepets.brainsynder.libs.bslib.ServerVersion;

public enum HorseArmorType {
    NONE(0, "barrier"),
    LEATHER(1, "leather_horse_armor"),
    COPPER(2, "copper_horse_armor"),
    IRON(3, "iron_horse_armor"),
    GOLD(4, "golden_horse_armor"),
    DIAMOND(5, "diamond_horse_armor"),
    NETHERITE(6, "netherite_horse_armor");

    private final int id;
    private final String rawMaterial;

    private HorseArmorType(int id, String rawMaterial) {
        this.id = id;
        this.rawMaterial = rawMaterial;
    }

    public boolean isSupported() {
        try {
            for (Annotation annotation : ((Object)((Object)this)).getClass().getField(this.name()).getAnnotations()) {
                if (!(annotation instanceof EnumVersion)) continue;
                EnumVersion support = (EnumVersion)annotation;
                if (support.maxVersion() == ServerVersion.UNKNOWN) {
                    return ServerVersion.isEqualNew(support.version());
                }
                return ServerVersion.isEqualOld(support.maxVersion()) && ServerVersion.isEqualNew(support.version());
            }
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return true;
    }

    public NamespacedKey getKey() {
        return NamespacedKey.minecraft((String)this.rawMaterial);
    }

    public ItemType itemType() {
        return (ItemType)Registry.ITEM.get(this.getKey());
    }

    public static HorseArmorType getByName(String name) {
        for (HorseArmorType wrapper : HorseArmorType.values()) {
            if (!wrapper.name().equalsIgnoreCase(name)) continue;
            return wrapper;
        }
        return NONE;
    }

    public static HorseArmorType fromId(int id) {
        for (HorseArmorType armor : HorseArmorType.values()) {
            if (armor.getId() != id) continue;
            return armor;
        }
        return null;
    }

    private static HorseArmorType traverse(HorseArmorType current, int step, HorseArmorType fallback) {
        int length = HorseArmorType.values().length;
        int start = current.ordinal();
        for (int i = 1; i <= length; ++i) {
            int index = Math.floorMod(start + step * i, length);
            HorseArmorType candidate = HorseArmorType.values()[index];
            if (!candidate.isSupported()) continue;
            return candidate;
        }
        return fallback;
    }

    public static HorseArmorType getPrevious(HorseArmorType current) {
        return HorseArmorType.traverse(current, -1, current);
    }

    public static HorseArmorType getNext(HorseArmorType current) {
        return HorseArmorType.traverse(current, 1, NONE);
    }

    public int getId() {
        return this.id;
    }
}

