/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.api.wrappers;

import java.util.Locale;
import org.bukkit.NamespacedKey;

public enum ArmadilloPhase {
    STANDING("9164ed0e0ef69b0ce7815e4300b4413a4828fcb0092918543545a418a48e0c3c", "IDLE"),
    ROLLED_UP("404d9164e8f76dcdde5f8d10ff67deb2d658a6008d23c44fb2f844e08591c01d", "ROLLING");

    private final NamespacedKey key;
    private final String texture;
    private final String mojangName;

    private ArmadilloPhase(String texture, String mojangName) {
        this.texture = "http://textures.minecraft.net/texture/" + texture;
        this.key = NamespacedKey.minecraft((String)this.name().toLowerCase(Locale.ROOT));
        this.mojangName = mojangName;
    }

    public String getMojangName() {
        return this.mojangName;
    }

    public String getTexture() {
        return this.texture;
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public static ArmadilloPhase getByID(int id) {
        for (ArmadilloPhase phase : ArmadilloPhase.values()) {
            if (phase.ordinal() != id) continue;
            return phase;
        }
        return STANDING;
    }

    public static ArmadilloPhase getByName(String name) {
        for (ArmadilloPhase phase : ArmadilloPhase.values()) {
            if (phase.name().equalsIgnoreCase(name)) {
                return phase;
            }
            if (!phase.getMojangName().equalsIgnoreCase(name)) continue;
            return phase;
        }
        return STANDING;
    }

    public static ArmadilloPhase getPrevious(ArmadilloPhase current) {
        if (current == STANDING) {
            return ROLLED_UP;
        }
        return ArmadilloPhase.values()[current.ordinal() - 1];
    }

    public static ArmadilloPhase getNext(ArmadilloPhase current) {
        if (current == ROLLED_UP) {
            return STANDING;
        }
        return ArmadilloPhase.values()[current.ordinal() + 1];
    }
}

