/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.api.plugin.utils;

import java.lang.reflect.Constructor;
import org.jetbrains.annotations.NotNull;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.libs.bslib.ServerVersion;

public final class HelperUtilities {
    public static final String NMS_PATH = new String(new byte[]{115, 105, 109, 112, 108, 101, 112, 101, 116, 115, 46, 98, 114, 97, 105, 110, 115, 121, 110, 100, 101, 114, 46, 118, 101, 114, 115, 105, 111, 110, 115});

    @NotNull
    public static <T> T getVersionedClass(@NotNull String className, @NotNull Class<T> expectedType, @NotNull Class<? extends T> fallbackType) {
        String mcVersion = ServerVersion.getVersion().name();
        String path = NMS_PATH + "." + mcVersion + "." + className;
        try {
            Class<?> rawType = Class.forName(path);
            if (!expectedType.isAssignableFrom(rawType)) {
                throw new IllegalStateException("Class " + path + " does not implement/extend " + expectedType.getName());
            }
            Object instance = HelperUtilities.newInstanceNoArgs(rawType);
            SimplePets.getPlugin().getLogger().info("Found support for version: " + mcVersion + " (" + path + ")");
            return (T)instance;
        }
        catch (Throwable ex) {
            try {
                T instance = HelperUtilities.newInstanceNoArgs(fallbackType);
                SimplePets.getPlugin().getLogger().warning("Missing version support for: " + mcVersion + " (" + path + "). Using fallback: " + fallbackType.getSimpleName());
                return instance;
            }
            catch (Throwable fallbackEx) {
                fallbackEx.addSuppressed(ex);
                throw new RuntimeException("Failed to create fallback for " + path, fallbackEx);
            }
        }
    }

    @NotNull
    private static <T> T newInstanceNoArgs(@NotNull Class<? extends T> type) throws Exception {
        Constructor<T> constructor = type.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        return constructor.newInstance(new Object[0]);
    }
}

