/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.api.plugin.config;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import simplepets.brainsynder.api.plugin.config.ConfigEntry;

public enum ConfigOption {
    INSTANCE;

    private final Map<String, ConfigEntry> options = new LinkedHashMap<String, ConfigEntry>();
    public final ConfigEntry<Boolean> RELOAD_DETECT = this.createOption("Reload-Detected", false, "This is used by the plugin to detect if the plugin was previously unloaded (via /reload or by a plugin)\n    CAN NOT BE CUSTOMIZED\n");
    public final ConfigEntry<Boolean> SIMPLER_GUI = this.createOption("Simpler-Pet-GUI-Command", false, "UGGGGGGGG This config option makes it so `/pet` opens the GUI (like `/pet gui`)\nRequires a server restart for some reason \u00af\\_(\u30c4)_/\u00af\n\nDefault: {default}");
    public final ConfigEntry<Boolean> UPDATE_CHECK_ENABLED = this.createOption("Update-Checking.Enabled", true, "Would you like to check for when there is a new update?\n\nDefault: {default}");
    public final ConfigEntry<Boolean> UPDATE_CHECK_ON_JOIN = this.createOption("Update-Checking.Message-On-Join", true, "Would you like to be alerted when there is a new update when you log in?\n(MUST HAVE 'pet.update' permission or OP)\n\nDefault: {default}");
    public final ConfigEntry<Boolean> UPDATE_CHECK_DEV_BUILDS = this.createOption("Update-Checking.Check-Dev-Builds", true, "This will enable checking for dev builds released on jenkins\n(This will only be used when you have downloaded the jar from either Polymart or Spigot)\n\nDefault: {default}");
    public final ConfigEntry<String> UPDATE_CHECK_UNIT = this.createOption("Update-Checking.unit", TimeUnit.HOURS.name(), "The unit of time for update checking\nTime Units:\n- SECONDS\n- MINUTES\n- HOURS\n- DAYS\n\nDefault: {default}");
    public final ConfigEntry<Integer> UPDATE_CHECK_TIME = this.createOption("Update-Checking.time", 12);
    public final ConfigEntry<List<String>> PERMISSIONS_IGNORE_LIST = this.createOption("Permissions.Ignored-List", new ArrayList(), "Any permission in this list will be ignored when the plugin checks if the player has permission\n(Will act like the player has the permission, without actually having it)\n\nDefault: {default}");
    public final ConfigEntry<Boolean> PERMISSIONS_ENABLED = this.createOption("Permissions.Enabled", true, "Disabling this would grant ALL players access to pets (they wont need permissions)\n\nDefault: {default}");
    public final ConfigEntry<Boolean> PERMISSIONS_OPEN_GUI = this.createOption("Permissions.Needs-Pet-Permission-for-GUI", false, "Enabling this would require players to have access to at least 1 pets permission\n\nDefault: {default}");
    public final ConfigEntry<Boolean> PERMISSIONS_DATA_PERMS = this.createOption("Permissions.Data-Permissions", true, "Disabling this will make it so players do not need to have any data permissions (EG. pet.type.armorstand.data.silent)\n\nDefault: {default}");
    public final ConfigEntry<Boolean> PERMISSIONS_PLAYER_ACCESS = this.createOption("Permissions.Only-Show-Pets-Player-Can-Access", true, "Enabling this would remove all the pets the player does not have access to from the GUI\n\nDefault: {default}");
    public final ConfigEntry<String> ADDON_LOAD_UNIT = this.createOption("addon-initialization.unit", TimeUnit.SECONDS.name(), "The unit of time for when the addons should be loaded\n\nTime Units:\n- SECONDS\n- MINUTES\n- HOURS\n- DAYS\n\nDefault: {default}");
    public final ConfigEntry<Integer> ADDON_LOAD_TIME = this.createOption("addon-initialization.time", 5, "The integer value which correlates to the selected unit\n\nExample:\n    unit: HOURS\n    time: 12\nWill be 12 Hours till the addons initiate\n\nDefault: {default}\n");
    public final ConfigEntry<Boolean> REMOVE_PET_ON_WORLD_CHANGE = this.createOption("RemovePetsOnWorldChange", true, "Disabling this will remove a players pet when they change worlds\n\nDefault: {default}");
    public final ConfigEntry<Boolean> RESPAWN_LAST_PET_LOGIN = this.createOption("Respawn-Last-Pet-On-Login", true, "When a player logs back in should their pet be spawned in as well?\nNOTE: If the player removed their pet before logging out then it wont respawn.\n\nDefault: {default}");
    public final ConfigEntry<Boolean> UTILIZE_PURCHASED_PETS = this.createOption("Utilize-Purchased-Pets", false, "This option will make it so if the player has the pet (was 'purchased' either via economy or the command)\nIt will allow the player to spawn that pet regardless if they have permission to it\n\nDefault: {default}");
    public final ConfigEntry<Boolean> AUTO_REMOVE_ENABLED = this.createOption("auto-remove.enabled", true, "Disabling this will make it so pets wont be automatically removed if the player is afk\n\nDefault: {default}").setPastPaths("PetToggles.AutoRemove.Enabled");
    public final ConfigEntry<Integer> AUTO_REMOVE_TICK = this.createOption("auto-remove.tick-delay", 10000, "What should the wait be?\nThis is in ticks (20 ticks = 1 second)\nExample: 10000 \u2248 8 minutes 20 seconds\n\nDefault: {default}").setPastPaths("PetToggles.AutoRemove.TickDelay");
    public final ConfigEntry<Boolean> PARTICLES_SUMMON_TOGGLE = this.createOption("Particles.Summon", true, "Disabling this would make it so there is no particles when a player spawns a pet\n\nDefault: {default}");
    public final ConfigEntry<Boolean> PARTICLES_FAILED_TOGGLE = this.createOption("Particles.Failed", true, "Disabling this would make it so there is no particles when a task fails for a player (EG: spawning, riding, etc..)\n\nDefault: {default}");
    public final ConfigEntry<Boolean> PARTICLES_REMOVE_TOGGLE = this.createOption("Particles.Remove", true, "Disabling this would make it so there is no particles when a player removes a pet\n\nDefault: {default}");
    public final ConfigEntry<Boolean> PARTICLES_RENAME_TOGGLE = this.createOption("Particles.Name-Change", true, "Disabling this would make it so there is no particles when a player renames a pet\n\nDefault: {default}");
    public final ConfigEntry<Boolean> PARTICLES_TELEPORT_TOGGLE = this.createOption("Particles.Teleport", true, "Disabling this would make it so there is no particles when a players pet teleports to its owner\n\nDefault: {default}");
    public final ConfigEntry<Boolean> PARTICLES_FAILED_TASK_TOGGLE = this.createOption("Particles.Failed-Task", true, "Disabling this would make it so there is no particles when a task for a pet fails\n\nDefault: {default}");
    public final ConfigEntry<Integer> PATHFINDING_MIN_DISTANCE = this.createOption("pathfinding.min-distance-to-player", 5, "This is the minimum distance a pet can be to a player\nNote: This is in reference to a random location around the player the pet could be closer then this\n\nDefault: {default}");
    public final ConfigEntry<Integer> PATHFINDING_MAX_DISTANCE = this.createOption("pathfinding.max-distance-to-player", 10, "This is the maximum stopping distance from the player\n\nDefault: {default}");
    public final ConfigEntry<Boolean> PATHFINDING_FOLLOW_WHEN_RIDING = this.createOption("pathfinding.follow-when-inside-vehicle", true, "Should the pets follow the player when they are in a vehicle (or riding another pet)?\n\nDefault: {default}");
    public final ConfigEntry<Integer> PATHFINDING_TELEPORT_DISTANCE = this.createOption("pathfinding.distance-till-teleport", 1000, "How far away from the player does the pet have to be before it teleports closer\n\nDefault: {default}");
    public final ConfigEntry<Boolean> LEGACY_PATHFINDING_ENABLED = this.createOption("legacy-pathfinding.enabled", false, "Would you rather use the legacy pathfinder?\n\nNote:\n- When enabled you will not receive support for issues pertaining to this pathfinder as our main priority is the new system\n- There are some issues with the legacy pathfinder that is known to cause high TPS lag on servers (this was fixed with the new system)\n  See: https://github.com/brainsynder-Dev/SimplePets/issues/260\n\nDefault: {default}");
    public final ConfigEntry<Integer> LEGACY_PATHFINDING_STOP_DISTANCE_LARGE = this.createOption("legacy-pathfinding.distance-to-player.large.walk", 7, "How far away can the pet be before it will stop walking near the player?\nLarge pets can be considered: Ravager, Ghast, Giant, Wither, ETC...\n\nExplanation: Pet is walking to player, they will stop within {default} blocks of the player\n\nDefault: {default}");
    public final ConfigEntry<Integer> LEGACY_PATHFINDING_STOP_DISTANCE_SMALL = this.createOption("legacy-pathfinding.distance-to-player.small.walk", 7, "How far away can the pet be before it will stop walking near the player?\nSmall pets can be considered: cow, chicken, enderman, armorstand, ETC...\n\nExplanation: Pet is walking to player, they will stop within {default} blocks of the player\n\nDefault: {default}");
    public final ConfigEntry<Integer> LEGACY_PATHFINDING_UPDATE_INTERVAL = this.createOption("legacy-pathfinding.update-interval", 10, "Modify this value to control how often a pet tries to calculate a new path to its owner\nNote: This is in ticks ( 20 ticks = 1 second )\n\nDefault: {default}");
    public final ConfigEntry<Boolean> WORLDS_ENABLED = this.createOption("Worlds.Enabled", false, "Enabling this will make it so pets only work in the worlds that are listed in 'Allowed-Worlds'\n\nDefault: {default}");
    public final ConfigEntry<List<String>> WORLDS_ALLOWED_WORLDS = this.createOption("Worlds.Allowed-Worlds", Lists.newArrayList((Object[])new String[]{"world"}), "List the worlds you want pets to be allowed to be spawned in\n\nDefault: {default}");
    public final ConfigEntry<String> WORLDS_FAIL_MESSAGE = this.createOption("Worlds.fail-message", "&cPets are not allowed to spawn in this world", "This message is only visible when the player hovers over the fail message\n\nDefault: {default}");
    public final ConfigEntry<Boolean> MYSQL_ENABLED = this.createOption("MySQL.Enabled", false, "Would you like to use MySQL to save player/pet data?\nIf this is disabled the plugin will save all the data using SQLite\n\nDefault: {default}");
    public final ConfigEntry<String> MYSQL_TABLE = this.createOption("MySQL.Table", "simplepets", "Default: {default}");
    public final ConfigEntry<String> MYSQL_HOST = this.createOption("MySQL.Host", "localhost", "Default: {default}");
    public final ConfigEntry<Integer> MYSQL_PORT = this.createOption("MySQL.Port", 3306, "Default: {default}");
    public final ConfigEntry<String> MYSQL_DATABASE = this.createOption("MySQL.DatabaseName", "SimplePets", "Default: {default}");
    public final ConfigEntry<String> MYSQL_USERNAME = this.createOption("MySQL.Login.Username", "username");
    public final ConfigEntry<String> MYSQL_PASSWORD = this.createOption("MySQL.Login.Password", "password");
    public final ConfigEntry<Boolean> MYSQL_SSL = this.createOption("MySQL.Options.UseSSL", false, "Default: {default}");
    public final ConfigEntry<Boolean> DEBUG_ENABLED = this.createOption("Debug.Enabled", true, "Would you like to view Debug information in the console/logs?\nIt can help you locate any issues or warnings\n\nDefault: {default}");
    public final ConfigEntry<Boolean> DEBUG_NORMAL_LEVEL = this.createOption("Debug.Levels.NORMAL", true, "This level of debug information is usually of little importance and just shows some hints\n\nDefault: {default}");
    public final ConfigEntry<Boolean> DEBUG_WARNING_LEVEL = this.createOption("Debug.Levels.WARNING", true, "This level of debug information is usually for when there is a minor issue like a missing config value\n\nDefault: {default}");
    public final ConfigEntry<Boolean> DEBUG_ERROR_LEVEL = this.createOption("Debug.Levels.ERROR", true, "This level of debug information is usually sent when there is an issue that NEEDS to be addressed\n\nDefault: {default}");
    public final ConfigEntry<Boolean> MISC_TOGGLES_IGNORE_ALLOWS_DEFAULT = this.createOption("misc-toggles.ignore-allows-default", false, "Should the help command ignore commands that are allowed by default\nExample: Could be used to hide commands they do not have permission to\n\nDefault: {default}").setPastPaths("ConfigToggles.IgnoreAllowsDefault");
    public final ConfigEntry<Boolean> MISC_TOGGLES_LIST_RESTRICTIONS = this.createOption("misc-toggles.restrict-pet-list", false, "Setting this to true will hide any Unregistered, Unsupported, and only show the pets the player can use/purchase in `/pet list`.\n\nDefault: {default}").setPastPaths("ConfigToggles.HideCertainPets");
    public final ConfigEntry<Boolean> MISC_TOGGLES_AUTO_CLOSE_REMOVE = this.createOption("misc-toggles.auto-closing.on-pet-remove", true, "Should the Pet GUI close when they remove a pet\n\nDefault: {default}").setPastPaths("InventoryToggles.AutoClosing.RemovePet");
    public final ConfigEntry<Boolean> MISC_TOGGLES_AUTO_CLOSE_RIDE = this.createOption("misc-toggles.auto-closing.on-pet-ride", true, "Should the Pet GUI close when they start riding a pet\n\nDefault: {default}").setPastPaths("InventoryToggles.AutoClosing.RidePet");
    public final ConfigEntry<Boolean> MISC_TOGGLES_AUTO_CLOSE_HAT = this.createOption("misc-toggles.auto-closing.on-pet-hat", true, "Should the Pet GUI close when they set a pet as a hat\n\nDefault: {default}").setPastPaths("InventoryToggles.AutoClosing.HatPet");
    public final ConfigEntry<Boolean> MISC_TOGGLES_REMOVE_ALL_PETS = this.createOption("misc-toggles.remove-all-pets", true, "When clicking the \"Remove Pet\" item should all pets be removed\n    (If true, the only way to select a specific pet would be to Shift-Click the item)\nOr should it open the Selection GUI to pick a pet to remove\n\nDefault: {default}");
    public final ConfigEntry<Boolean> MISC_TOGGLES_CLEAR_ALL_PLACEHOLDERS = this.createOption("misc-toggles.remove-all-placeholders", false, "This option allows for the removal of the placeholder items (The glass panes)\n\nNOTE: these are still required to be in the GUI, this will simply remove them afterwards\n\nDefault: {default}");
    public final ConfigEntry<Boolean> MISC_TOGGLES_CONSOLE_BYPASS_LIMIT = this.createOption("misc-toggles.console-bypasses-pet-limit", true, "When summoning a pet for a player via the servers console should the pet limit be enforced\n\nDefault: {default}");
    public final ConfigEntry<Boolean> MISC_TOGGLES_DISABLE_CLICKING = this.createOption("misc-toggles.disable-pet-right-clicking", false, "Should pet owners be able to open their pets data menu when right clicking the pet.\n\nDefault: {default}");
    public final ConfigEntry<Boolean> MISC_TOGGLES_PET_VANISHING = this.createOption("misc-toggles.vanishing.pet-visibility", true, "Should pets turn invisible when their owner is not visible (either via Spectator or Invisibility potions)\n\nDefault: {default}").setPastPaths("misc-toggles.enable-pet-vanishing");
    public final ConfigEntry<Boolean> MISC_TOGGLES_REMOVED_VANISH = this.createOption("misc-toggles.vanishing.remove-pet-when-vanished", false, "When the owner is vanished should the pets the player has active be removed?\n\nNOTE: This will override the 'pet-visibility' option\n\nDefault: {default}");
    public final ConfigEntry<Boolean> MISC_TOGGLES_WORLD_CONFINES_PET_LIMITS = this.createOption("misc-toggles.world-confines-pet-limits.enabled", false, "When pets are outside of the vertical confines of the world they will\nbe removed and more pets will be prevented from spawning\n\nNote: This is recommended if you are experiencing lag with pets and players being high up in the world\nNote: This MIGHT be removed in the future when a permanent fix is implemented\n\nDefault: {default}");
    public final ConfigEntry<String> MISC_TOGGLES_EXCEEDS_WORLD_CONFINES = this.createOption("misc-toggles.world-confines-pet-limits.spawning-error-message", "&cPets are not allowed to be spawned outside of the worlds vertical confines", "When pets are outside of the vertical confines of the world they will\nbe removed and more pets will be prevented from spawning\n\nNote: This is recommended if you are experiencing lag with pets and players being high up in the world\nNote: This MIGHT be removed in the future when a permanent fix is implemented\n\nDefault: {default}");
    public final ConfigEntry<Boolean> PET_TOGGLES_SPAWN_BYPASS = this.createOption("pet-toggles.mob-spawn-bypass", true, "When this is enabled it will allow pets to spawn anywhere\nThis is especially used if WorldGuard/PlotSquared are blocking mobs from spawning\n\nDefault: {default}").setPastPaths("PetToggles.MobSpawnBypass");
    public final ConfigEntry<Boolean> PET_TOGGLES_DEV_MOBS = this.createOption("pet-toggles.allow-in-development-mobs", false, "If this is true it will allow any mobs that are currently in-development to be spawned/registered\n\nDefault: {default}").setPastPaths("PetToggles.Allow-In-Development-Mobs");
    public final ConfigEntry<Boolean> PET_TOGGLES_MOB_PUSHER = this.createOption("pet-toggles.move-pets-get-out-da-way", false, "Are pets able to be pushed around\n\nDefault: {default}").setPastPaths("PetToggles.Move-Pets-Get-Out-Da-Way");
    public final ConfigEntry<Boolean> PET_TOGGLES_FALL_DAMAGE_NON_FLY = this.createOption("pet-toggles.fall-damage.non-flying-pets", true, "Should fall damage be allowed for Non-Flyable pets?\nExample: cow, pig, goat, etc...\n\nDefault: {default}").setPastPaths("PetToggles.FallDamage.Non-Flyable-Pets");
    public final ConfigEntry<Boolean> PET_TOGGLES_FALL_DAMAGE_FLY = this.createOption("pet-toggles.fall-damage.flying-pets", true, "Should fall damage be allowed for Flyable pets?\nExample: bat, bee, parrot, etc...\n\nDefault: {default}").setPastPaths("PetToggles.Flyable-Pets");
    public final ConfigEntry<Boolean> PET_TOGGLES_SPIDER_CLIMB = this.createOption("pet-toggles.traits.spider-wall-climbing", true, "Are spider type pets able to climb walls?\n\nDefault: {default}").setPastPaths("PetToggles.SpiderClimbing");
    public final ConfigEntry<Boolean> PET_TOGGLES_WARDEN_ANIMATIONS = this.createOption("pet-toggles.traits.warden-animations", true, "Should the spawning/de-spawning animation for the warden be used or just make them appear/disappear\n\nDefault: {default}");
    public final ConfigEntry<Boolean> PET_TOGGLES_GLOW_VANISH = this.createOption("pet-toggles.traits.glow-when-vanished", true, "When the owner is vanished should the owner see their pet with the glow effect?\nThe owner of the pet is the only one able to see it\n\nDefault: {default}").setPastPaths("PetToggles.GlowWhenVanished");
    public final ConfigEntry<Boolean> PET_TOGGLES_SHOW_NAMES = this.createOption("pet-toggles.show-pet-names", true, "Should pet names be seen?\n\nDefault: {default}").setPastPaths("PetToggles.ShowPetNames");
    public final ConfigEntry<Boolean> PET_TOGGLES_SHIFT_HIDDEN_NAMES = this.createOption("pet-toggles.hide-pet-names-when-shifting", true, "Should pet names be hidden when their owner sneaks?\n\nDefault: {default}").setPastPaths("PetToggles.HideNameOnShift");
    public final ConfigEntry<Boolean> PET_TOGGLES_MOUNTABLE = this.createOption("pet-toggles.all-pets-are-mountable", true, "Are all pets able to be rideable?\nWhen this is set to false only pets that have 'mount' set to true in their JSON file will be allowed\n\nDefault: {default}").setPastPaths("PetToggles.All-Pets-Mountable");
    public final ConfigEntry<Boolean> PET_TOGGLES_HAT = this.createOption("pet-toggles.all-pets-hat", true, "Are all pets able to be worn as hats?\nWhen this is set to false only pets that have 'hat' set to true in their JSON file will be allowed\n\nDefault: {default}").setPastPaths("PetToggles.All-Pets-Hat");
    public final ConfigEntry<Boolean> PET_TOGGLES_FLYABLE = this.createOption("pet-toggles.all-pets-flyable", false, "Are all pets able to fly when mounted?\nWhen this is set to false only pets that have 'fly' set to true in their JSON file will be allowed\n\nDefault: {default}").setPastPaths("PetToggles.All-Pets-Flyable");
    public final ConfigEntry<Integer> PET_TOGGLES_SPAWN_LIMIT = this.createOption("pet-toggles.pet-spawn-limit", 3, "The maximum number of pets a player can spawn at a time.\nThis can be overridden using pet.amount.<Number>, e.g. pet.amount.1 to only allow 1 at once.\n\nDefault: {default}").setPastPaths("PetToggles.Default-Spawn-Limit");
    public final ConfigEntry<Double> PET_TOGGLES_WALK_SPEED = this.createOption("pet-toggles.default-pet-walk-speed", 0.580804838418579, "The default walk speed each pet will go at.\nThis can be overridden in an individual pet JSON file using the 'walk_speed' key.\n\nDefault: {default}").setPastPaths("PetToggles.Default-Walk-Speed");
    public final ConfigEntry<Double> PET_TOGGLES_RIDE_SPEED = this.createOption("pet-toggles.default-pet-ride-speed", 0.200004838418579, "The default ride speed each pet will go at when mounted.\nThis can be overridden in an individual pet .json file using the ride_speed key.\n\nDefault: {default}").setPastPaths("PetToggles.Default-Ride-Speed");
    public final ConfigEntry<Double> PET_TOGGLES_FLY_SPEED = this.createOption("pet-toggles.default-pet-fly-speed", 0.300000438418579, "The default ride speed each pet will go at when mounted.\nThis can be overridden in an individual pet .json file using the ride_speed key.\n\nDefault: {default}").setPastPaths("PetToggles.Default-Ride-Speed");
    public final ConfigEntry<Boolean> PET_SAVES_ENABLED = this.createOption("pet-saves.enabled", true, "Do you want players to be able to save the pets they have spawned\nso they don't have to re-customize the pet to their state\n\nThis option will essentially disable the Saves GUI/Item\n\nDefault: {default}");
    public final ConfigEntry<Integer> PET_SAVES_LIMIT = this.createOption("pet-saves.default-limit", -1, "How many pets do you want your players to be able to save?\nSet this to `-1` if you want no limit\n\nCan be overrode via the permission `pet.saves.<amount>`\nBypass permission: `pet.saves.bypass`\n\nDefault: {default}");
    public final ConfigEntry<List<String>> PET_SAVES_TYPE_LIMIT = this.createOption("pet-saves.pet-type-limits", Lists.newArrayList((Object[])new String[]{""}), "This option allows you to list pet types and the limit for how many saves they can have\n\nExample: \"COW-2\"\nThis example will make it so the COW pet type can only be saved 2 times\n\nCan be overrode via the permission `pet.saves.<type>.<amount>`\nBypass permission: `pet.saves.bypass`\nBypass permission: `pet.saves.<type>.bypass`\n\nDefault: {default}");
    public final ConfigEntry<Boolean> RENAME_ENABLED = this.createOption("RenamePet.Enabled", true, "Should players be able to rename pets?\nThis will also control if the '/pet rename' and also the 'Rename Pet' item are available\n\nDefault: {default}");
    public final ConfigEntry<String> RENAME_TYPE = this.createOption("RenamePet.Type", "ANVIL", "How should the player be able to modify their pets name?\nTypes:\n- COMMAND (They have to use the '/pet rename' command to set the name)\n- CHAT (They have to type the name in chat)\n- ANVIL (The Anvil GUI will open and they can change the name there)\n- SIGN [REQUIRES ProtocolLib] (Will open a Sign GUI they input the name on the configured line)\n\nDefault: {default}");
    public final ConfigEntry<Boolean> RENAME_TRIM = this.createOption("RenamePet.Trim-Name", false, "Should there be spaces at the start and end of the name?\n\nDefault: {default}");
    public final ConfigEntry<Boolean> RENAME_LIMIT_CHARS_ENABLED = this.createOption("RenamePet.Character-Limit.Enabled", false, "Should the name have a limited number of characters?\n\nDefault: {default}");
    public final ConfigEntry<Integer> RENAME_LIMIT_CHARS_NUMBER = this.createOption("RenamePet.Character-Limit.Limit", 10, "What should the character limit be set to?\n\nDefault: {default}");
    public final ConfigEntry<List<String>> RENAME_BLOCKED_WORDS = this.createOption("RenamePet.Blocked-Words", Lists.newArrayList((Object[])new String[]{"jeb_"}), "Are there words you don't want in a pets name?\n   If You put an ^ at the start of the word/text it will ignore case\n         Example: ^ass will also flag ASS because it will ignore what case the letters are\n   If you put word in between () it will check if it contains ANY part of the word\n         Example: (ass) will also flag glass because it contains the word in it\n   If you just have the word it will check for the exact word\n         Example: 'ass' will just be flagged so 'glass' can be said\n\nDefault: {default}");
    public final ConfigEntry<String> RENAME_BLOCKED_PATTERN = this.createOption("RenamePet.Blocked-RegexPattern", "", "This blocks pets from having anything that matches the pattern as the name\nFor example MergedMobs has a pattern of '([0-9]+)(x)' will block names that are '999x'\nIf you want to use that pattern but ignore case then use '/([0-9]+)(x)/gmi'\nONLY CHECKS IF THE NAME MATCHES THE PATTERN\n\nDefault: {default}");
    public final ConfigEntry<Boolean> RENAME_COLOR_MAGIC = this.createOption("RenamePet.Allow-&k", false, "Are pet names allowed to have the &k color code?\n\nDefault: {default}");
    public final ConfigEntry<Boolean> RENAME_COLOR_ENABLED = this.createOption("RenamePet.ColorCodes.Enabled", true, "Are pet names allowed to be colored?\n\nDefault: {default}");
    public final ConfigEntry<Boolean> RENAME_COLOR_HEX = this.createOption("RenamePet.ColorCodes.Allow-HEX-Colors", true, "Are pet names allowed to have HEX colors?\nNOTE: If this is disabled only regular chat color will be used (EG: '&c')\nExample: '&#c986b2'\n\nDefault: {default}");

    private <T> ConfigEntry<T> createOption(String key, T value, String description) {
        ConfigEntry<T> option = new ConfigEntry<T>(key, value, description);
        this.options.put(key, option);
        return option;
    }

    private <T> ConfigEntry<T> createOption(String key, T value) {
        ConfigEntry<T> option = new ConfigEntry<T>(key, value);
        this.options.put(key, option);
        return option;
    }

    public Map<String, ConfigEntry> getOptions() {
        return this.options;
    }
}

