/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.api.plugin.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import simplepets.brainsynder.api.plugin.SimplePets;

public class ConfigEntry<T> {
    private final T defaultValue;
    private T value;
    private final String path;
    private final String description;
    private final List<String> PAST_PATHS;

    ConfigEntry(String path, T value, String description) {
        this.path = path;
        this.value = value;
        this.defaultValue = this.value;
        this.description = description;
        this.PAST_PATHS = new ArrayList<String>();
    }

    ConfigEntry(String path, T value) {
        this(path, value, null);
    }

    public String getDescription() {
        return this.description;
    }

    public String getPath() {
        return this.path;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    ConfigEntry<T> setPastPaths(String ... paths) {
        this.PAST_PATHS.addAll(Arrays.asList(paths));
        return this;
    }

    public List<String> getPastPaths() {
        return this.PAST_PATHS;
    }

    public void setValue(T value, boolean saveConfig) {
        this.value = value;
        if (saveConfig) {
            SimplePets.getConfiguration().set(this.path, value);
        }
    }

    public T getValue() {
        if (this.value == null) {
            return this.defaultValue;
        }
        return this.value;
    }

    public String getExamples() {
        String className = this.defaultValue.getClass().getSimpleName();
        if (className.equalsIgnoreCase("boolean")) {
            return "true or false";
        }
        if (className.equalsIgnoreCase("double")) {
            return "1.0";
        }
        if (className.equalsIgnoreCase("integer")) {
            return "1, 2, 3";
        }
        if (className.equalsIgnoreCase("String")) {
            return "\"im a string\"";
        }
        return null;
    }
}

