/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.api.pet.data;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;
import org.bukkit.Material;
import simplepets.brainsynder.api.Namespace;
import simplepets.brainsynder.api.entity.misc.ISizable;
import simplepets.brainsynder.api.pet.IPetConfig;
import simplepets.brainsynder.api.pet.PetData;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.libs.bslib.item.ItemBuilder;
import simplepets.brainsynder.libs.bslib.json.JsonObject;

@Namespace(namespace="size")
public class SizeData
extends PetData<ISizable> {
    public SizeData() {
        this.addDefaultItem("1", new ItemBuilder(Material.PLAYER_HEAD).withName("&#c8c8c8{name}: &#e1eb5b1").setTexture("http://textures.minecraft.net/texture/ca516fbae16058f251aef9a68d3078549f48f6d5b683f19cf5a1745217d72cc"));
        this.addDefaultItem("2", new ItemBuilder(Material.PLAYER_HEAD).withName("&#c8c8c8{name}: &#e1eb5b2").setTexture("http://textures.minecraft.net/texture/4698add39cf9e4ea92d42fadefdec3be8a7dafa11fb359de752e9f54aecedc9a"));
        this.addDefaultItem("3", new ItemBuilder(Material.PLAYER_HEAD).withName("&#c8c8c8{name}: &#e1eb5b3").setTexture("http://textures.minecraft.net/texture/fd9e4cd5e1b9f3c8d6ca5a1bf45d86edd1d51e535dbf855fe9d2f5d4cffcd2"));
        this.addDefaultItem("4", new ItemBuilder(Material.PLAYER_HEAD).withName("&#c8c8c8{name}: &#e1eb5b4").setTexture("http://textures.minecraft.net/texture/f2a3d53898141c58d5acbcfc87469a87d48c5c1fc82fb4e72f7015a3648058"));
    }

    @Override
    public Object getDefaultValue() {
        return 1;
    }

    @Override
    public Optional<ItemBuilder> getItem(ISizable entity) {
        Optional<ItemBuilder> optional = super.getItem(entity);
        if (!optional.isPresent() && !this.getSizes(entity).contains(entity.getSize())) {
            return Optional.of(new ItemBuilder(Material.PLAYER_HEAD).withName("&#c8c8c8Size: &#e1eb5b?").setTexture("http://textures.minecraft.net/texture/bc8ea1f51f253ff5142ca11ae45193a4ad8c3ab5e9c6eec8ba7a4fcb7bac40"));
        }
        return optional;
    }

    private LinkedList<Integer> getSizes(ISizable entity) {
        LinkedList<Integer> sizes = new LinkedList<Integer>();
        Optional<IPetConfig> optional = SimplePets.getPetConfigManager().getPetConfig(entity.getPetType());
        Namespace namespace = this.getNamespace();
        if (optional.isPresent()) {
            IPetConfig config = optional.get();
            JsonObject json = config.getRawData(namespace.namespace());
            json.names().forEach(string -> {
                try {
                    int size = Integer.parseInt(string);
                    sizes.add(size);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
        }
        if (sizes.isEmpty()) {
            sizes.addAll(Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4}));
        }
        return sizes;
    }

    @Override
    public void onLeftClick(ISizable entity) {
        Navigating navigating = new Navigating(this.getSizes(entity));
        entity.setSize(navigating.getNext(navigating.getIndex(entity.getSize())));
    }

    @Override
    public void onRightClick(ISizable entity) {
        Navigating navigating = new Navigating(this.getSizes(entity));
        entity.setSize(navigating.getPrevious(navigating.getIndex(entity.getSize())));
    }

    @Override
    public Object value(ISizable entity) {
        return entity.getSize();
    }

    static class Navigating {
        private final LinkedList<Integer> list;

        Navigating(LinkedList<Integer> list) {
            this.list = list;
        }

        int getIndex(int currentNumber) {
            int num;
            int index = 0;
            Iterator iterator = this.list.iterator();
            while (iterator.hasNext() && (num = ((Integer)iterator.next()).intValue()) != currentNumber) {
                ++index;
            }
            return index;
        }

        int getNext(int index) {
            if (this.list.isEmpty()) {
                return 1;
            }
            if (index < 0) {
                index = 0;
            }
            if (index >= this.list.size() - 1) {
                return this.list.get(0);
            }
            return this.list.get(++index);
        }

        int getPrevious(int index) {
            if (this.list.isEmpty()) {
                return 4;
            }
            if (index >= this.list.size()) {
                index = this.list.size() - 1;
            }
            if (index <= 0) {
                return this.list.get(this.list.size() - 1);
            }
            return this.list.get(--index);
        }
    }
}

