/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.api.inventory;

import java.io.File;
import java.util.Optional;
import simplepets.brainsynder.api.Namespace;
import simplepets.brainsynder.api.entity.IEntityPet;
import simplepets.brainsynder.api.inventory.CustomInventory;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.debug.DebugLevel;
import simplepets.brainsynder.libs.bslib.files.JsonFile;
import simplepets.brainsynder.libs.bslib.item.ItemBuilder;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagTools;
import simplepets.brainsynder.libs.bslib.nms.DataConverter;
import simplepets.brainsynder.libs.bslib.utils.DyeColorWrapper;

public abstract class Item
extends JsonFile {
    private boolean tried = false;

    public Item(File file) {
        super(file);
    }

    public void onClick(PetUser user, CustomInventory inventory) {
        this.onClick(user, inventory, null);
    }

    public void onShiftClick(PetUser user, CustomInventory inventory) {
        this.onShiftClick(user, inventory, null);
    }

    public abstract void onClick(PetUser var1, CustomInventory var2, IEntityPet var3);

    public void onShiftClick(PetUser user, CustomInventory inventory, IEntityPet pet) {
    }

    public boolean addItemToInv(PetUser user, CustomInventory inventory) {
        return true;
    }

    @Override
    public void loadDefaults() {
        this.setDefault("enabled", true);
        if (this.getDefaultItem() != null) {
            this.setDefault("item", StorageTagTools.toJsonObject(this.getDefaultItem().toCompound()));
        }
    }

    public ItemBuilder getItemBuilder() {
        if (this.hasKey("item")) {
            try {
                return ItemBuilder.fromCompound(StorageTagTools.fromJsonObject((JsonObject)this.getValue("item")));
            }
            catch (IllegalArgumentException ex) {
                SimplePets.getDebugLogger().debug(DebugLevel.ERROR, "Error thrown when creating item for " + this.getClass().getSimpleName() + ".");
                return this.getDefaultItem();
            }
        }
        if (!this.tried) {
            this.reload();
            this.tried = true;
            return this.getItemBuilder();
        }
        if (this.getDefaultItem() != null) {
            return this.getDefaultItem();
        }
        return DataConverter.getColoredMaterial(DataConverter.MaterialType.STAINED_GLASS_PANE, DyeColorWrapper.RED);
    }

    @Deprecated
    public abstract ItemBuilder getDefaultItem();

    public Optional<Namespace> getItemData() {
        if (this.getClass().isAnnotationPresent(Namespace.class)) {
            return Optional.of(this.getClass().getAnnotation(Namespace.class));
        }
        return Optional.empty();
    }

    public boolean isEnabled() {
        if (this.hasKey("enabled")) {
            return this.getBoolean("enabled");
        }
        return true;
    }
}

