/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.api.animation;

import org.bukkit.util.EulerAngle;
import simplepets.brainsynder.api.entity.ambient.IEntityArmorStandPet;
import simplepets.brainsynder.libs.bslib.utils.AdvString;

public class AnimationFrame {
    private EulerAngle head;
    private EulerAngle body;
    private EulerAngle leftHand;
    private EulerAngle rightHand;
    private EulerAngle leftLeg;
    private EulerAngle rightLeg;

    public AnimationFrame setHead(EulerAngle head) {
        this.head = head;
        return this;
    }

    public AnimationFrame setBody(EulerAngle body) {
        this.body = body;
        return this;
    }

    public AnimationFrame setLeftHand(EulerAngle leftHand) {
        this.leftHand = leftHand;
        return this;
    }

    public AnimationFrame setRightHand(EulerAngle rightHand) {
        this.rightHand = rightHand;
        return this;
    }

    public AnimationFrame setLeftLeg(EulerAngle leftLeg) {
        this.leftLeg = leftLeg;
        return this;
    }

    public AnimationFrame setRightLeg(EulerAngle rightLeg) {
        this.rightLeg = rightLeg;
        return this;
    }

    public void setLocations(IEntityArmorStandPet armor) {
        armor.setHeadAngle(this.head == null ? armor.getHeadAngle() : this.head);
        armor.setBodyAngle(this.body == null ? armor.getBodyAngle() : this.body);
        armor.setLeftArmAngle(this.leftHand == null ? armor.getLeftArmAngle() : this.leftHand);
        armor.setRightArmAngle(this.rightHand == null ? armor.getRightArmAngle() : this.rightHand);
        armor.setLeftLegAngle(this.leftLeg == null ? armor.getLeftLegAngle() : this.leftLeg);
        armor.setRightLegAngle(this.rightLeg == null ? armor.getRightLegAngle() : this.rightLeg);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AnimationFrame{");
        if (this.head != null) {
            builder.append("head=").append(this.formatAngle(this.head)).append(", ");
        }
        if (this.body != null) {
            builder.append("body=").append(this.formatAngle(this.body)).append(", ");
        }
        if (this.leftHand != null) {
            builder.append("leftHand=").append(this.formatAngle(this.leftHand)).append(", ");
        }
        if (this.rightHand != null) {
            builder.append("rightHand=").append(this.formatAngle(this.rightHand)).append(", ");
        }
        if (this.leftLeg != null) {
            builder.append("leftLeg=").append(this.formatAngle(this.leftLeg)).append(", ");
        }
        if (this.rightLeg != null) {
            builder.append("rightLeg=").append(this.formatAngle(this.rightLeg)).append(", ");
        }
        return AdvString.replaceLast(", ", "}", builder.toString());
    }

    private String formatAngle(EulerAngle angle) {
        return "x: " + angle.getX() + " y: " + angle.getY() + " z: " + angle.getZ();
    }
}

