/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.api;

public record SpawnResult<T>(State state, T value, String failMessage) {
    private final T value;
    private final String failMessage;

    public static <T> SpawnResult<T> success(T value) {
        return new SpawnResult<T>(State.SUCCESS, value, null);
    }

    public static <T> SpawnResult<T> fail(String message) {
        return new SpawnResult<Object>(State.FAILURE, null, message);
    }

    public static <T> SpawnResult<T> empty() {
        return new SpawnResult<Object>(State.EMPTY, null, null);
    }

    public boolean isSuccess() {
        return this.state == State.SUCCESS;
    }

    public boolean isFailure() {
        return this.state == State.FAILURE;
    }

    public boolean isEmpty() {
        return this.state == State.EMPTY;
    }

    public T value() {
        if (this.state != State.SUCCESS) {
            throw new IllegalStateException("Missing spawn result value (state=" + String.valueOf((Object)this.state) + ")");
        }
        return this.value;
    }

    public String failMessage() {
        if (this.state != State.FAILURE) {
            throw new IllegalStateException("Missing spawn attempt failure failMessage (state=" + String.valueOf((Object)this.state) + ")");
        }
        return this.failMessage;
    }

    public static enum State {
        SUCCESS,
        FAILURE,
        EMPTY;

    }
}

