/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.addon.presets;

import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import simplepets.brainsynder.addon.AddonConfig;
import simplepets.brainsynder.addon.AddonPermissions;
import simplepets.brainsynder.addon.PermissionData;
import simplepets.brainsynder.addon.PetModule;
import simplepets.brainsynder.api.entity.IEntityPet;
import simplepets.brainsynder.api.entity.misc.IEntityControllerPet;
import simplepets.brainsynder.api.event.entity.PetEntitySpawnEvent;
import simplepets.brainsynder.api.event.entity.PetMountEvent;
import simplepets.brainsynder.api.event.entity.PetMoveEvent;
import simplepets.brainsynder.api.event.entity.movment.PetRideEvent;
import simplepets.brainsynder.api.user.PetUser;

public abstract class RegionModule
extends PetModule {
    private boolean spawningEnabled = true;
    private String spawningReason;
    private boolean movingEnabled = true;
    private boolean movingRemove = true;
    private boolean mountingEnabled = true;
    private boolean mountingRemove = true;
    private boolean ridingEnabled = true;
    private boolean ridingRemove = true;
    private boolean ridingDismount = true;
    private PermissionData bypassPermission;

    public abstract boolean isSpawningAllowed(PetUser var1, Location var2);

    public abstract boolean isMovingAllowed(PetUser var1, Location var2);

    public abstract boolean isRidingAllowed(PetUser var1, Location var2);

    public abstract boolean isMountingAllowed(PetUser var1, Location var2);

    @Override
    public void init() {
        AddonPermissions.register(this, this.bypassPermission);
    }

    @Override
    public void loadDefaults(AddonConfig config) {
        config.addDefault("bypass-permission", "pet." + this.getNamespace().namespace().toLowerCase() + ".bypass", "What should the bypass permission be set to?");
        config.addDefault("checks.spawning.enabled", true, "Should the addon check when a pet is spawned?");
        config.addDefault("checks.spawning.reason", "&cYour pet is not able to be spawned in this area", "This message is only visible when you hover over the 'pet failed to spawn' message\nYou can make this blank or 'null' if you want no message");
        config.addDefault("checks.mounting.enabled", true, "Should the addon check when the player mounts the pet?");
        config.addDefault("checks.mounting.remove-pet", true, "Should the pet be removed or should it just be canceled?");
        config.addDefault("checks.moving.enabled", true, "Should the addon check when a pet moves?");
        config.addDefault("checks.moving.remove-pet", true, "Should the pet be removed or should it just be canceled?");
        config.addDefault("checks.riding.enabled", true, "Should the addon check when the pets owner is riding it?");
        config.addDefault("checks.riding.remove-pet", true, "Should the pet be removed or should it just be canceled?");
        config.addDefault("checks.riding.dismount", true, "Should the player be dismounted (if remove-pet is set to true this is ignored)?");
        this.spawningEnabled = config.getBoolean("checks.spawning.enabled", true);
        this.spawningReason = config.getString("checks.spawning.reason", null);
        this.mountingEnabled = config.getBoolean("checks.mounting.enabled", true);
        this.mountingRemove = config.getBoolean("checks.mounting.remove-pet", true);
        this.movingEnabled = config.getBoolean("checks.moving.enabled", true);
        this.movingRemove = config.getBoolean("checks.moving.remove-pet", true);
        this.ridingEnabled = config.getBoolean("checks.riding.enabled", true);
        this.ridingRemove = config.getBoolean("checks.riding.remove-pet", true);
        this.ridingDismount = config.getBoolean("checks.riding.dismount", true);
        this.bypassPermission = new PermissionData(config.getString("bypass-permission", "pet." + this.getNamespace().namespace().toLowerCase() + ".bypass")).setDescription("When the player has this permission they will be able to bypass the checks");
    }

    @EventHandler
    public void onSpawn(PetEntitySpawnEvent event) {
        if (!this.spawningEnabled) {
            return;
        }
        Player player = event.getUser().getPlayer();
        if (player.hasPermission(this.bypassPermission.getPermission())) {
            return;
        }
        boolean allowed = this.isSpawningAllowed(event.getUser(), event.getEntity().getEntity().getLocation());
        if (this.spawningReason == null || this.spawningReason.equalsIgnoreCase("null") || this.spawningReason.isEmpty()) {
            event.setCancelled(!allowed);
        } else {
            event.setCancelled(!allowed, this.spawningReason);
        }
    }

    @EventHandler
    public void onMove(PetMoveEvent event) {
        if (!this.movingEnabled) {
            return;
        }
        Player player = event.getEntity().getPetUser().getPlayer();
        if (player == null) {
            return;
        }
        if (player.hasPermission(this.bypassPermission.getPermission())) {
            return;
        }
        if (this.isMovingAllowed(event.getEntity().getPetUser(), event.getTargetLocation())) {
            return;
        }
        event.setCancelled(true);
        if (this.movingRemove) {
            event.getEntity().getPetUser().removePet(event.getEntity().getPetType());
        }
    }

    @EventHandler
    public void onRide(PetRideEvent event) {
        if (!this.ridingEnabled) {
            return;
        }
        IEntityPet entityPet = event.getEntity();
        PetUser user = entityPet.getPetUser();
        Player player = user.getPlayer();
        if (player.hasPermission(this.bypassPermission.getPermission())) {
            return;
        }
        if (this.isRidingAllowed(user, event.getTargetLocation())) {
            return;
        }
        if (this.ridingRemove) {
            user.removePet(entityPet.getPetType());
            return;
        }
        if (this.ridingDismount) {
            if (entityPet.getEntity().getPassenger() != null) {
                if (entityPet instanceof IEntityControllerPet) {
                    ((IEntityControllerPet)entityPet).getDisplayEntity().ifPresent(Entity::eject);
                } else {
                    entityPet.getEntity().eject();
                }
            }
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onMount(PetMountEvent event) {
        if (!this.mountingEnabled) {
            return;
        }
        PetUser user = event.getEntity().getPetUser();
        Player player = user.getPlayer();
        if (player.hasPermission(this.bypassPermission.getPermission())) {
            return;
        }
        if (this.isMountingAllowed(user, event.getEntity().getEntity().getLocation())) {
            return;
        }
        event.setCancelled(true);
        if (this.mountingRemove) {
            user.removePet(event.getEntity().getPetType());
        }
    }
}

