/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.addon.presets;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import simplepets.brainsynder.addon.AddonConfig;
import simplepets.brainsynder.addon.AddonPermissions;
import simplepets.brainsynder.addon.PermissionData;
import simplepets.brainsynder.addon.PetModule;
import simplepets.brainsynder.api.event.inventory.PetInventoryAddPetItemEvent;
import simplepets.brainsynder.api.event.inventory.PetSelectTypeEvent;
import simplepets.brainsynder.api.inventory.handler.InventoryType;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.libs.bslib.item.ItemBuilder;
import simplepets.brainsynder.libs.bslib.utils.Colorize;

public abstract class EconomyModule
extends PetModule {
    private final Map<PetType, Double> priceMap = Maps.newHashMap();
    private String prefix;
    private String bypassPerm;
    private String freePrice;
    private String bypassPrice;
    private String insufficientFunds;
    private String successfulPayment;
    private String paid;
    private String boolTrue;
    private String boolFalse;
    private List<String> lore;
    private boolean hidePrice;
    private boolean payPerUse;
    private Map<PetType, String> typePermissions;

    @Override
    public void init() {
        PermissionData parent = new PermissionData(this.bypassPerm).setDescription("This is the master permission, Will ignore all individual bypass permissions listed below");
        this.typePermissions.forEach((type, s) -> AddonPermissions.register(this, parent, new PermissionData((String)s).setDescription("This is a bypass permission for the " + type.getName() + " pet, who ever has this permission will not have to pay for this pet")));
    }

    @Override
    public void cleanup() {
        if (this.priceMap != null) {
            this.priceMap.clear();
        }
        if (this.typePermissions != null) {
            this.typePermissions.clear();
        }
        this.typePermissions = null;
        this.bypassPerm = null;
    }

    @Override
    public void loadDefaults(AddonConfig config) {
        this.typePermissions = Maps.newHashMap();
        String bypassPermission = "pet." + this.getNamespace().namespace().toLowerCase().replace(" ", "_") + ".bypass";
        config.addDefault("Hide-Price-If-Bypassed", true, "Disabling this will make the items show the price, but if the player has bypass permissions he wont have to pay\nDefault: true");
        config.addDefault("Pay-Per-Use-Enabled", false, "Should players have to pay each time they spawn a pet?\nDefault: false");
        config.addDefault("Price.Free", "Free", "If a pet is free this will be in the place of the price in the lore\nDefault: 'Free'");
        config.addDefault("Price.Bypassed", "BYPASSED", "If the player has the bypass permission, will be in the place of the price in the lore\nDefault: 'BYPASSED'");
        config.addComment("Boolean", "Here is where you can set the translations for the 2 boolean values (true/false)");
        config.addDefault("Boolean.true", (Object)"&#92fc98true");
        config.addDefault("Boolean.false", (Object)"&#fa7d7dfalse");
        config.addDefault("Messages.prefix", (Object)"&eSimplePets &6>>");
        config.addDefault("Messages.PurchaseSuccessful.One-Time-Purchase", "{prefix} &7You have Successfully Purchased the {type} Pet.", "This message will be sent if the purchase it successful\nPlaceholders:\n- {prefix} (uses the customized prefix)\n- {type} (will get what type of pet it is)\n- {price} (what price the pet is)");
        config.addDefault("Messages.PurchaseSuccessful.Pay-Per-Use", "{prefix} &7You have Successfully Paid for the {type} Pet.", "This message will be sent if the purchase it successful while Pay-Per-Use is set to true\nPlaceholders:\n- {prefix} (uses the customized prefix)\n- {type} (will get what type of pet it is)\n- {price} (what price the pet is)");
        config.addDefault("Messages.InsufficientFunds", "{prefix} &cYou do not have enough money to buy this pet, you need to have {price}", "This message will be sent if the player does not have enough money to buy the pet\nPlaceholders:\n- {prefix} (uses the customized prefix)\n- {type} (will get what type of pet it is)\n- {price} (what price the pet is)");
        config.addDefault("Messages.Lore-Lines.One-Time-Purchase", Lists.newArrayList((Object[])new String[]{"&#ffbf5ePrice: &#99ffac{price}", "&#ffbf5ePurchased: {purchased}"}), "These Lore Lines will only be used if 'Pay-Per-Use' is set to false\nPlaceholders:\n- {price} (price of the pet)\n- {purchased} (true/false if the player purchased the pet)");
        config.addDefault("Messages.Lore-Lines.Pay-Per-Use", Collections.singletonList("&#ffbf5ePrice: &#99ffac{price}"), "These lines get added to the pet items when the GUI is opened\nPlaceholders:\n- {price} (price of the pet)\n- {purchased} (true/false if the player purchased the pet)");
        config.addDefault("bypass_permissions.parent", bypassPermission, "This is the master permission, Will ignore all individual bypass permissions listed below");
        for (PetType type : PetType.values()) {
            if (type == PetType.UNKNOWN || !type.isSupported()) continue;
            config.addDefault("type." + type.getName(), this.getDefaultPrice(), "The price of the " + type.getName() + " pet");
            config.addDefault("bypass_permissions.type." + type.getName(), bypassPermission + "." + type.getName(), "This is a bypass permission for the " + type.getName() + " pet, who ever has this permission will now have to pay for this pet");
            this.typePermissions.put(type, config.getString("bypass_permissions.type." + type.getName(), bypassPermission + "." + type.getName()));
            this.priceMap.put(type, config.getDouble("type." + type.getName(), this.getDefaultPrice()));
        }
        this.hidePrice = config.getBoolean("Hide-Price-If-Bypassed", true);
        this.payPerUse = config.getBoolean("Pay-Per-Use-Enabled", false);
        this.boolTrue = config.getString("Boolean.true", "&#92fc98true");
        this.boolFalse = config.getString("Boolean.false", "&#fa7d7dfalse");
        this.prefix = config.getString("Messages.prefix", "&eSimplePets &6>>");
        this.bypassPerm = config.getString("bypass_permission", bypassPermission);
        this.bypassPrice = String.valueOf(config.get("Price.Bypassed", "BYPASSED"));
        this.freePrice = config.getString("Price.Free", "Free");
        this.insufficientFunds = config.getString("Messages.InsufficientFunds", "{prefix} &cYou do not have enough money to buy this pet, you need to have {price}");
        this.paid = config.getString("Messages.PurchaseSuccessful.Pay-Per-Use", "{prefix} &7You have Successfully paid for the {type} Pet.");
        this.successfulPayment = config.getString("Messages.PurchaseSuccessful.One-Time-Purchase", "{prefix} &7You have Successfully Purchased the {type} Pet.");
        this.lore = config.getStringList(config.getBoolean("Pay-Per-Use-Enabled") ? "Messages.Lore-Lines.Pay-Per-Use" : "Messages.Lore-Lines.One-Time-Purchase");
    }

    public abstract int getDefaultPrice();

    public void fetchBalance(UUID uuid, Consumer<Double> balanceConsumer) {
        balanceConsumer.accept(this.getBalance(uuid));
    }

    public abstract double getBalance(UUID var1);

    public abstract void withdraw(UUID var1, double var2);

    private String var(boolean value) {
        return value ? this.boolTrue : this.boolFalse;
    }

    public boolean isPetFree(PetType type) {
        return this.priceMap.getOrDefault((Object)type, 2000.0) <= 0.0;
    }

    @EventHandler
    public void onInventoryOpen(PetInventoryAddPetItemEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (event.getInventory().getInventoryType() != InventoryType.SUMMON_GUI) {
            return;
        }
        PetUser user = event.getUser();
        List<PetType> petArray = user.getOwnedPets();
        PetType type = event.getType();
        ItemBuilder maker = ItemBuilder.fromItem(event.getItem());
        String price = String.valueOf(this.priceMap.getOrDefault((Object)type, 2000.0));
        if (this.isPetFree(type)) {
            price = this.freePrice;
        }
        if (this.hidePrice && AddonPermissions.hasPermission(this, (CommandSender)event.getUser().getPlayer(), this.typePermissions.get((Object)type))) {
            price = this.bypassPrice;
        }
        boolean contains = petArray.contains((Object)type);
        for (String line : this.lore) {
            maker.addLore(line.replace("{price}", price).replace("{purchased}", String.valueOf(this.var(contains))));
        }
        event.setItem(maker.build());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onSelect(PetSelectTypeEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (AddonPermissions.hasPermission(this, (CommandSender)event.getUser().getPlayer(), this.typePermissions.get((Object)event.getPetType()))) {
            return;
        }
        double price = this.priceMap.getOrDefault((Object)event.getPetType(), 2000.0);
        if (price <= 0.0) {
            return;
        }
        PetUser user = event.getUser();
        if (user.getOwnedPets().contains((Object)event.getPetType())) {
            return;
        }
        this.fetchBalance(user.getPlayer().getUniqueId(), bal -> {
            if (bal < price) {
                event.setCancelled(true);
                user.getPlayer().sendMessage(Colorize.translateBungeeHex(this.insufficientFunds.replace("{price}", String.valueOf(price)).replace("{type}", event.getPetType().getName()).replace("{prefix}", this.prefix)));
                return;
            }
            if (this.payPerUse) {
                this.withdraw(user.getPlayer().getUniqueId(), price);
                user.getPlayer().sendMessage(Colorize.translateBungeeHex(this.paid.replace("{price}", String.valueOf(price)).replace("{type}", event.getPetType().getName()).replace("{prefix}", this.prefix)));
                return;
            }
            user.addOwnedPet(event.getPetType());
            this.withdraw(user.getPlayer().getUniqueId(), price);
            user.getPlayer().sendMessage(Colorize.translateBungeeHex(this.successfulPayment.replace("{price}", String.valueOf(price)).replace("{type}", event.getPetType().getName()).replace("{prefix}", this.prefix)));
            user.updateSelectionMenu();
        });
    }
}

