/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.addon;

import java.io.File;
import org.bukkit.Material;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import simplepets.brainsynder.addon.AddonConfig;
import simplepets.brainsynder.addon.AddonLocalData;
import simplepets.brainsynder.api.Namespace;
import simplepets.brainsynder.libs.bslib.item.ItemBuilder;
import simplepets.brainsynder.libs.bslib.utils.AdvString;
import simplepets.brainsynder.libs.bslib.utils.Colorize;

public abstract class PetModule
implements Listener {
    private boolean loaded = false;
    private boolean enabled = false;
    private boolean update = false;
    private File addonFolder = null;
    private AddonLocalData localData;

    public void loadDefaults(AddonConfig config) {
    }

    public abstract void init();

    public void cleanup() {
    }

    public boolean shouldEnable() {
        return true;
    }

    public File getAddonFolder() {
        return this.addonFolder;
    }

    public Namespace getNamespace() {
        if (this.getClass().isAnnotationPresent(Namespace.class)) {
            return this.getClass().getAnnotation(Namespace.class);
        }
        throw new NullPointerException(this.getClass().getSimpleName() + " is missing @Namespace annotation for the module");
    }

    public ItemStack getAddonIcon() {
        StringBuilder authors = new StringBuilder();
        this.localData.getAuthors().forEach(s -> authors.append((String)s).append(", "));
        return new ItemBuilder(Material.PLAYER_HEAD).setTexture("http://textures.minecraft.net/texture/" + (this.enabled ? "78d58a7651fedae4c03efebc226c03fd791eb74a132babb974e8d838ac6882" : "2da1508d47ed73b5c515e3b93928b728e4bc6278569a79b3723ab6972ce05357")).withName(String.valueOf(Colorize.fetchColor("e1eb5b")) + this.getNamespace().namespace() + " Module").withLore(this.localData.getDescription()).addLore("&r ", "&7Author: &e" + AdvString.replaceLast(", ", "", authors.toString())).addLore("&7Addon: &e" + this.localData.getName() + " (v" + this.localData.getVersion() + ")").build();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean hasUpdate() {
        return this.update;
    }

    public AddonLocalData getLocalData() {
        return this.localData;
    }

    public void setAddonFolder(File addonFolder) {
        this.addonFolder = addonFolder;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public void setHasUpdate(boolean update) {
        this.update = update;
    }

    public void setLocalData(AddonLocalData localData) {
        this.localData = localData;
    }
}

