/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.addon;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class AddonCloudData {
    private final String id;
    private final String name;
    private final String author;
    private final String version;
    private final String downloadURL;
    private final String lastUpdated;
    private final int downloadCount;
    private final List<String> description = Lists.newArrayList();

    public AddonCloudData(String id, String name, String description, String author, String version, String downloadURL, String lastUpdated, int downloadCount) {
        this.id = id;
        this.name = name;
        this.author = author;
        this.version = version;
        this.downloadURL = downloadURL;
        this.lastUpdated = lastUpdated;
        this.downloadCount = downloadCount;
        Collections.addAll(this.description, this.splitString(description, 6).split("\n"));
    }

    private String splitString(String text, int wordsPerLine) {
        StringBuilder newText = new StringBuilder();
        StringTokenizer wordTokenizer = new StringTokenizer(text);
        long wordCount = 1L;
        while (wordTokenizer.hasMoreTokens()) {
            newText.append(wordTokenizer.nextToken());
            if (!wordTokenizer.hasMoreTokens()) continue;
            if (wordCount++ % (long)wordsPerLine == 0L) {
                newText.append("\n");
                continue;
            }
            newText.append(" ");
        }
        return newText.toString();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getVersion() {
        return this.version;
    }

    public List<String> getDescription() {
        return this.description;
    }

    public String getDownloadURL() {
        return this.downloadURL;
    }

    public String getLastUpdated() {
        return this.lastUpdated;
    }

    public int getDownloadCount() {
        return this.downloadCount;
    }
}

