/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import simplepets.brainsynder.addon.AddonLocalData;
import simplepets.brainsynder.api.ISpawnUtil;
import simplepets.brainsynder.api.inventory.handler.GUIHandler;
import simplepets.brainsynder.api.inventory.handler.ItemHandler;
import simplepets.brainsynder.api.pet.PetConfigManager;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.plugin.IPetsPlugin;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.api.plugin.config.ConfigOption;
import simplepets.brainsynder.api.plugin.utils.IPetUtilities;
import simplepets.brainsynder.api.user.UserManagement;
import simplepets.brainsynder.commands.PetsCommand;
import simplepets.brainsynder.commands.list.DebugCommand;
import simplepets.brainsynder.debug.DebugBuilder;
import simplepets.brainsynder.debug.DebugLevel;
import simplepets.brainsynder.debug.DebugLogger;
import simplepets.brainsynder.files.Config;
import simplepets.brainsynder.files.MessageFile;
import simplepets.brainsynder.impl.PetConfiguration;
import simplepets.brainsynder.impl.PetOwner;
import simplepets.brainsynder.impl.PetUtility;
import simplepets.brainsynder.libs.bslib.ServerVersion;
import simplepets.brainsynder.libs.bslib.commands.CommandRegistry;
import simplepets.brainsynder.libs.bslib.json.WriterConfig;
import simplepets.brainsynder.libs.bslib.reflection.Reflection;
import simplepets.brainsynder.libs.bslib.utils.AdvString;
import simplepets.brainsynder.libs.bslib.utils.Utilities;
import simplepets.brainsynder.libs.bstats.bukkit.Metrics;
import simplepets.brainsynder.libs.bstats.charts.AdvancedPie;
import simplepets.brainsynder.libs.bstats.charts.DrilldownPie;
import simplepets.brainsynder.libs.bstats.charts.SimplePie;
import simplepets.brainsynder.libs.paperlib.PaperLib;
import simplepets.brainsynder.libs.updatechecker.UpdateChecker;
import simplepets.brainsynder.listeners.AddonGUIListener;
import simplepets.brainsynder.listeners.BrokenVersionListener;
import simplepets.brainsynder.listeners.ChunkUnloadListener;
import simplepets.brainsynder.listeners.DamageListener;
import simplepets.brainsynder.listeners.DataGUIListener;
import simplepets.brainsynder.listeners.InteractListener;
import simplepets.brainsynder.listeners.JoinLeaveListeners;
import simplepets.brainsynder.listeners.LocationChangeListener;
import simplepets.brainsynder.listeners.PetEventListener;
import simplepets.brainsynder.listeners.PetSelectorGUIListener;
import simplepets.brainsynder.listeners.PetSpawnListener;
import simplepets.brainsynder.listeners.SavesGUIListener;
import simplepets.brainsynder.listeners.SelectionGUIListener;
import simplepets.brainsynder.listeners.breaking.DismountListener;
import simplepets.brainsynder.managers.AddonManager;
import simplepets.brainsynder.managers.InventoryManager;
import simplepets.brainsynder.managers.ItemManager;
import simplepets.brainsynder.managers.ParticleManager;
import simplepets.brainsynder.managers.RenameManager;
import simplepets.brainsynder.managers.UserManager;
import simplepets.brainsynder.sql.SQLData;
import simplepets.brainsynder.sql.SQLHandler;
import simplepets.brainsynder.sql.handlers.MySQLHandler;
import simplepets.brainsynder.sql.handlers.SQLiteHandler;
import simplepets.brainsynder.utils.JavaVersion;
import simplepets.brainsynder.utils.Premium;
import simplepets.brainsynder.utils.VersionFields;
import simplepets.brainsynder.utils.debug.Debug;

public class PetCore
extends JavaPlugin
implements IPetsPlugin {
    public static ServerInformation SERVER_INFORMATION;
    private final List<String> supportedVersions = new ArrayList<String>();
    private static PetCore instance;
    private File itemFolder;
    private boolean reloaded = false;
    private boolean fullyStarted = false;
    private boolean isStarting = false;
    private Config configuration;
    private ISpawnUtil SPAWN_UTIL;
    private UserManager USER_MANAGER;
    private PetConfiguration PET_CONFIG;
    private RenameManager renameManager;
    private ItemManager itemManager;
    private InventoryManager inventoryManager;
    private ParticleManager particleManager;
    private AddonManager addonManager;
    private Class<?> spawnutilClass = null;
    private Debug debug;
    private IPetUtilities petUtilities;
    private SQLHandler sqlHandler;
    public final Executor sync = task -> Bukkit.getScheduler().runTask((Plugin)this, task);
    public final Executor async = task -> Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, task);

    public void onEnable() {
        TimeUnit unit;
        instance = this;
        SimplePets.setPLUGIN(this);
        this.isStarting = true;
        this.debug = new Debug(this);
        SERVER_INFORMATION = new ServerInformation();
        if (ServerVersion.isEqualNew(ServerVersion.v1_21_11)) {
            SimplePets.getDebugLogger().debug(DebugBuilder.build().setLevel(DebugLevel.WARNING).setBroadcast(true).setMessages(" *** This version is still under development any issues found please report", " *** On the Github: https://tiny.bsdevelopment.org/pet-issues"));
        }
        if (!this.checkJavaVersion()) {
            this.setEnabled(false);
            this.isStarting = false;
            return;
        }
        if (!this.fetchSupportedVersions()) {
            Bukkit.getPluginManager().registerEvents((Listener)new BrokenVersionListener(), (Plugin)this);
            this.debug.debug(DebugBuilder.build(this.getClass()).setLevel(DebugLevel.CRITICAL).setBroadcast(true).setMessages("OH NO! We could not find any support for your servers version " + ServerVersion.getVersion().name().replace("v", "").replace("_", "."), "Please check the Jenkins for an updated build: https://ci.bsdevelopment.org/job/SimplePets_v5/", "Check if there is a SimplePets-" + ServerVersion.getVersion().name().replace("v", "").replace("_", ".") + ".jar (IF AVAILABLE)", "Current SimplePets jar name: " + this.getJarName()));
            this.isStarting = false;
            return;
        }
        this.debug.debug(DebugLevel.HIDDEN, "Setting API instance");
        this.petUtilities = new PetUtility();
        this.itemFolder = new File(String.valueOf(this.getDataFolder()) + File.separator + "Items");
        MessageFile.init(this.getDataFolder());
        this.debug.debug(DebugLevel.HIDDEN, "Initializing Config file");
        this.configuration = new Config(this);
        this.configuration.initValues();
        this.reloaded = ConfigOption.INSTANCE.RELOAD_DETECT.getValue();
        ConfigOption.INSTANCE.RELOAD_DETECT.setValue(false, true);
        this.debug.debug(DebugLevel.HIDDEN, "Plugin reloaded: " + this.reloaded);
        if (ConfigOption.INSTANCE.LEGACY_PATHFINDING_ENABLED.getValue().booleanValue()) {
            SimplePets.getDebugLogger().debug(DebugBuilder.build().setLevel(DebugLevel.WARNING).setBroadcast(true).setMessages(" ", " *** NOTICE: Legacy Pathfinding is currently enabled", " *** No support will be given if this is enabled and an issue occurs pertaining to it", " "));
        }
        this.reloadSpawner();
        this.handleManagers();
        this.debug.debug(DebugLevel.HIDDEN, "Initializing SQL Handler");
        this.sqlHandler = SQLData.USE_SQLITE ? new SQLiteHandler() : new MySQLHandler();
        this.sqlHandler.initiateDatabase();
        try {
            this.debug.debug(DebugLevel.HIDDEN, "Registering commands");
            new CommandRegistry<PetCore>(this).register(new PetsCommand(this));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.handleListeners();
        this.handleUpdateUtils();
        String timeunit = ConfigOption.INSTANCE.ADDON_LOAD_UNIT.getValue();
        try {
            unit = TimeUnit.valueOf(timeunit);
        }
        catch (Exception e) {
            unit = TimeUnit.SECONDS;
            this.debug.debug(DebugLevel.ERROR, "Could not find unit for '" + timeunit + "'");
        }
        this.debug.debug(SimplePets.ADDON, "Loading addons in '" + String.valueOf(ConfigOption.INSTANCE.ADDON_LOAD_TIME.getValue()) + " " + timeunit + "'");
        new BukkitRunnable(){

            public void run() {
                PetCore.this.addonManager = new AddonManager(PetCore.this);
                PetCore.this.addonManager.initialize();
                PetCore.this.addonManager.checkAddons();
                PetCore.this.handleMetrics();
            }
        }.runTaskLater((Plugin)this, Utilities.toUnit(ConfigOption.INSTANCE.ADDON_LOAD_TIME.getValue().intValue(), unit));
        this.checkWorldGuard(value -> {
            if (value.booleanValue()) {
                this.debug.debug(DebugBuilder.build(this.getClass()).setLevel(DebugLevel.CRITICAL).setMessages("Your server is using WorldGuard and the 'mobs.block-plugin-spawning' is set to true", "This causes issues with the plugin not being able to spawn pets", "Please set this to 'false' in the WorldGuard config so pets can spawn"));
            }
        });
        this.fullyStarted = true;
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                PetCore.this.debug.debug(DebugLevel.HIDDEN, "Respawning pets for players (if there are any)");
                UserManagement userManager = SimplePets.getUserManager();
                Bukkit.getOnlinePlayers().forEach(userManager::getPetUser);
            }
        }.runTaskLater((Plugin)this, 20L);
    }

    public void onDisable() {
        this.isStarting = false;
        this.supportedVersions.clear();
        if (this.petUtilities == null) {
            return;
        }
        SimplePets.getDebugLogger().debug(DebugLevel.NORMAL, "Saving player pets (if there are any)", false);
        if (this.USER_MANAGER != null) {
            this.USER_MANAGER.getAllUsers().forEach(user -> {
                if (user.getPlayer() != null) {
                    ((PetOwner)user).markForRespawn();
                }
            });
        }
        DebugCommand.fetchDebug(json -> {
            json.set("reloaded", this.wasPluginReloaded());
            DebugCommand.log(this.getDataFolder(), "debug.json", json.toString(WriterConfig.PRETTY_PRINT));
            SimplePets.getDebugLogger().debug(DebugLevel.DEBUG, "Generated debug information while disabling", false);
        }, true);
        this.petUtilities = null;
        this.USER_MANAGER = null;
        this.PET_CONFIG = null;
        this.SPAWN_UTIL = null;
        if (this.wasPluginReloaded()) {
            SimplePets.getDebugLogger().debug(DebugBuilder.build().setMessages("------------------------------------", "    The plugin has detected a reload", "If you encounter ANY strange issues then this will be the cause.", "To fix those, Simply RESTART your server", "------------------------------------").setSync(false).setBroadcast(true).setLevel(DebugLevel.CRITICAL));
            ConfigOption.INSTANCE.RELOAD_DETECT.setValue(true, true);
        }
        this.configuration = null;
        if (this.addonManager != null) {
            this.addonManager.cleanup();
        }
        this.addonManager = null;
        this.debug = null;
        this.fullyStarted = false;
    }

    private boolean checkJavaVersion() {
        if (ServerVersion.isEqualNew(ServerVersion.v1_20_5) && !JavaVersion.current().isCompatibleWith(JavaVersion.VERSION_21)) {
            this.debug.debug(DebugBuilder.build(this.getClass()).setLevel(DebugLevel.CRITICAL).setBroadcast(true).setMessages("Your server does not support Java 21!", "Java 21 is required for servers 1.20.5 -> 1.21.11 (Mojang Requirement)", "Disabling the plugin..."));
            return false;
        }
        return true;
    }

    private void handleUpdateUtils() {
        if (!ConfigOption.INSTANCE.UPDATE_CHECK_ENABLED.getValue().booleanValue()) {
            return;
        }
        int time = ConfigOption.INSTANCE.UPDATE_CHECK_TIME.getValue();
        String timeunit = ConfigOption.INSTANCE.UPDATE_CHECK_UNIT.getValue();
        try {
            TimeUnit unit = TimeUnit.valueOf(timeunit);
        }
        catch (Exception e) {
            TimeUnit unit = TimeUnit.HOURS;
            this.debug.debug(DebugLevel.ERROR, "Could not find unit for '" + timeunit + "'");
        }
        this.debug.debug(DebugLevel.HIDDEN, "Initializing update checker");
        if (Premium.getDownloadType().fromDownloadSite()) {
            try {
                int resourceID = Integer.parseInt(Premium.RESOURCE_ID);
                new UpdateChecker(this, Premium.getDownloadType().toSource(), Premium.RESOURCE_ID).setChangelogLink(resourceID).setDownloadLink(resourceID).setColoredConsoleOutput(true).setNotifyOpsOnJoin(true).setNotifyByPermissionOnJoin("pet.update").suppressUpToDateMessage(true).checkEveryXHours(12.0).checkNow();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean wasReloaded() {
        return this.reloaded;
    }

    private boolean wasPluginReloaded() {
        try {
            Method isStopping = Bukkit.class.getDeclaredMethod("isStopping", new Class[0]);
            return (Boolean)Reflection.invoke(isStopping, null, new Object[0]) == false;
        }
        catch (Exception e) {
            String fieldName = VersionFields.fromServerVersion((ServerVersion)ServerVersion.getVersion()).getServerRunningField();
            Class<?> nmsClass = Reflection.getNmsClass("MinecraftServer", "server");
            try {
                Object server = Reflection.getMethod(nmsClass, "getServer", new Class[0]).invoke(null, new Object[0]);
                Field field = nmsClass.getDeclaredField(fieldName);
                Reflection.setFieldAccessible(field);
                return (Boolean)field.get(server);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
    }

    private void handleManagers() {
        this.debug.debug(DebugLevel.HIDDEN, "Initializing plugin managers");
        this.particleManager = new ParticleManager(this);
        this.renameManager = new RenameManager(this);
        this.PET_CONFIG = new PetConfiguration(this);
        this.USER_MANAGER = new UserManager(this);
        this.itemManager = new ItemManager();
        this.itemManager.initiate();
        this.inventoryManager = new InventoryManager();
        this.inventoryManager.initiate();
    }

    private void handleListeners() {
        this.debug.debug(DebugLevel.HIDDEN, "Registering plugin listeners");
        PluginManager manager = Bukkit.getPluginManager();
        if (ConfigOption.INSTANCE.PET_TOGGLES_SPAWN_BYPASS.getValue().booleanValue()) {
            manager.registerEvents((Listener)new PetSpawnListener(), (Plugin)this);
        }
        manager.registerEvents((Listener)new AddonGUIListener(), (Plugin)this);
        manager.registerEvents((Listener)new ChunkUnloadListener(), (Plugin)this);
        manager.registerEvents((Listener)new DamageListener(), (Plugin)this);
        manager.registerEvents((Listener)new DataGUIListener(), (Plugin)this);
        manager.registerEvents((Listener)new InteractListener(), (Plugin)this);
        manager.registerEvents((Listener)new JoinLeaveListeners(), (Plugin)this);
        manager.registerEvents((Listener)new PetEventListener(), (Plugin)this);
        manager.registerEvents((Listener)new PetSelectorGUIListener(), (Plugin)this);
        manager.registerEvents((Listener)new SavesGUIListener(), (Plugin)this);
        manager.registerEvents((Listener)new SelectionGUIListener(), (Plugin)this);
        manager.registerEvents((Listener)new LocationChangeListener(), (Plugin)this);
        manager.registerEvents((Listener)new DismountListener(), (Plugin)this);
    }

    @Override
    public ISpawnUtil getSpawnUtil() {
        return this.SPAWN_UTIL;
    }

    @Override
    public PetConfigManager getPetConfigManager() {
        return this.PET_CONFIG;
    }

    public void reloadPetConfigManager() {
        this.PET_CONFIG = new PetConfiguration(this);
    }

    @Override
    public ItemHandler getItemHandler() {
        return this.itemManager;
    }

    @Override
    public GUIHandler getGUIHandler() {
        return this.inventoryManager;
    }

    @Override
    public UserManagement getUserManager() {
        return this.USER_MANAGER;
    }

    public SQLHandler getSqlHandler() {
        return this.sqlHandler;
    }

    public double getJavaVersion() {
        try {
            String version = System.getProperty("java.version");
            if (version.contains(".")) {
                int pos = version.indexOf(46);
                pos = version.indexOf(46, pos + 1);
                version = version.substring(0, pos);
            }
            return Double.parseDouble(version);
        }
        catch (Throwable t) {
            return 0.0;
        }
    }

    public void checkWorldGuard(Consumer<Boolean> consumer) {
        Plugin worldguard = Bukkit.getPluginManager().getPlugin("WorldGuard");
        if (worldguard == null) {
            return;
        }
        FileConfiguration config = worldguard.getConfig();
        consumer.accept(config.getBoolean("mobs.block-plugin-spawning", false));
    }

    @Override
    public Config getConfiguration() {
        return this.configuration;
    }

    @Override
    public IPetUtilities getPetUtilities() {
        return this.petUtilities;
    }

    private Map<String, Integer> getActivePets() {
        HashMap<String, Integer> users = new HashMap<String, Integer>();
        SimplePets.getUserManager().getAllUsers().forEach(user -> user.getPetEntities().forEach(entityPet -> {
            PetType type = entityPet.getPetType();
            String name = type.getName();
            if (!users.containsKey(name)) {
                users.put(name, 1);
            } else {
                users.put(name, (Integer)users.get(name) + 1);
            }
        }));
        return users;
    }

    private Map<String, Integer> getSpawnedPetCounts() {
        HashMap<String, Integer> users = new HashMap<String, Integer>();
        this.getSpawnUtil().getSpawnCount().forEach((petType, integer) -> users.put(petType.getName(), (Integer)integer));
        return users;
    }

    public AddonManager getAddonManager() {
        return this.addonManager;
    }

    private void handleMetrics() {
        SimplePets.getDebugLogger().debug(DebugLevel.HIDDEN, "Loading Metrics");
        Metrics metrics = new Metrics(this, 244);
        metrics.addCustomChart(new SimplePie("server_type", () -> String.valueOf(PetCore.SERVER_INFORMATION.serverType)));
        metrics.addCustomChart(new SimplePie("stupid_config_option_for_gui_command", () -> String.valueOf(ConfigOption.INSTANCE.SIMPLER_GUI.getValue())));
        metrics.addCustomChart(new AdvancedPie("spawned_pet_counter", this::getSpawnedPetCounts));
        metrics.addCustomChart(new AdvancedPie("active_pets", this::getActivePets));
        metrics.addCustomChart(new DrilldownPie("loaded_addons", () -> {
            HashMap map = new HashMap();
            HashMap<String, Integer> entry = new HashMap<String, Integer>();
            entry.put("addon", 1);
            this.addonManager.getLoadedAddons().forEach(addon -> {
                if (this.addonManager.getRegisteredAddons().contains(addon.getNamespace().namespace())) {
                    map.put(addon.getNamespace().namespace(), entry);
                }
            });
            return map;
        }));
        metrics.addCustomChart(new DrilldownPie("download_type", () -> {
            HashMap map = new HashMap();
            HashMap<String, Integer> entry = new HashMap<String, Integer>();
            entry.put("download_type", 1);
            map.put(Premium.getDownloadType().name(), entry);
            return map;
        }));
        metrics.addCustomChart(new AdvancedPie("addon_tracker", () -> {
            HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
            int custom = 0;
            int registered = 0;
            for (AddonLocalData localData : this.addonManager.getLocalDataMap().keySet()) {
                if (this.addonManager.getRegisteredAddons().contains(localData.getName())) {
                    ++registered;
                    continue;
                }
                ++custom;
            }
            valueMap.put("Registered Addons", registered);
            valueMap.put("Custom Addons", custom);
            return valueMap;
        }));
    }

    private void reloadSpawner() {
        ServerVersion version = (ServerVersion)ServerVersion.getVersion();
        try {
            if (this.spawnutilClass == null) {
                return;
            }
            if (ISpawnUtil.class.isAssignableFrom(this.spawnutilClass)) {
                this.SPAWN_UTIL = (ISpawnUtil)this.spawnutilClass.getConstructor(ClassLoader.class).newInstance(this.getClassLoader());
                this.debug.debug(DebugLevel.HIDDEN, "Successfully Linked to " + version.name() + " SpawnUtil Class");
            }
        }
        catch (Exception e) {
            this.debug.debug(DebugBuilder.build(this.getClass()).setLevel(DebugLevel.CRITICAL).setBroadcast(true).setMessages("OH NO! We could not find any support for your servers version " + ServerVersion.getVersion().name().replace("v", "").replace("_", "."), "Please check the Jenkins for an updated build: https://ci.bsdevelopment.org/job/SimplePets_v5/", "Check if there is a SimplePets-" + ServerVersion.getVersion().name().replace("v", "").replace("_", ".") + ".jar (IF AVAILABLE)", " ", "Error: " + e.getMessage()));
        }
    }

    public RenameManager getRenameManager() {
        return this.renameManager;
    }

    public File getItemFolder() {
        return this.itemFolder;
    }

    @Override
    public ParticleManager getParticleHandler() {
        return this.particleManager;
    }

    @Override
    public DebugLogger getDebugLogger() {
        return this.debug;
    }

    public static PetCore getInstance() {
        return instance;
    }

    private boolean fetchSupportedVersions() {
        if (!this.supportedVersions.isEmpty()) {
            return this.supportedVersions.contains(ServerVersion.getVersion().name());
        }
        this.supportedVersions.clear();
        String current = ServerVersion.getVersion().name();
        boolean supported = false;
        String packageName = "simplepets.brainsynder.versions.<VER>.SpawnerUtil";
        for (ServerVersion version : ServerVersion.values()) {
            if (version.name().equals(current) && !supported) {
                supported = true;
            }
            try {
                Class<?> clazz = Class.forName(packageName.replace("<VER>", version.name()), false, this.getClassLoader());
                if (clazz == null) continue;
                if (version.name().equals(current)) {
                    this.spawnutilClass = clazz;
                }
                this.supportedVersions.add(version.name());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!supported) {
            try {
                Class<?> clazz = Class.forName(packageName.replace("<VER>", current), false, this.getClassLoader());
                if (clazz != null) {
                    this.spawnutilClass = clazz;
                    this.supportedVersions.add(current);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this.supportedVersions.contains(current)) {
            return false;
        }
        if (!this.supportedVersions.isEmpty()) {
            this.debug.debug("Found support for version(s): " + this.supportedVersions.toString().replace("v", "").replace("_", "."));
            this.debug.debug("Targeting version: " + ServerVersion.getVersion().name().replace("v", "").replace("_", "."));
        }
        return supported;
    }

    @Override
    public boolean hasFullyStarted() {
        return this.fullyStarted;
    }

    @Override
    public boolean isStarting() {
        return this.isStarting;
    }

    public String getJarName() {
        try {
            Method getFileMethod = JavaPlugin.class.getDeclaredMethod("getFile", new Class[0]);
            getFileMethod.setAccessible(true);
            File file = (File)getFileMethod.invoke((Object)this, new Object[0]);
            return file.getName();
        }
        catch (Exception e) {
            return "Error: " + e.getMessage();
        }
    }

    public static class ServerInformation {
        private final String java;
        private final String rawVersion;
        private final String bukkitVersion;
        private final String minecraftVersion;
        private final boolean paper;
        private String serverType;
        private String buildVersion;
        private boolean mojangMapped;

        public ServerInformation() {
            block8: {
                this.serverType = "Unknown";
                this.buildVersion = "Unknown";
                this.mojangMapped = false;
                this.paper = PaperLib.isPaper();
                String java = System.getProperty("java.version");
                int pos = java.indexOf(46);
                pos = java.indexOf(46, pos + 1);
                this.java = pos != -1 ? java.substring(0, pos).replace(".0", "") : java;
                this.rawVersion = Bukkit.getVersion();
                this.bukkitVersion = Bukkit.getBukkitVersion();
                if (this.paper) {
                    try {
                        Class<?> buildInfoClass = Class.forName("io.papermc.paper.ServerBuildInfo");
                        Method buildInfoMethod = Reflection.getMethod(buildInfoClass, "buildInfo", new Class[0]);
                        Object instance = Reflection.invoke(buildInfoMethod, null, new Object[0]);
                        this.serverType = (String)Reflection.invoke(Reflection.getMethod(buildInfoClass, "brandName", new Class[0]), instance, new Object[0]);
                        this.buildVersion = AdvString.between("-", "-", this.rawVersion);
                    }
                    catch (Exception e) {
                        Pattern pattern = Pattern.compile("git-(\\w+)-(\\w+) \\(MC: (\\w.+)\\)");
                        Matcher matcher = pattern.matcher(this.rawVersion);
                        if (matcher.find()) {
                            this.serverType = matcher.group(1);
                            this.buildVersion = matcher.group(2);
                            break block8;
                        }
                        this.serverType = this.rawVersion;
                        this.buildVersion = "Unknown";
                    }
                } else {
                    this.serverType = "Spigot";
                    this.buildVersion = AdvString.before("-", this.rawVersion);
                }
            }
            this.minecraftVersion = AdvString.between("(MC: ", ")", this.rawVersion);
            try {
                Class<?> livingClass = Class.forName("net,minecraft,core,registries,BuiltInRegistries".replace(",", "."), false, PetCore.getInstance().getClassLoader());
                Field field = livingClass.getDeclaredField("ENTITY_TYPE");
                if (field != null) {
                    this.mojangMapped = true;
                    SimplePets.getDebugLogger().debug(DebugLevel.DEBUG, "Plugin is on a server that is using Mojang Mappings");
                }
            }
            catch (Exception e) {
                SimplePets.getDebugLogger().debug(DebugLevel.DEBUG, "Plugin is on a server that is using Obfuscated Mappings");
            }
        }

        public String getJava() {
            return this.java;
        }

        public String getBuildVersion() {
            return this.buildVersion;
        }

        public String getBukkitVersion() {
            return this.bukkitVersion;
        }

        public String getMinecraftVersion() {
            return this.minecraftVersion;
        }

        public String getRawVersion() {
            return this.rawVersion;
        }

        public String getServerType() {
            return this.serverType;
        }

        public boolean isMojangMapped() {
            return this.mojangMapped;
        }

        public boolean isPaper() {
            return this.paper;
        }
    }
}

