/*
 * Decompiled with CFR 0.152.
 */
package xyz.atrius.waystones.service;

import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Bed;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.ShulkerBox;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Chest;
import org.bukkit.block.data.type.ChiseledBookshelf;
import org.bukkit.block.data.type.Door;
import org.bukkit.block.data.type.Gate;
import org.bukkit.block.data.type.HangingSign;
import org.bukkit.block.data.type.Shelf;
import org.bukkit.block.data.type.Sign;
import org.bukkit.block.data.type.Switch;
import org.bukkit.block.data.type.TrapDoor;
import org.bukkit.block.data.type.WallHangingSign;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.annotation.Single;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.atrius.Metadata;
import xyz.atrius.collections.CollectionsKt;
import xyz.atrius.collections.SetsKt;
import xyz.atrius.jvm.internal.DefaultConstructorMarker;
import xyz.atrius.jvm.internal.Intrinsics;
import xyz.atrius.waystones.service.WaystoneService;

@Single
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u001a\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u001a\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u001a\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lxyz/atrius/waystones/service/WarpValidationService;", "", "waystoneService", "Lxyz/atrius/waystones/service/WaystoneService;", "<init>", "(Lxyz/atrius/waystones/service/WaystoneService;)V", "guiBlocks", "", "Lorg/bukkit/Material;", "interactableBlocks", "validateCanWarp", "", "player", "Lorg/bukkit/entity/Player;", "block", "Lorg/bukkit/block/Block;", "validateBlockData", "data", "Lorg/bukkit/block/data/BlockData;", "validateBlockState", "state", "Lorg/bukkit/block/BlockState;", "validateBlockType", "logValidationFailure", "", "message", "", "Companion", "waystones"})
public final class WarpValidationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WaystoneService waystoneService;
    @NotNull
    private final Set<Material> guiBlocks;
    @NotNull
    private final Set<Material> interactableBlocks;
    private static final Logger logger = LoggerFactory.getLogger(WarpValidationService.class);

    public WarpValidationService(@NotNull WaystoneService waystoneService) {
        Intrinsics.checkNotNullParameter(waystoneService, "waystoneService");
        this.waystoneService = waystoneService;
        Material[] materialArray = new Material[]{Material.ANVIL, Material.BARREL, Material.BEACON, Material.CHIPPED_ANVIL, Material.CRAFTING_TABLE, Material.BLAST_FURNACE, Material.BREWING_STAND, Material.CARTOGRAPHY_TABLE, Material.COMMAND_BLOCK, Material.CHAIN_COMMAND_BLOCK, Material.REPEATING_COMMAND_BLOCK, Material.CRAFTER, Material.CRAFTING_TABLE, Material.DAMAGED_ANVIL, Material.DISPENSER, Material.DROPPER, Material.ENCHANTING_TABLE, Material.ENDER_CHEST, Material.FURNACE, Material.GRINDSTONE, Material.HOPPER, Material.LECTERN, Material.LOOM, Material.SMITHING_TABLE, Material.SMOKER, Material.STONECUTTER, Material.STRUCTURE_BLOCK, Material.TEST_BLOCK, Material.TEST_INSTANCE_BLOCK, Material.TRAPPED_CHEST};
        this.guiBlocks = SetsKt.setOf(materialArray);
        materialArray = new Material[]{Material.BELL, Material.COMPARATOR, Material.DAYLIGHT_DETECTOR, Material.DECORATED_POT, Material.JUKEBOX, Material.LEVER, Material.NOTE_BLOCK, Material.REPEATER};
        this.interactableBlocks = SetsKt.setOf(materialArray);
    }

    public final boolean validateCanWarp(@NotNull Player player, @Nullable Block block) {
        Intrinsics.checkNotNullParameter(player, "player");
        if (player.isGliding()) {
            this.logValidationFailure(player, "Player is gliding with elytra");
            return false;
        }
        if (this.waystoneService.isWaystone(block)) {
            return false;
        }
        Block block2 = block;
        if (!this.validateBlockState(player, (BlockState)(block2 != null ? block2.getState() : null))) {
            return false;
        }
        Block block3 = block;
        if (!this.validateBlockData(player, (BlockData)(block3 != null ? block3.getBlockData() : null))) {
            return false;
        }
        if (!this.validateBlockType(player, block)) {
            return false;
        }
        logger.debug("Warp validation succeeded for " + player.getName());
        return true;
    }

    private final boolean validateBlockData(Player player, BlockData data) {
        boolean bl;
        BlockData blockData = data;
        if (blockData instanceof Sign || blockData instanceof HangingSign || blockData instanceof WallSign || blockData instanceof WallHangingSign) {
            this.logValidationFailure(player, "Player is interacting with a sign");
            bl = false;
        } else if (blockData instanceof Door || blockData instanceof TrapDoor || blockData instanceof Gate) {
            this.logValidationFailure(player, "Player is interacting with a door, trapdoor, or gate");
            bl = false;
        } else if (blockData instanceof Chest) {
            this.logValidationFailure(player, "Player is interacting with a chest");
            bl = false;
        } else if (blockData instanceof Switch) {
            this.logValidationFailure(player, "Player is interacting with a switch or button");
            bl = false;
        } else if (blockData instanceof Shelf) {
            this.logValidationFailure(player, "Player is interacting with a shelf");
            bl = false;
        } else if (blockData instanceof ChiseledBookshelf) {
            this.logValidationFailure(player, "Player is interacting with a chiseled bookshelf");
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    private final boolean validateBlockState(Player player, BlockState state) {
        boolean bl;
        BlockState blockState = state;
        if (blockState instanceof Bed) {
            this.logValidationFailure(player, "Player is on a bed");
            bl = false;
        } else if (blockState instanceof ShulkerBox) {
            this.logValidationFailure(player, "Player is viewing the contents of a shulker box");
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    private final boolean validateBlockType(Player player, Block block) {
        boolean bl;
        Material material;
        Block block2 = block;
        Object object = material = block2 != null ? block2.getType() : null;
        if (CollectionsKt.contains((Iterable)this.guiBlocks, material)) {
            Block block3 = block;
            this.logValidationFailure(player, "Player is viewing GUI of " + (Material)(block3 != null ? block3.getType() : null));
            bl = false;
        } else if (CollectionsKt.contains((Iterable)this.interactableBlocks, material)) {
            Block block4 = block;
            this.logValidationFailure(player, "Player is interacting with " + (Material)(block4 != null ? block4.getType() : null));
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    private final void logValidationFailure(Player player, String message) {
        logger.debug("Warp validation failed for " + player.getName() + ": " + message);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lxyz/atrius/waystones/service/WarpValidationService$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "xyz.atrius.jvm.PlatformType", "waystones"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

