/*
 * Decompiled with CFR 0.152.
 */
package xyz.atrius.waystones.repository;

import java.sql.ResultSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.bukkit.Location;
import org.bukkit.World;
import org.flywaydb.core.internal.jdbc.RowMapper;
import org.jetbrains.annotations.NotNull;
import org.koin.core.annotation.Single;
import xyz.atrius.Metadata;
import xyz.atrius.NoWhenBranchMatchedException;
import xyz.atrius.collections.CollectionsKt;
import xyz.atrius.jvm.functions.Function1;
import xyz.atrius.jvm.internal.Intrinsics;
import xyz.atrius.waystones.config.DatabaseProperties;
import xyz.atrius.waystones.config.SupportedDatabase;
import xyz.atrius.waystones.dao.WaystoneInfo;
import xyz.atrius.waystones.manager.DatabaseManager;
import xyz.atrius.waystones.repository.CountRowMapper;

@Single
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\"\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000e0\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\nJ\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\u0016\u001a\u00020\u0002J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\u0018\u001a\u00020\u0019J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lxyz/atrius/waystones/repository/WaystoneInfoRepository;", "Lorg/flywaydb/core/internal/jdbc/RowMapper;", "Lxyz/atrius/waystones/dao/WaystoneInfo;", "databaseManager", "Lxyz/atrius/waystones/manager/DatabaseManager;", "databaseProperties", "Lxyz/atrius/waystones/config/DatabaseProperties;", "<init>", "(Lxyz/atrius/waystones/manager/DatabaseManager;Lxyz/atrius/waystones/config/DatabaseProperties;)V", "getWaystone", "Ljava/util/concurrent/CompletableFuture;", "location", "Lorg/bukkit/Location;", "getAll", "", "limit", "", "offset", "entries", "existsByLocation", "", "save", "info", "deleteByWorld", "world", "Lorg/bukkit/World;", "deleteByLocation", "mapRow", "rs", "Ljava/sql/ResultSet;", "waystones"})
public final class WaystoneInfoRepository
implements RowMapper<WaystoneInfo> {
    @NotNull
    private final DatabaseManager databaseManager;
    @NotNull
    private final DatabaseProperties databaseProperties;

    public WaystoneInfoRepository(@NotNull DatabaseManager databaseManager, @NotNull DatabaseProperties databaseProperties) {
        Intrinsics.checkNotNullParameter(databaseManager, "databaseManager");
        Intrinsics.checkNotNullParameter(databaseProperties, "databaseProperties");
        this.databaseManager = databaseManager;
        this.databaseProperties = databaseProperties;
    }

    @NotNull
    public final CompletableFuture<WaystoneInfo> getWaystone(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "location");
        String query = "select *\nfrom waystone_info\nwhere world_uid = ?\n  and x = ?\n  and y = ?\n  and z = ?;";
        Object[] objectArray = new Object[4];
        Intrinsics.checkNotNullExpressionValue(location.getWorld().getUID(), "getUID(...)");
        objectArray[1] = location.getX();
        objectArray[2] = location.getY();
        objectArray[3] = location.getZ();
        List<Object> params = CollectionsKt.listOf(objectArray);
        return this.databaseManager.query(query, params, this);
    }

    @NotNull
    public final CompletableFuture<List<WaystoneInfo>> getAll(int limit, int offset) {
        String query = "select *\nfrom waystone_info\nlimit ? offset ?;";
        Integer[] integerArray = new Integer[]{limit, offset};
        List<Integer> params = CollectionsKt.listOf(integerArray);
        return this.databaseManager.queryAll(query, params, this);
    }

    @NotNull
    public final CompletableFuture<Integer> entries() {
        String query = "select count(*)\nfrom waystone_info;";
        CompletionStage completionStage = DatabaseManager.query$default(this.databaseManager, query, null, CountRowMapper.INSTANCE, 2, null).thenApplyAsync(arg_0 -> WaystoneInfoRepository.entries$lambda$1(WaystoneInfoRepository::entries$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue(completionStage, "thenApplyAsync(...)");
        return completionStage;
    }

    @NotNull
    public final CompletableFuture<Boolean> existsByLocation(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "location");
        String query = "select 1\nfrom waystone_info\nwhere world_uid = ?\n  and x = ?\n  and y = ?\n  and z = ?\nlimit 1;";
        Object[] objectArray = new Object[4];
        Intrinsics.checkNotNullExpressionValue(location.getWorld().getUID(), "getUID(...)");
        objectArray[1] = location.getX();
        objectArray[2] = location.getY();
        objectArray[3] = location.getZ();
        List<Object> params = CollectionsKt.listOf(objectArray);
        return this.databaseManager.queryExists(query, params);
    }

    @NotNull
    public final CompletableFuture<Integer> save(@NotNull WaystoneInfo info) {
        Intrinsics.checkNotNullParameter(info, "info");
        String query = switch (WhenMappings.$EnumSwitchMapping$0[this.databaseProperties.getType().ordinal()]) {
            case 1 -> "insert into waystone_info (world_uid, x, y, z, name)\nvalues (?, ?, ?, ?, ?)\non duplicate key update\n   name = values(name)";
            case 2 -> "insert into waystone_info (world_uid, x, y, z, name)\nvalues (?, ?, ?, ?, ?)\non conflict (world_uid, x, y, z) do update set\n   name = excluded.name";
            default -> throw new NoWhenBranchMatchedException();
        };
        Object[] objectArray = new Object[]{info.getWorldUid(), info.getX(), info.getY(), info.getZ(), info.getName()};
        List<Object> params = CollectionsKt.listOf(objectArray);
        return this.databaseManager.queryUpdate(query, params);
    }

    @NotNull
    public final CompletableFuture<Integer> deleteByWorld(@NotNull World world) {
        Intrinsics.checkNotNullParameter(world, "world");
        String query = "delete from waystone_info \nwhere world_uid = ?;";
        List<UUID> params = CollectionsKt.listOf(world.getUID());
        return this.databaseManager.queryUpdate(query, params);
    }

    @NotNull
    public final CompletableFuture<Integer> deleteByLocation(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "location");
        String query = "delete from waystone_info \nwhere world_uid = ?\n  and x = ?\n  and y = ?\n  and z = ?;";
        Object[] objectArray = new Object[4];
        Intrinsics.checkNotNullExpressionValue(location.getWorld().getUID(), "getUID(...)");
        objectArray[1] = location.getX();
        objectArray[2] = location.getY();
        objectArray[3] = location.getZ();
        List<Object> params = CollectionsKt.listOf(objectArray);
        return this.databaseManager.queryUpdate(query, params);
    }

    @NotNull
    public WaystoneInfo mapRow(@NotNull ResultSet rs) {
        Intrinsics.checkNotNullParameter(rs, "rs");
        UUID uUID = UUID.fromString(rs.getString("world_uid"));
        Intrinsics.checkNotNullExpressionValue(uUID, "fromString(...)");
        return new WaystoneInfo(uUID, rs.getInt("x"), rs.getInt("y"), rs.getInt("z"), rs.getString("name"));
    }

    private static final Integer entries$lambda$0(Integer it) {
        Integer n = it;
        return n != null ? n : 0;
    }

    private static final Integer entries$lambda$1(Function1 $tmp0, Object p0) {
        return (Integer)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SupportedDatabase.values().length];
            try {
                nArray[SupportedDatabase.MYSQL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SupportedDatabase.SQLITE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

