/*
 * Decompiled with CFR 0.152.
 */
package xyz.atrius.waystones.manager;

import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.annotation.Named;
import org.koin.core.annotation.Single;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.atrius.Metadata;
import xyz.atrius.Result;
import xyz.atrius.ResultKt;
import xyz.atrius.Unit;
import xyz.atrius.collections.CollectionsKt;
import xyz.atrius.collections.MapsKt;
import xyz.atrius.jvm.internal.DefaultConstructorMarker;
import xyz.atrius.jvm.internal.Intrinsics;
import xyz.atrius.jvm.internal.SourceDebugExtension;
import xyz.atrius.ranges.RangesKt;
import xyz.atrius.waystones.data.config.property.FallbackLocaleProperty;
import xyz.atrius.waystones.internal.KotlinPlugin;
import xyz.atrius.waystones.manager.LocalizedString;

@Single
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0002\u0018\u0019B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0001\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0001\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ.\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0016\u0010\u0013\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0014\"\u0004\u0018\u00010\u0001H\u0086\u0002\u00a2\u0006\u0002\u0010\u0015J\u0011\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0012H\u0086\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lxyz/atrius/waystones/manager/LocalizationManager;", "", "plugin", "Lxyz/atrius/waystones/internal/KotlinPlugin;", "supportedLocales", "", "Ljava/util/Locale;", "defaultPluginLocale", "fallbackLocale", "Lxyz/atrius/waystones/data/config/property/FallbackLocaleProperty;", "<init>", "(Lxyz/atrius/waystones/internal/KotlinPlugin;Ljava/util/Set;Ljava/util/Locale;Lxyz/atrius/waystones/data/config/property/FallbackLocaleProperty;)V", "configs", "", "Lxyz/atrius/waystones/manager/LocalizationManager$LocaleConfig;", "get", "Lxyz/atrius/waystones/manager/LocalizedString;", "key", "", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)Lxyz/atrius/waystones/manager/LocalizedString;", "contains", "", "LocaleConfig", "Companion", "waystones"})
@SourceDebugExtension(value={"SMAP\nLocalizationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalizationManager.kt\nxyz/atrius/waystones/manager/LocalizationManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 map.kt\narrow/core/MapKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n1285#2,2:84\n1299#2,4:86\n289#3,2:90\n291#3:93\n292#3:95\n293#3:97\n216#4:92\n217#4:96\n188#4,3:98\n1#5:94\n*S KotlinDebug\n*F\n+ 1 LocalizationManager.kt\nxyz/atrius/waystones/manager/LocalizationManager\n*L\n24#1:84,2\n24#1:86,4\n28#1:90,2\n28#1:93\n28#1:95\n28#1:97\n28#1:92\n28#1:96\n40#1:98,3\n28#1:94\n*E\n"})
public final class LocalizationManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KotlinPlugin plugin;
    @NotNull
    private final Set<Locale> supportedLocales;
    @NotNull
    private final Locale defaultPluginLocale;
    @NotNull
    private final FallbackLocaleProperty fallbackLocale;
    @NotNull
    private final Map<Locale, LocaleConfig> configs;
    private static final Logger logger = LoggerFactory.getLogger(LocalizationManager.class);

    /*
     * WARNING - void declaration
     */
    public LocalizationManager(@NotNull KotlinPlugin plugin, @Named(value="supportedLocales") @NotNull Set<Locale> supportedLocales, @Named(value="defaultPluginLocale") @NotNull Locale defaultPluginLocale, @NotNull FallbackLocaleProperty fallbackLocale) {
        void $this$associateWith$iv;
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        Intrinsics.checkNotNullParameter(supportedLocales, "supportedLocales");
        Intrinsics.checkNotNullParameter(defaultPluginLocale, "defaultPluginLocale");
        Intrinsics.checkNotNullParameter(fallbackLocale, "fallbackLocale");
        this.plugin = plugin;
        this.supportedLocales = supportedLocales;
        this.defaultPluginLocale = defaultPluginLocale;
        this.fallbackLocale = fallbackLocale;
        Iterable iterable = this.supportedLocales;
        LocalizationManager localizationManager = this;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            Locale locale = (Locale)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            LocaleConfig localeConfig = new LocaleConfig(this.plugin, (Locale)it);
            map.put(t, localeConfig);
        }
        localizationManager.configs = result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LocalizedString get(@NotNull String key, Object ... args) {
        void $this$mapValuesNotNull$iv;
        Map map;
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(args, "args");
        Map<Locale, LocaleConfig> map2 = this.configs;
        boolean $i$f$mapValuesNotNull = false;
        Map $this$mapValuesNotNull_u24lambda_u2425$iv = map = MapsKt.createMapBuilder();
        boolean bl = false;
        void $this$forEach$iv$iv = $this$mapValuesNotNull$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            MessageFormat it$iv;
            Map.Entry element$iv$iv;
            Map.Entry entry$iv = element$iv$iv = iterator2.next();
            boolean bl2 = false;
            Map.Entry entry = entry$iv;
            boolean bl3 = false;
            LocaleConfig v = (LocaleConfig)entry.getValue();
            if (v.getTemplate(key) == null) continue;
            boolean bl4 = false;
            $this$mapValuesNotNull_u24lambda_u2425$iv.put(entry$iv.getKey(), it$iv);
        }
        Map values = MapsKt.build(map);
        return new LocalizedString(key, args, values, (Locale)this.fallbackLocale.value(), this.defaultPluginLocale);
    }

    public final boolean contains(@NotNull String key) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(key, "key");
            Map<Locale, LocaleConfig> $this$any$iv = this.configs;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator<Map.Entry<Locale, LocaleConfig>> iterator2 = $this$any$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<Locale, LocaleConfig> element$iv;
                    Map.Entry<Locale, LocaleConfig> entry = element$iv = iterator2.next();
                    boolean bl2 = false;
                    LocaleConfig v = entry.getValue();
                    if (!(v.getTemplate(key) != null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lxyz/atrius/waystones/manager/LocalizationManager$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "xyz.atrius.jvm.PlatformType", "waystones"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u000eJ\t\u0010\u0013\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u000eH\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lxyz/atrius/waystones/manager/LocalizationManager$LocaleConfig;", "", "plugin", "Lxyz/atrius/waystones/internal/KotlinPlugin;", "locale", "Ljava/util/Locale;", "<init>", "(Lxyz/atrius/waystones/internal/KotlinPlugin;Ljava/util/Locale;)V", "file", "Ljava/io/File;", "config", "Lorg/bukkit/configuration/file/YamlConfiguration;", "cachedFormats", "Ljava/util/HashMap;", "", "Ljava/text/MessageFormat;", "Lxyz/atrius/collections/HashMap;", "getTemplate", "key", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "waystones"})
    @SourceDebugExtension(value={"SMAP\nLocalizationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalizationManager.kt\nxyz/atrius/waystones/manager/LocalizationManager$LocaleConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,83:1\n1#2:84\n382#3,7:85\n*S KotlinDebug\n*F\n+ 1 LocalizationManager.kt\nxyz/atrius/waystones/manager/LocalizationManager$LocaleConfig\n*L\n71#1:85,7\n*E\n"})
    private static final class LocaleConfig {
        @NotNull
        private final KotlinPlugin plugin;
        @NotNull
        private final Locale locale;
        @NotNull
        private final File file;
        @NotNull
        private final YamlConfiguration config;
        @NotNull
        private final HashMap<String, MessageFormat> cachedFormats;

        public LocaleConfig(@NotNull KotlinPlugin plugin, @NotNull Locale locale) {
            block2: {
                Object p0;
                Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
                Intrinsics.checkNotNullParameter(locale, "locale");
                this.plugin = plugin;
                this.locale = locale;
                this.file = new File(this.plugin.getDataFolder(), "locale-" + this.locale.toLanguageTag() + ".yml");
                this.config = new YamlConfiguration();
                this.cachedFormats = new HashMap();
                this.plugin.saveResource(this.file.getName(), true);
                Object object = this.file;
                Object object2 = this.config;
                try {
                    p0 = object;
                    boolean bl = false;
                    object2.load((File)p0);
                    p0 = Result.constructor-impl(Unit.INSTANCE);
                }
                catch (Throwable bl) {
                    p0 = Result.constructor-impl(ResultKt.createFailure(bl));
                }
                object = p0;
                Throwable throwable = Result.exceptionOrNull-impl(object);
                if (throwable == null) break block2;
                Object it = object2 = throwable;
                boolean bl = false;
                logger.error("Failed to load configuration " + this.file.getName() + "! Error: " + ((Throwable)it).getMessage());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final MessageFormat getTemplate(@NotNull String key) {
            Object object;
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter(key, "key");
            if (((Map)this.cachedFormats).containsKey(key)) {
                return this.cachedFormats.get(key);
            }
            String string = this.config.getString(key);
            if (string == null) {
                return null;
            }
            String template = string;
            Map map = this.cachedFormats;
            String key$iv = key;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                MessageFormat answer$iv = new MessageFormat(template, this.locale);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (MessageFormat)object;
        }

        private final KotlinPlugin component1() {
            return this.plugin;
        }

        private final Locale component2() {
            return this.locale;
        }

        @NotNull
        public final LocaleConfig copy(@NotNull KotlinPlugin plugin, @NotNull Locale locale) {
            Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
            Intrinsics.checkNotNullParameter(locale, "locale");
            return new LocaleConfig(plugin, locale);
        }

        public static /* synthetic */ LocaleConfig copy$default(LocaleConfig localeConfig, KotlinPlugin kotlinPlugin, Locale locale, int n, Object object) {
            if ((n & 1) != 0) {
                kotlinPlugin = localeConfig.plugin;
            }
            if ((n & 2) != 0) {
                locale = localeConfig.locale;
            }
            return localeConfig.copy(kotlinPlugin, locale);
        }

        @NotNull
        public String toString() {
            return "LocaleConfig(plugin=" + this.plugin + ", locale=" + this.locale + ")";
        }

        public int hashCode() {
            int result = this.plugin.hashCode();
            result = result * 31 + this.locale.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LocaleConfig)) {
                return false;
            }
            LocaleConfig localeConfig = (LocaleConfig)other;
            if (!Intrinsics.areEqual((Object)this.plugin, (Object)localeConfig.plugin)) {
                return false;
            }
            return Intrinsics.areEqual(this.locale, localeConfig.locale);
        }
    }
}

