/*
 * Decompiled with CFR 0.152.
 */
package xyz.atrius.waystones.manager;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Server;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.annotation.Single;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.atrius.Metadata;
import xyz.atrius.jvm.internal.DefaultConstructorMarker;
import xyz.atrius.jvm.internal.Intrinsics;
import xyz.atrius.jvm.internal.SourceDebugExtension;
import xyz.atrius.waystones.data.config.property.EnableAdvancementsProperty;
import xyz.atrius.waystones.internal.KotlinPlugin;
import xyz.atrius.waystones.provider.AdvancementProvider;

@Single
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u000f\u001a\u00020\u0010J0\u0010\u0011\u001a\u00020\u00102\u001a\u0010\u0012\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u00132\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0002J\b\u0010\u0016\u001a\u00020\u0010H\u0002J\u0006\u0010\u0017\u001a\u00020\u0010J\u0016\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\nJ\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lxyz/atrius/waystones/manager/AdvancementManager;", "", "plugin", "Lxyz/atrius/waystones/internal/KotlinPlugin;", "enableAdvancements", "Lxyz/atrius/waystones/data/config/property/EnableAdvancementsProperty;", "gson", "Lcom/google/gson/Gson;", "advancementContainers", "", "Lxyz/atrius/waystones/provider/AdvancementProvider;", "<init>", "(Lxyz/atrius/waystones/internal/KotlinPlugin;Lxyz/atrius/waystones/data/config/property/EnableAdvancementsProperty;Lcom/google/gson/Gson;Ljava/util/List;)V", "server", "Lorg/bukkit/Server;", "loadAdvancements", "", "load", "groups", "", "", "current", "unloadAllAdvancements", "reload", "awardAdvancement", "player", "Lorg/bukkit/entity/Player;", "adv", "Lorg/bukkit/advancement/Advancement;", "hasAdvancement", "", "Companion", "waystones"})
@SourceDebugExtension(value={"SMAP\nAdvancementManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdvancementManager.kt\nxyz/atrius/waystones/manager/AdvancementManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,93:1\n1491#2:94\n1516#2,3:95\n1519#2,3:105\n1869#2,2:108\n1869#2,2:110\n382#3,7:98\n*S KotlinDebug\n*F\n+ 1 AdvancementManager.kt\nxyz/atrius/waystones/manager/AdvancementManager\n*L\n25#1:94\n25#1:95,3\n25#1:105,3\n50#1:108,2\n72#1:110,2\n25#1:98,7\n*E\n"})
public final class AdvancementManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KotlinPlugin plugin;
    @NotNull
    private final EnableAdvancementsProperty enableAdvancements;
    @NotNull
    private final Gson gson;
    @NotNull
    private final List<AdvancementProvider> advancementContainers;
    @NotNull
    private final Server server;
    private static final Logger logger = LoggerFactory.getLogger(AdvancementManager.class);

    public AdvancementManager(@NotNull KotlinPlugin plugin, @NotNull EnableAdvancementsProperty enableAdvancements, @NotNull Gson gson, @NotNull List<? extends AdvancementProvider> advancementContainers) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        Intrinsics.checkNotNullParameter(enableAdvancements, "enableAdvancements");
        Intrinsics.checkNotNullParameter(gson, "gson");
        Intrinsics.checkNotNullParameter(advancementContainers, "advancementContainers");
        this.plugin = plugin;
        this.enableAdvancements = enableAdvancements;
        this.gson = gson;
        this.advancementContainers = advancementContainers;
        Server server = this.plugin.getServer();
        Intrinsics.checkNotNullExpressionValue(server, "getServer(...)");
        this.server = server;
    }

    /*
     * WARNING - void declaration
     */
    public final void loadAdvancements() {
        void $this$groupByTo$iv$iv;
        logger.info("Loading " + this.advancementContainers.size() + " advancements...");
        Iterable $this$groupBy$iv = this.advancementContainers;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            AdvancementProvider it = (AdvancementProvider)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getAsAdvancement().getParent();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map groups2 = destination$iv$iv;
        AdvancementManager.load$default(this, groups2, null, 2, null);
        logger.info("Loading complete!");
    }

    private final void load(Map<String, ? extends List<? extends AdvancementProvider>> groups2, String current) {
        List<? extends AdvancementProvider> current2 = groups2.get(current);
        if (current2 == null) {
            return;
        }
        for (AdvancementProvider advancementProvider : current2) {
            logger.info("Loading advancement '" + advancementProvider.namespacedKey().asString() + "'");
            this.server.getUnsafe().loadAdvancement(advancementProvider.namespacedKey(), this.gson.toJson((Object)advancementProvider.getAsAdvancement()));
            this.load(groups2, advancementProvider.namespacedKey().asString());
        }
    }

    static /* synthetic */ void load$default(AdvancementManager advancementManager, Map map, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        advancementManager.load(map, string);
    }

    private final void unloadAllAdvancements() {
        logger.info("Unloading advancements!");
        Iterable $this$forEach$iv = this.advancementContainers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AdvancementProvider it = (AdvancementProvider)element$iv;
            boolean bl = false;
            this.server.getUnsafe().removeAdvancement(it.namespacedKey());
        }
    }

    public final void reload() {
        this.unloadAllAdvancements();
        this.loadAdvancements();
    }

    public final void awardAdvancement(@NotNull Player player, @NotNull AdvancementProvider adv) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(adv, "adv");
        this.awardAdvancement(player, this.plugin.getServer().getAdvancement(adv.namespacedKey()));
    }

    /*
     * WARNING - void declaration
     */
    public final void awardAdvancement(@NotNull Player player, @Nullable Advancement adv) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter(player, "player");
        if (adv == null || !((Boolean)this.enableAdvancements.value()).booleanValue()) {
            return;
        }
        AdvancementProgress advancementProgress = player.getAdvancementProgress(adv);
        Intrinsics.checkNotNullExpressionValue(advancementProgress, "getAdvancementProgress(...)");
        AdvancementProgress criteria = advancementProgress;
        Collection collection = criteria.getRemainingCriteria();
        Intrinsics.checkNotNullExpressionValue(collection, "getRemainingCriteria(...)");
        Iterable iterable = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String p0 = (String)element$iv;
            boolean bl = false;
            criteria.awardCriteria(p0);
        }
    }

    public final boolean hasAdvancement(@NotNull Player player, @NotNull AdvancementProvider adv) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(adv, "adv");
        Advancement spigotAdvancement = this.plugin.getServer().getAdvancement(adv.namespacedKey());
        if (spigotAdvancement == null) {
            return false;
        }
        AdvancementProgress advancementProgress = player.getAdvancementProgress(spigotAdvancement);
        Intrinsics.checkNotNullExpressionValue(advancementProgress, "getAdvancementProgress(...)");
        AdvancementProgress progress = advancementProgress;
        return progress.getRemainingCriteria().isEmpty();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lxyz/atrius/waystones/manager/AdvancementManager$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "xyz.atrius.jvm.PlatformType", "waystones"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

