/*
 * Decompiled with CFR 0.152.
 */
package xyz.atrius.waystones.command.waystones;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.annotation.Single;
import xyz.atrius.Metadata;
import xyz.atrius.collections.CollectionsKt;
import xyz.atrius.jvm.internal.Intrinsics;
import xyz.atrius.text.StringsKt;
import xyz.atrius.waystones.command.waystones.WaystoneSubcommand;
import xyz.atrius.waystones.internal.KotlinPlugin;
import xyz.atrius.waystones.manager.LocalizationManager;
import xyz.atrius.waystones.utility.StringKt;

@Single
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u0011\u001a\u00070\u000b\u00a2\u0006\u0002\b\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J$\u0010\u0017\u001a\f\u0012\u0004\u0012\u00020\u0019\u0012\u0002\b\u00030\u00182\u0010\u0010\u001a\u001a\f\u0012\u0004\u0012\u00020\u0019\u0012\u0002\b\u00030\u0018H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00070\u000b\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001b"}, d2={"Lxyz/atrius/waystones/command/waystones/InfoCommand;", "Lxyz/atrius/waystones/command/waystones/WaystoneSubcommand;", "plugin", "Lxyz/atrius/waystones/internal/KotlinPlugin;", "localization", "Lxyz/atrius/waystones/manager/LocalizationManager;", "<init>", "(Lxyz/atrius/waystones/internal/KotlinPlugin;Lxyz/atrius/waystones/manager/LocalizationManager;)V", "pluginDescription", "Lorg/bukkit/plugin/PluginDescriptionFile;", "version", "", "Lorg/jetbrains/annotations/NotNull;", "author", "contributors", "website", "Lorg/jetbrains/annotations/Nullable;", "infoMsg", "player", "Lorg/bukkit/entity/Player;", "name", "getName", "()Ljava/lang/String;", "build", "Lcom/mojang/brigadier/builder/ArgumentBuilder;", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "base", "waystones"})
public final class InfoCommand
implements WaystoneSubcommand {
    @NotNull
    private final LocalizationManager localization;
    @NotNull
    private final PluginDescriptionFile pluginDescription;
    @NotNull
    private final String version;
    @NotNull
    private final String author;
    @NotNull
    private final String contributors;
    @NotNull
    private final String website;
    @NotNull
    private final String name;

    public InfoCommand(@NotNull KotlinPlugin plugin, @NotNull LocalizationManager localization) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        Intrinsics.checkNotNullParameter(localization, "localization");
        this.localization = localization;
        PluginDescriptionFile pluginDescriptionFile = plugin.getDescription();
        Intrinsics.checkNotNullExpressionValue(pluginDescriptionFile, "getDescription(...)");
        this.pluginDescription = pluginDescriptionFile;
        String string = this.pluginDescription.getVersion();
        Intrinsics.checkNotNullExpressionValue(string, "getVersion(...)");
        this.version = string;
        List list = this.pluginDescription.getAuthors();
        Intrinsics.checkNotNullExpressionValue(list, "getAuthors(...)");
        String string2 = (String)CollectionsKt.firstOrNull(list);
        if (string2 == null) {
            string2 = "Unknown";
        }
        this.author = string2;
        List list2 = this.pluginDescription.getAuthors();
        Intrinsics.checkNotNullExpressionValue(list2, "getAuthors(...)");
        this.contributors = CollectionsKt.joinToString$default(CollectionsKt.drop(list2, 1), ", ", null, null, 0, null, InfoCommand::contributors$lambda$0, 30, null);
        String string3 = this.pluginDescription.getWebsite();
        if (string3 == null) {
            string3 = "N/A";
        }
        this.website = string3;
        this.name = "info";
    }

    private final String infoMsg(Player player) {
        return StringKt.translateColors$default(StringsKt.trimMargin$default("\n        |" + this.localization.get("plugin-header", new Object[0]).format(player) + "\n        |Version&7: &a" + this.version + "&r\n        |Author&7: &d" + this.author + "&r\n        |Contributors: " + this.contributors + "\n        |Website: &d&n" + this.website + "&r\n        |" + this.localization.get("plugin-footer", new Object[0]).format(player) + "\n    ", null, 1, null), '\u0000', 1, null);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public ArgumentBuilder<CommandSourceStack, ?> build(@NotNull ArgumentBuilder<CommandSourceStack, ?> base) {
        Intrinsics.checkNotNullParameter(base, "base");
        ArgumentBuilder argumentBuilder = base.executes(arg_0 -> InfoCommand.build$lambda$1(this, arg_0));
        Intrinsics.checkNotNullExpressionValue(argumentBuilder, "executes(...)");
        return argumentBuilder;
    }

    @Override
    @Nullable
    public String getBasePermission() {
        return WaystoneSubcommand.super.getBasePermission();
    }

    private static final CharSequence contributors$lambda$0(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return "&d" + it + "&r";
    }

    private static final int build$lambda$1(InfoCommand this$0, CommandContext it) {
        CommandSender commandSender = ((CommandSourceStack)it.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        sender.sendPlainMessage(this$0.infoMsg(sender instanceof Player ? (Player)sender : null));
        return 1;
    }
}

