/*
 * Decompiled with CFR 0.152.
 */
package xyz.atrius.waystones.command;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import xyz.atrius.Metadata;
import xyz.atrius.jvm.internal.Intrinsics;
import xyz.atrius.waystones.command.SubCommand;
import xyz.atrius.waystones.manager.LocalizationManager;
import xyz.atrius.waystones.manager.LocalizedString;
import xyz.atrius.waystones.utility.PlayerKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ6\u0010\u0011\u001a&\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00100\u0010 \u0013*\u0012\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00100\u0010\u0018\u00010\u00120\u0012*\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lxyz/atrius/waystones/command/BaseCommand;", "S", "Lxyz/atrius/waystones/command/SubCommand;", "", "name", "", "localization", "Lxyz/atrius/waystones/manager/LocalizationManager;", "<init>", "(Ljava/lang/String;Lxyz/atrius/waystones/manager/LocalizationManager;)V", "subCommands", "", "getSubCommands", "()Ljava/util/List;", "create", "Lcom/mojang/brigadier/tree/LiteralCommandNode;", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "withSubcommandList", "Lcom/mojang/brigadier/builder/LiteralArgumentBuilder;", "xyz.atrius.jvm.PlatformType", "waystones"})
public abstract class BaseCommand<S extends SubCommand> {
    @NotNull
    private final String name;
    @NotNull
    private final LocalizationManager localization;

    public BaseCommand(@NotNull String name, @NotNull LocalizationManager localization) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(localization, "localization");
        this.name = name;
        this.localization = localization;
    }

    @NotNull
    public abstract List<S> getSubCommands();

    @NotNull
    public final LiteralCommandNode<CommandSourceStack> create() {
        LiteralArgumentBuilder literalArgumentBuilder = Commands.literal((String)this.name);
        Intrinsics.checkNotNullExpressionValue(literalArgumentBuilder, "literal(...)");
        LiteralArgumentBuilder base = literalArgumentBuilder;
        for (SubCommand command : this.getSubCommands()) {
            LiteralArgumentBuilder literalArgumentBuilder2 = Commands.literal((String)command.getName());
            Intrinsics.checkNotNullExpressionValue(literalArgumentBuilder2, "literal(...)");
            ArgumentBuilder<CommandSourceStack, ?> subCommand = command.build((ArgumentBuilder)literalArgumentBuilder2);
            if (command.getBasePermission() != null) {
                String permission;
                boolean bl = false;
                subCommand.requires(arg_0 -> BaseCommand.create$lambda$1$lambda$0(permission, arg_0));
            }
            base.then(subCommand);
        }
        LiteralCommandNode literalCommandNode = this.withSubcommandList((LiteralArgumentBuilder<CommandSourceStack>)base).build();
        Intrinsics.checkNotNullExpressionValue(literalCommandNode, "build(...)");
        return literalCommandNode;
    }

    private final LiteralArgumentBuilder<CommandSourceStack> withSubcommandList(LiteralArgumentBuilder<CommandSourceStack> $this$withSubcommandList) {
        return (LiteralArgumentBuilder)$this$withSubcommandList.executes(arg_0 -> BaseCommand.withSubcommandList$lambda$2(this, arg_0));
    }

    private static final boolean create$lambda$1$lambda$0(String $permission, CommandSourceStack it) {
        return it.getSender().hasPermission($permission);
    }

    private static final int withSubcommandList$lambda$2(BaseCommand this$0, CommandContext it) {
        String template = "/%s &b%s &7- &d%s";
        CommandSender commandSender = ((CommandSourceStack)it.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        Player player = sender instanceof Player ? (Player)sender : null;
        PlayerKt.message$default(sender, this$0.localization.get("plugin-header", new Object[0]).format(player), '\u0000', 2, null);
        for (SubCommand command : this$0.getSubCommands()) {
            String permission = command.getBasePermission();
            if (permission != null && !sender.hasPermission(permission)) continue;
            String subCommandKey = this$0.name + "-" + command.getName() + "-subcommand-desc";
            LocalizedString description = this$0.localization.contains(subCommandKey) ? this$0.localization.get(subCommandKey, new Object[0]) : this$0.localization.get("default-subcommand-desc", new Object[0]);
            String string = template;
            Object[] objectArray = new Object[]{this$0.name, command.getName(), description.format(player)};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            PlayerKt.message$default(sender, string2, '\u0000', 2, null);
        }
        PlayerKt.message$default(sender, this$0.localization.get("plugin-footer", new Object[0]).format(player), '\u0000', 2, null);
        return 1;
    }
}

