/*
 * Decompiled with CFR 0.152.
 */
package xyz.atrius.waystones.service;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.RespawnAnchor;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.koin.core.annotation.Single;
import xyz.atrius.Metadata;
import xyz.atrius.Unit;
import xyz.atrius.jvm.functions.Function0;
import xyz.atrius.jvm.internal.Intrinsics;
import xyz.atrius.jvm.internal.SourceDebugExtension;
import xyz.atrius.random.Random;
import xyz.atrius.waystones.advancement.IDontFeelSoGoodAdvancement;
import xyz.atrius.waystones.animation.AnimationManager;
import xyz.atrius.waystones.animation.effect.SimpleTeleportEffect;
import xyz.atrius.waystones.data.config.property.EnablePortalSicknessProperty;
import xyz.atrius.waystones.data.config.property.PortalSicknessChanceProperty;
import xyz.atrius.waystones.data.config.property.PortalSicknessDamageProperty;
import xyz.atrius.waystones.data.config.property.PortalSicknessWarpingProperty;
import xyz.atrius.waystones.data.config.property.PowerCostProperty;
import xyz.atrius.waystones.data.config.property.WaitTimeProperty;
import xyz.atrius.waystones.data.config.property.WarpAnimationsProperty;
import xyz.atrius.waystones.data.config.property.type.SicknessOption;
import xyz.atrius.waystones.manager.AdvancementManager;
import xyz.atrius.waystones.manager.LocalizationManager;
import xyz.atrius.waystones.service.KeyService;
import xyz.atrius.waystones.service.WaystoneService;
import xyz.atrius.waystones.utility.BlockKt;
import xyz.atrius.waystones.utility.LocationKt;
import xyz.atrius.waystones.utility.PlayerKt;

@Single
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J&\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u000e\b\u0002\u0010%\u001a\b\u0012\u0004\u0012\u00020 0&J\u0018\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"H\u0002J\u000e\u0010)\u001a\u00020 2\u0006\u0010(\u001a\u00020\u001cJ\u0011\u0010*\u001a\u00020+2\u0006\u0010(\u001a\u00020\u001cH\u0086\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u001a\u001a\u001e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bj\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d`\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lxyz/atrius/waystones/service/TeleportService;", "", "animationManager", "Lxyz/atrius/waystones/animation/AnimationManager;", "localization", "Lxyz/atrius/waystones/manager/LocalizationManager;", "warpAnimations", "Lxyz/atrius/waystones/data/config/property/WarpAnimationsProperty;", "waitTime", "Lxyz/atrius/waystones/data/config/property/WaitTimeProperty;", "portalSickness", "Lxyz/atrius/waystones/data/config/property/EnablePortalSicknessProperty;", "portalSicknessWarping", "Lxyz/atrius/waystones/data/config/property/PortalSicknessWarpingProperty;", "portalSicknessDamage", "Lxyz/atrius/waystones/data/config/property/PortalSicknessDamageProperty;", "portalSicknessChance", "Lxyz/atrius/waystones/data/config/property/PortalSicknessChanceProperty;", "advancementManager", "Lxyz/atrius/waystones/manager/AdvancementManager;", "iDontFeelSoGoodAdvancement", "Lxyz/atrius/waystones/advancement/IDontFeelSoGoodAdvancement;", "powerCost", "Lxyz/atrius/waystones/data/config/property/PowerCostProperty;", "<init>", "(Lxyz/atrius/waystones/animation/AnimationManager;Lxyz/atrius/waystones/manager/LocalizationManager;Lxyz/atrius/waystones/data/config/property/WarpAnimationsProperty;Lxyz/atrius/waystones/data/config/property/WaitTimeProperty;Lxyz/atrius/waystones/data/config/property/EnablePortalSicknessProperty;Lxyz/atrius/waystones/data/config/property/PortalSicknessWarpingProperty;Lxyz/atrius/waystones/data/config/property/PortalSicknessDamageProperty;Lxyz/atrius/waystones/data/config/property/PortalSicknessChanceProperty;Lxyz/atrius/waystones/manager/AdvancementManager;Lxyz/atrius/waystones/advancement/IDontFeelSoGoodAdvancement;Lxyz/atrius/waystones/data/config/property/PowerCostProperty;)V", "queuedTeleports", "Ljava/util/HashMap;", "Lorg/bukkit/entity/Player;", "", "Lxyz/atrius/collections/HashMap;", "queueEvent", "", "warp", "Lxyz/atrius/waystones/service/WaystoneService$Warp;", "key", "Lxyz/atrius/waystones/service/KeyService$Key;", "onComplete", "Lxyz/atrius/Function0;", "teleport", "player", "cancel", "contains", "", "waystones"})
@SourceDebugExtension(value={"SMAP\nTeleportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TeleportService.kt\nxyz/atrius/waystones/service/TeleportService\n+ 2 Data.kt\nxyz/atrius/waystones/utility/DataKt\n*L\n1#1,119:1\n8#2,6:120\n*S KotlinDebug\n*F\n+ 1 TeleportService.kt\nxyz/atrius/waystones/service/TeleportService\n*L\n84#1:120,6\n*E\n"})
public final class TeleportService {
    @NotNull
    private final AnimationManager animationManager;
    @NotNull
    private final LocalizationManager localization;
    @NotNull
    private final WarpAnimationsProperty warpAnimations;
    @NotNull
    private final WaitTimeProperty waitTime;
    @NotNull
    private final EnablePortalSicknessProperty portalSickness;
    @NotNull
    private final PortalSicknessWarpingProperty portalSicknessWarping;
    @NotNull
    private final PortalSicknessDamageProperty portalSicknessDamage;
    @NotNull
    private final PortalSicknessChanceProperty portalSicknessChance;
    @NotNull
    private final AdvancementManager advancementManager;
    @NotNull
    private final IDontFeelSoGoodAdvancement iDontFeelSoGoodAdvancement;
    @NotNull
    private final PowerCostProperty powerCost;
    @NotNull
    private final HashMap<Player, Integer> queuedTeleports;

    public TeleportService(@NotNull AnimationManager animationManager, @NotNull LocalizationManager localization, @NotNull WarpAnimationsProperty warpAnimations, @NotNull WaitTimeProperty waitTime, @NotNull EnablePortalSicknessProperty portalSickness, @NotNull PortalSicknessWarpingProperty portalSicknessWarping, @NotNull PortalSicknessDamageProperty portalSicknessDamage, @NotNull PortalSicknessChanceProperty portalSicknessChance, @NotNull AdvancementManager advancementManager, @NotNull IDontFeelSoGoodAdvancement iDontFeelSoGoodAdvancement, @NotNull PowerCostProperty powerCost) {
        Intrinsics.checkNotNullParameter(animationManager, "animationManager");
        Intrinsics.checkNotNullParameter(localization, "localization");
        Intrinsics.checkNotNullParameter(warpAnimations, "warpAnimations");
        Intrinsics.checkNotNullParameter(waitTime, "waitTime");
        Intrinsics.checkNotNullParameter(portalSickness, "portalSickness");
        Intrinsics.checkNotNullParameter(portalSicknessWarping, "portalSicknessWarping");
        Intrinsics.checkNotNullParameter(portalSicknessDamage, "portalSicknessDamage");
        Intrinsics.checkNotNullParameter(portalSicknessChance, "portalSicknessChance");
        Intrinsics.checkNotNullParameter(advancementManager, "advancementManager");
        Intrinsics.checkNotNullParameter(iDontFeelSoGoodAdvancement, "iDontFeelSoGoodAdvancement");
        Intrinsics.checkNotNullParameter(powerCost, "powerCost");
        this.animationManager = animationManager;
        this.localization = localization;
        this.warpAnimations = warpAnimations;
        this.waitTime = waitTime;
        this.portalSickness = portalSickness;
        this.portalSicknessWarping = portalSicknessWarping;
        this.portalSicknessDamage = portalSicknessDamage;
        this.portalSicknessChance = portalSicknessChance;
        this.advancementManager = advancementManager;
        this.iDontFeelSoGoodAdvancement = iDontFeelSoGoodAdvancement;
        this.powerCost = powerCost;
        this.queuedTeleports = new HashMap();
    }

    public final void queueEvent(@NotNull WaystoneService.Warp warp, @NotNull KeyService.Key key, @NotNull Function0<Unit> onComplete) {
        Intrinsics.checkNotNullParameter(warp, "warp");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(onComplete, "onComplete");
        Player player = warp.getPlayer();
        if (((Map)this.queuedTeleports).containsKey(player)) {
            return;
        }
        ((Map)this.queuedTeleports).put(player, this.animationManager.register(new SimpleTeleportEffect(warp, this.warpAnimations, this.waitTime, this.localization), warp.getPlayer(), warp.getWarpLocation(), () -> TeleportService.queueEvent$lambda$1(this, player, key, warp, onComplete)));
    }

    public static /* synthetic */ void queueEvent$default(TeleportService teleportService, WaystoneService.Warp warp, KeyService.Key key, Function0 function0, int n, Object object) {
        if ((n & 4) != 0) {
            function0 = TeleportService::queueEvent$lambda$0;
        }
        teleportService.queueEvent(warp, key, function0);
    }

    /*
     * WARNING - void declaration
     */
    private final void teleport(Player player, WaystoneService.Warp warp) {
        boolean sick;
        void it;
        PotionEffect[] potionEffectArray;
        Location location = player.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Location location2 = location;
        Location warpLocation = warp.getWarpLocation();
        Block block = warpLocation.getBlock();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        Block block2 = block;
        PotionEffect[] potionEffectArray2 = potionEffectArray = LocationKt.getCenter(LocationKt.getUP(warpLocation));
        Player player2 = player;
        boolean bl = false;
        it.setYaw(location2.getYaw());
        it.setPitch(location2.getPitch());
        player2.teleport((Location)potionEffectArray);
        if (PlayerKt.getImmortal(player) || !((Boolean)this.portalSickness.value()).booleanValue()) {
            PlayerKt.sendActionMessage(player, this.localization.get("warp-success", new Object[0]));
            return;
        }
        if (warp.getUsePower()) {
            Block block3 = BlockKt.getPowerBlock(block2);
            if (block3 != null) {
                Block block4;
                Block $this$update$iv = block3;
                boolean $i$f$update = false;
                Block it$iv = block4 = $this$update$iv;
                boolean bl2 = false;
                BlockData blockData = $this$update$iv.getBlockData();
                if (blockData == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.bukkit.block.data.type.RespawnAnchor");
                }
                BlockData data$iv = (BlockData)((RespawnAnchor)blockData);
                RespawnAnchor $this$teleport_u24lambda_u243 = (RespawnAnchor)data$iv;
                boolean bl3 = false;
                $this$teleport_u24lambda_u243.setCharges($this$teleport_u24lambda_u243.getCharges() - ((Number)this.powerCost.value()).intValue());
                $this$update$iv.setBlockData(data$iv);
                $this$update$iv.getState().update(true);
            }
        }
        if ((sick = PlayerKt.hasPortalSickness(player)) && this.portalSicknessWarping.value() == SicknessOption.DAMAGE_ON_TELEPORT) {
            player.damage(((Number)this.portalSicknessDamage.value()).doubleValue());
        }
        if (!sick && Random.Default.nextDouble() > ((Number)this.portalSicknessChance.value()).doubleValue()) {
            PlayerKt.sendActionMessage(player, this.localization.get("warp-success", new Object[0]));
            return;
        }
        potionEffectArray2 = new PotionEffect[]{new PotionEffect(PotionEffectType.NAUSEA, 600, 9), new PotionEffect(PotionEffectType.BLINDNESS, 100, 9)};
        PlayerKt.addPotionEffects(player, potionEffectArray2);
        this.advancementManager.awardAdvancement(player, this.iDontFeelSoGoodAdvancement);
        PlayerKt.sendActionMessage(player, this.localization.get("warp-sickness", new Object[0]));
    }

    public final void cancel(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        Integer n = this.queuedTeleports.remove(player);
        int id = n != null ? n : -1;
        this.animationManager.cancel(id, player);
    }

    public final boolean contains(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        return ((Map)this.queuedTeleports).containsKey(player);
    }

    private static final Unit queueEvent$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit queueEvent$lambda$1(TeleportService this$0, Player $player, KeyService.Key $key, WaystoneService.Warp $warp, Function0 $onComplete) {
        this$0.queuedTeleports.remove($player);
        $key.useKey();
        this$0.teleport($player, $warp);
        $onComplete.invoke();
        return Unit.INSTANCE;
    }
}

