/*
 * Decompiled with CFR 0.152.
 */
package xyz.atrius.waystones.service;

import arrow.core.Either;
import arrow.core.NonFatalOrThrowKt;
import arrow.core.raise.DefaultRaise;
import arrow.core.raise.Raise;
import arrow.core.raise.RaiseCancellationException;
import arrow.core.raise.RaiseKt;
import java.util.concurrent.CancellationException;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.CompassMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.koin.core.annotation.Single;
import xyz.atrius.KotlinNothingValueException;
import xyz.atrius.Metadata;
import xyz.atrius.Unit;
import xyz.atrius.collections.CollectionsKt;
import xyz.atrius.jvm.functions.Function0;
import xyz.atrius.jvm.internal.DefaultConstructorMarker;
import xyz.atrius.jvm.internal.Intrinsics;
import xyz.atrius.jvm.internal.SourceDebugExtension;
import xyz.atrius.waystones.dao.WaystoneInfo;
import xyz.atrius.waystones.data.config.property.RelinkableKeysProperty;
import xyz.atrius.waystones.manager.LocalizationManager;
import xyz.atrius.waystones.manager.LocalizedString;
import xyz.atrius.waystones.provider.DefaultKeyProvider;
import xyz.atrius.waystones.repository.WaystoneInfoRepository;
import xyz.atrius.waystones.service.KeyService;
import xyz.atrius.waystones.utility.ItemKt;
import xyz.atrius.waystones.utility.LocationKt;
import xyz.atrius.waystones.utility.PlayerKt;
import xyz.atrius.waystones.utility.StringKt;

@Single
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001fB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ*\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J*\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J>\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J&\u0010\u001e\u001a\u00020\u0015*\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lxyz/atrius/waystones/service/LinkService;", "", "localization", "Lxyz/atrius/waystones/manager/LocalizationManager;", "relinkableKeys", "Lxyz/atrius/waystones/data/config/property/RelinkableKeysProperty;", "keyService", "Lxyz/atrius/waystones/service/KeyService;", "defaultKeyProvider", "Lxyz/atrius/waystones/provider/DefaultKeyProvider;", "waystoneInfoRepository", "Lxyz/atrius/waystones/repository/WaystoneInfoRepository;", "<init>", "(Lxyz/atrius/waystones/manager/LocalizationManager;Lxyz/atrius/waystones/data/config/property/RelinkableKeysProperty;Lxyz/atrius/waystones/service/KeyService;Lxyz/atrius/waystones/provider/DefaultKeyProvider;Lxyz/atrius/waystones/repository/WaystoneInfoRepository;)V", "process", "Larrow/core/Either;", "Lxyz/atrius/waystones/service/LinkService$LinkServiceError;", "", "player", "Lorg/bukkit/entity/Player;", "item", "Lorg/bukkit/inventory/ItemStack;", "block", "Lorg/bukkit/block/Block;", "updateWarpKey", "name", "", "linkNewWarpKey", "meta", "Lorg/bukkit/inventory/meta/CompassMeta;", "link", "LinkServiceError", "waystones"})
@SourceDebugExtension(value={"SMAP\nLinkService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinkService.kt\nxyz/atrius/waystones/service/LinkService\n+ 2 Builders.kt\narrow/core/raise/RaiseKt__BuildersKt\n+ 3 Fold.kt\narrow/core/raise/RaiseKt__FoldKt\n+ 4 Raise.kt\narrow/core/raise/RaiseKt__RaiseKt\n+ 5 Data.kt\nxyz/atrius/waystones/utility/DataKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n53#2:138\n53#2:153\n115#3:139\n142#3,3:140\n145#3,8:145\n115#3:154\n142#3,3:155\n145#3,8:160\n584#4:143\n629#4:144\n584#4:158\n584#4:159\n15#5,3:168\n18#5,2:172\n1#6:171\n*S KotlinDebug\n*F\n+ 1 LinkService.kt\nxyz/atrius/waystones/service/LinkService\n*L\n37#1:138\n78#1:153\n37#1:139\n37#1:140,3\n37#1:145,8\n78#1:154\n78#1:155,3\n78#1:160,8\n38#1:143\n42#1:144\n82#1:158\n87#1:159\n99#1:168,3\n99#1:172,2\n*E\n"})
public final class LinkService {
    @NotNull
    private final LocalizationManager localization;
    @NotNull
    private final RelinkableKeysProperty relinkableKeys;
    @NotNull
    private final KeyService keyService;
    @NotNull
    private final DefaultKeyProvider defaultKeyProvider;
    @NotNull
    private final WaystoneInfoRepository waystoneInfoRepository;

    public LinkService(@NotNull LocalizationManager localization, @NotNull RelinkableKeysProperty relinkableKeys, @NotNull KeyService keyService, @NotNull DefaultKeyProvider defaultKeyProvider, @NotNull WaystoneInfoRepository waystoneInfoRepository) {
        Intrinsics.checkNotNullParameter(localization, "localization");
        Intrinsics.checkNotNullParameter(relinkableKeys, "relinkableKeys");
        Intrinsics.checkNotNullParameter(keyService, "keyService");
        Intrinsics.checkNotNullParameter(defaultKeyProvider, "defaultKeyProvider");
        Intrinsics.checkNotNullParameter(waystoneInfoRepository, "waystoneInfoRepository");
        this.localization = localization;
        this.relinkableKeys = relinkableKeys;
        this.keyService = keyService;
        this.defaultKeyProvider = defaultKeyProvider;
        this.waystoneInfoRepository = waystoneInfoRepository;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Either<LinkServiceError, Unit> process(@NotNull Player player, @NotNull ItemStack item, @NotNull Block block) {
        Either either;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(item, "item");
        Intrinsics.checkNotNullParameter(block, "block");
        boolean $i$f$either = false;
        boolean $i$f$_foldOrThrow = false;
        boolean $i$f$_fold = false;
        DefaultRaise raise$iv$iv$iv = new DefaultRaise(false);
        try {
            Raise $this$process_u24lambda_u242 = (Raise)raise$iv$iv$iv;
            boolean bl = false;
            Raise raise = $this$process_u24lambda_u242;
            boolean condition$iv22 = this.keyService.isWarpKey(item) && block.getType() == Material.LODESTONE;
            boolean $i$f$ensure22 = false;
            if (!condition$iv22) {
                void $this$ensure$iv;
                void var13_15 = $this$ensure$iv;
                boolean bl2 = false;
                var13_15.raise((Object)LinkServiceError.Ignore.INSTANCE);
                throw new KotlinNothingValueException();
            }
            Raise condition$iv22 = $this$process_u24lambda_u242;
            ItemMeta $i$f$ensure22 = item.getItemMeta();
            CompassMeta value$iv = $i$f$ensure22 instanceof CompassMeta ? (CompassMeta)$i$f$ensure22 : null;
            boolean $i$f$ensureNotNull = false;
            CompassMeta compassMeta = value$iv;
            if (compassMeta == null) {
                void $this$ensureNotNull$iv;
                void var13_16 = $this$ensureNotNull$iv;
                boolean bl3 = false;
                var13_16.raise((Object)LinkServiceError.Ignore.INSTANCE);
                throw new KotlinNothingValueException();
            }
            CompassMeta meta = compassMeta;
            Location location = block.getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            WaystoneInfo info = this.waystoneInfoRepository.getWaystone(location).get();
            ItemMeta itemMeta = (ItemMeta)meta;
            PersistentDataType persistentDataType = PersistentDataType.STRING;
            Intrinsics.checkNotNullExpressionValue(persistentDataType, "STRING");
            String metaName = (String)ItemKt.get(itemMeta, "waystone_name", persistentDataType);
            WaystoneInfo waystoneInfo = info;
            String name = waystoneInfo != null ? waystoneInfo.getName() : null;
            boolean isDifferentName = name != null && !Intrinsics.areEqual(metaName, name);
            boolean isSameLocation = Intrinsics.areEqual(block.getLocation(), meta.getLodestone());
            if (isSameLocation && isDifferentName) {
                this.updateWarpKey(player, item, block, name);
            } else {
                $this$process_u24lambda_u242.bind(this.linkNewWarpKey(player, item, block, name, meta));
            }
            Unit res$iv$iv$iv = Unit.INSTANCE;
            raise$iv$iv$iv.complete();
            Unit it$iv = res$iv$iv$iv;
            boolean bl4 = false;
            either = (Either)new Either.Right((Object)it$iv);
        }
        catch (RaiseCancellationException e$iv$iv$iv) {
            raise$iv$iv$iv.complete();
            Object it$iv = RaiseKt.raisedOrRethrow((CancellationException)((CancellationException)((Object)e$iv$iv$iv)), (DefaultRaise)raise$iv$iv$iv);
            boolean bl = false;
            either = (Either)new Either.Left(it$iv);
        }
        catch (Throwable e$iv$iv$iv) {
            raise$iv$iv$iv.complete();
            Throwable it$iv$iv = NonFatalOrThrowKt.nonFatalOrThrow((Throwable)e$iv$iv$iv);
            boolean bl = false;
            throw it$iv$iv;
        }
        return either;
    }

    private final void updateWarpKey(Player player, ItemStack item, Block block, String name) {
        this.link(item, player, block, name);
        Sound sound = Sound.ITEM_LODESTONE_COMPASS_LOCK;
        Intrinsics.checkNotNullExpressionValue(sound, "ITEM_LODESTONE_COMPASS_LOCK");
        PlayerKt.playSound$default(player, sound, 0.0f, 0.0f, 6, null);
    }

    private final Either<LinkServiceError, Unit> linkNewWarpKey(Player player, ItemStack item, Block block, String name, CompassMeta meta) {
        Either either;
        boolean $i$f$either = false;
        boolean $i$f$_foldOrThrow = false;
        boolean $i$f$_fold = false;
        DefaultRaise raise$iv$iv$iv = new DefaultRaise(false);
        try {
            Raise $this$ensure$iv;
            boolean $i$f$ensure;
            boolean condition$iv;
            Raise $this$linkNewWarpKey_u24lambda_u245 = (Raise)raise$iv$iv$iv;
            boolean bl = false;
            if (!((Boolean)this.relinkableKeys.value()).booleanValue()) {
                Raise raise = $this$linkNewWarpKey_u24lambda_u245;
                condition$iv = !meta.hasLodestone();
                $i$f$ensure = false;
                if (!condition$iv) {
                    Raise raise2 = $this$ensure$iv;
                    boolean bl2 = false;
                    raise2.raise((Object)new LinkServiceError.NotRelinkable(this.localization));
                    throw new KotlinNothingValueException();
                }
            }
            $this$ensure$iv = $this$linkNewWarpKey_u24lambda_u245;
            condition$iv = !Intrinsics.areEqual(meta.getLodestone(), block.getLocation());
            $i$f$ensure = false;
            if (!condition$iv) {
                Raise raise = $this$ensure$iv;
                boolean bl3 = false;
                raise.raise((Object)new LinkServiceError.AlreadyLinked(this.localization));
                throw new KotlinNothingValueException();
            }
            ItemStack key = this.link(DefaultKeyProvider.getKey$default(this.defaultKeyProvider, player, 0, 2, null), player, block, name);
            PlayerInventory playerInventory = player.getInventory();
            Intrinsics.checkNotNullExpressionValue(playerInventory, "getInventory(...)");
            ItemKt.addItemNaturally(playerInventory, item, key);
            Sound sound = Sound.ITEM_LODESTONE_COMPASS_LOCK;
            Intrinsics.checkNotNullExpressionValue(sound, "ITEM_LODESTONE_COMPASS_LOCK");
            PlayerKt.playSound$default(player, sound, 0.0f, 0.0f, 6, null);
            Unit res$iv$iv$iv = Unit.INSTANCE;
            raise$iv$iv$iv.complete();
            Unit it$iv = res$iv$iv$iv;
            boolean bl4 = false;
            either = (Either)new Either.Right((Object)it$iv);
        }
        catch (RaiseCancellationException e$iv$iv$iv) {
            raise$iv$iv$iv.complete();
            Object it$iv = RaiseKt.raisedOrRethrow((CancellationException)((CancellationException)((Object)e$iv$iv$iv)), (DefaultRaise)raise$iv$iv$iv);
            boolean bl = false;
            either = (Either)new Either.Left(it$iv);
        }
        catch (Throwable e$iv$iv$iv) {
            raise$iv$iv$iv.complete();
            Throwable it$iv$iv = NonFatalOrThrowKt.nonFatalOrThrow((Throwable)e$iv$iv$iv);
            boolean bl = false;
            throw it$iv$iv;
        }
        return either;
    }

    private final ItemStack link(ItemStack $this$link, Player player, Block block, String name) {
        String string;
        ItemStack itemStack;
        ItemStack $this$update$iv = $this$link;
        boolean $i$f$update = false;
        ItemStack it$iv = itemStack = $this$update$iv;
        boolean bl = false;
        ItemMeta itemMeta = $this$update$iv.getItemMeta();
        if (itemMeta == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.bukkit.inventory.meta.CompassMeta");
        }
        ItemMeta data$iv = (ItemMeta)((CompassMeta)itemMeta);
        CompassMeta $this$link_u24lambda_u248 = (CompassMeta)data$iv;
        boolean bl2 = false;
        $this$link_u24lambda_u248.setLodestone(block.getLocation());
        $this$link_u24lambda_u248.setLodestoneTracked(true);
        CharSequence charSequence = name;
        if (!(charSequence == null || charSequence.length() == 0)) {
            String it = this.localization.get("key-name", new Object[0]).format(player);
            boolean bl3 = false;
            String p0 = it + ": (" + name + ")";
            boolean bl4 = false;
            TextComponent textComponent = Component.text((String)p0);
            Intrinsics.checkNotNullExpressionValue(textComponent, "let(...)");
            TextComponent displayName = textComponent;
            $this$link_u24lambda_u248.displayName((Component)displayName);
            $this$link_u24lambda_u248.getPersistentDataContainer().set(StringKt.toKey$default("waystone_name", null, 1, null), PersistentDataType.STRING, (Object)name);
        }
        if ((string = name) == null) {
            string = this.localization.get("unnamed-waystone", new Object[0]).format(player);
        }
        String name2 = string;
        Object[] objectArray = new Object[2];
        objectArray[0] = name2;
        Location location = $this$link_u24lambda_u248.getLodestone();
        objectArray[1] = location != null ? LocationKt.getLocationCode(location) : null;
        String p0 = this.localization.get("link-key-lore", objectArray).format(player);
        boolean bl5 = false;
        TextComponent textComponent = Component.text((String)p0);
        Intrinsics.checkNotNullExpressionValue(textComponent, "let(...)");
        TextComponent lore = textComponent;
        $this$link_u24lambda_u248.lore(CollectionsKt.listOf(lore));
        $this$update$iv.setItemMeta(data$iv);
        return itemStack;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\t\n\u000bB\u0019\b\u0004\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0019\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u0082\u0001\u0003\f\r\u000e\u00a8\u0006\u000f"}, d2={"Lxyz/atrius/waystones/service/LinkService$LinkServiceError;", "", "message", "Lxyz/atrius/Function0;", "Lxyz/atrius/waystones/manager/LocalizedString;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "getMessage", "()Lkotlin/jvm/functions/Function0;", "Ignore", "NotRelinkable", "AlreadyLinked", "Lxyz/atrius/waystones/service/LinkService$LinkServiceError$AlreadyLinked;", "Lxyz/atrius/waystones/service/LinkService$LinkServiceError$Ignore;", "Lxyz/atrius/waystones/service/LinkService$LinkServiceError$NotRelinkable;", "waystones"})
    public static abstract sealed class LinkServiceError {
        @NotNull
        private final Function0<LocalizedString> message;

        private LinkServiceError(Function0<LocalizedString> message) {
            this.message = message;
        }

        @NotNull
        public final Function0<LocalizedString> getMessage() {
            return this.message;
        }

        public /* synthetic */ LinkServiceError(Function0 message, DefaultConstructorMarker $constructor_marker) {
            this(message);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lxyz/atrius/waystones/service/LinkService$LinkServiceError$AlreadyLinked;", "Lxyz/atrius/waystones/service/LinkService$LinkServiceError;", "localization", "Lxyz/atrius/waystones/manager/LocalizationManager;", "<init>", "(Lxyz/atrius/waystones/manager/LocalizationManager;)V", "waystones"})
        public static final class AlreadyLinked
        extends LinkServiceError {
            public AlreadyLinked(@NotNull LocalizationManager localization) {
                Intrinsics.checkNotNullParameter(localization, "localization");
                super(() -> AlreadyLinked._init_$lambda$0(localization), null);
            }

            private static final LocalizedString _init_$lambda$0(LocalizationManager $localization) {
                return $localization.get("link-already-linked", new Object[0]);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lxyz/atrius/waystones/service/LinkService$LinkServiceError$Ignore;", "Lxyz/atrius/waystones/service/LinkService$LinkServiceError;", "<init>", "()V", "waystones"})
        public static final class Ignore
        extends LinkServiceError {
            @NotNull
            public static final Ignore INSTANCE = new Ignore();

            private Ignore() {
                super(Ignore::_init_$lambda$0, null);
            }

            private static final LocalizedString _init_$lambda$0() {
                return null;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lxyz/atrius/waystones/service/LinkService$LinkServiceError$NotRelinkable;", "Lxyz/atrius/waystones/service/LinkService$LinkServiceError;", "localization", "Lxyz/atrius/waystones/manager/LocalizationManager;", "<init>", "(Lxyz/atrius/waystones/manager/LocalizationManager;)V", "waystones"})
        public static final class NotRelinkable
        extends LinkServiceError {
            public NotRelinkable(@NotNull LocalizationManager localization) {
                Intrinsics.checkNotNullParameter(localization, "localization");
                super(() -> NotRelinkable._init_$lambda$0(localization), null);
            }

            private static final LocalizedString _init_$lambda$0(LocalizationManager $localization) {
                return $localization.get("link-not-relinkable", new Object[0]);
            }
        }
    }
}

