/*
 * Decompiled with CFR 0.152.
 */
package xyz.atrius.waystones.manager;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.output.MigrateOutput;
import org.flywaydb.core.api.output.MigrateResult;
import org.flywaydb.core.internal.jdbc.RowMapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.annotation.Single;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.atrius.Metadata;
import xyz.atrius.collections.CollectionsKt;
import xyz.atrius.jvm.internal.DefaultConstructorMarker;
import xyz.atrius.jvm.internal.Intrinsics;
import xyz.atrius.jvm.internal.SourceDebugExtension;
import xyz.atrius.waystones.config.DatabaseProperties;
import xyz.atrius.waystones.internal.KotlinPlugin;

@Single
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\b\u0007\u0018\u0000 )2\u00060\u0001j\u0002`\u0002:\u0001)B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J>\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00140\u0013\"\u0004\b\u0000\u0010\u00142\u0006\u0010\u0012\u001a\u00020\u00152\u0012\b\u0002\u0010\u0016\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0018\u00010\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00140\u001aJB\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00140\u00170\u0013\"\u0004\b\u0000\u0010\u00142\u0006\u0010\u0012\u001a\u00020\u00152\u0012\b\u0002\u0010\u0016\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0018\u00010\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00140\u001aJ(\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00132\u0006\u0010\u0012\u001a\u00020\u00152\u0012\b\u0002\u0010\u0016\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0018\u00010\u0017J(\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00132\u0006\u0010\u0012\u001a\u00020\u00152\u0012\b\u0002\u0010\u0016\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0018\u00010\u0017J\u0014\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u00140\u0013\"\u0004\b\u0000\u0010\u0014H\u0002J\u001e\u0010!\u001a\u00020\"*\u00020\"2\u0010\u0010\u0016\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0018\u00010\u0017H\u0002J#\u0010#\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u0002H\u0014H\u0002\u00a2\u0006\u0002\u0010'J\b\u0010(\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lxyz/atrius/waystones/manager/DatabaseManager;", "Ljava/lang/AutoCloseable;", "Lxyz/atrius/AutoCloseable;", "flyway", "Lorg/flywaydb/core/Flyway;", "properties", "Lxyz/atrius/waystones/config/DatabaseProperties;", "plugin", "Lxyz/atrius/waystones/internal/KotlinPlugin;", "<init>", "(Lorg/flywaydb/core/Flyway;Lxyz/atrius/waystones/config/DatabaseProperties;Lxyz/atrius/waystones/internal/KotlinPlugin;)V", "connection", "Ljava/sql/Connection;", "load", "", "logFailedMigration", "result", "Lorg/flywaydb/core/api/output/MigrateResult;", "query", "Ljava/util/concurrent/CompletableFuture;", "T", "", "parameters", "", "", "rowMapper", "Lorg/flywaydb/core/internal/jdbc/RowMapper;", "queryAll", "queryExists", "", "queryUpdate", "", "connectionInactive", "populateParameters", "Ljava/sql/PreparedStatement;", "logAndDefault", "ex", "", "value", "(Ljava/lang/Throwable;Ljava/lang/Object;)Ljava/lang/Object;", "close", "Companion", "waystones"})
@SourceDebugExtension(value={"SMAP\nDatabaseManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseManager.kt\nxyz/atrius/waystones/manager/DatabaseManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,169:1\n1878#2,3:170\n*S KotlinDebug\n*F\n+ 1 DatabaseManager.kt\nxyz/atrius/waystones/manager/DatabaseManager\n*L\n144#1:170,3\n*E\n"})
public final class DatabaseManager
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Flyway flyway;
    @NotNull
    private final DatabaseProperties properties;
    @NotNull
    private final KotlinPlugin plugin;
    @Nullable
    private Connection connection;
    private static final Logger logger = LoggerFactory.getLogger(DatabaseManager.class);

    public DatabaseManager(@NotNull Flyway flyway, @NotNull DatabaseProperties properties, @NotNull KotlinPlugin plugin) {
        Intrinsics.checkNotNullParameter(flyway, "flyway");
        Intrinsics.checkNotNullParameter(properties, "properties");
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.flyway = flyway;
        this.properties = properties;
        this.plugin = plugin;
    }

    public final void load() {
        if (this.connection != null) {
            logger.error("Cannot reload DatabaseManager... Class already loaded!");
            return;
        }
        logger.info("Performing database migrations...");
        MigrateResult result = this.flyway.migrate();
        if (!result.success) {
            Intrinsics.checkNotNull(result);
            this.logFailedMigration(result);
            throw new IllegalStateException("Migrations failed!".toString());
        }
        int executions = result.migrationsExecuted;
        if (executions == 0) {
            logger.info("No new migrations performed!");
        } else {
            logger.info("Performed " + executions + " migrations!");
        }
        logger.info("Creating connection to database...");
        this.connection = DriverManager.getConnection(this.properties.getHostUrl(this.plugin), this.properties.getUsername(), this.properties.getPassword());
        logger.info("Connection generated!");
    }

    private final void logFailedMigration(MigrateResult result) {
        List list = result.getFailedMigrations();
        Intrinsics.checkNotNullExpressionValue(list, "getFailedMigrations(...)");
        String failedMigrations = CollectionsKt.joinToString$default(list, "\n", null, null, 0, null, DatabaseManager::logFailedMigration$lambda$0, 30, null);
        logger.error("Failed to perform database migrations! See below:");
        logger.error(failedMigrations);
    }

    @NotNull
    public final <T> CompletableFuture<T> query(@NotNull String query, @Nullable List<? extends Object> parameters, @NotNull RowMapper<T> rowMapper) {
        PreparedStatement preparedStatement;
        Intrinsics.checkNotNullParameter(query, "query");
        Intrinsics.checkNotNullParameter(rowMapper, "rowMapper");
        Connection connection = this.connection;
        if (connection == null || (preparedStatement = connection.prepareStatement(query)) == null) {
            return this.connectionInactive();
        }
        PreparedStatement statement = preparedStatement;
        CompletionStage completionStage = CompletableFuture.supplyAsync(() -> DatabaseManager.query$lambda$1(this, statement, parameters, rowMapper)).exceptionally(arg_0 -> DatabaseManager.query$lambda$2(this, arg_0));
        Intrinsics.checkNotNullExpressionValue(completionStage, "exceptionally(...)");
        return completionStage;
    }

    public static /* synthetic */ CompletableFuture query$default(DatabaseManager databaseManager, String string, List list, RowMapper rowMapper, int n, Object object) {
        if ((n & 2) != 0) {
            list = null;
        }
        return databaseManager.query(string, list, rowMapper);
    }

    @NotNull
    public final <T> CompletableFuture<List<T>> queryAll(@NotNull String query, @Nullable List<? extends Object> parameters, @NotNull RowMapper<T> rowMapper) {
        PreparedStatement preparedStatement;
        Intrinsics.checkNotNullParameter(query, "query");
        Intrinsics.checkNotNullParameter(rowMapper, "rowMapper");
        Connection connection = this.connection;
        if (connection == null || (preparedStatement = connection.prepareStatement(query)) == null) {
            return this.connectionInactive();
        }
        PreparedStatement statement = preparedStatement;
        CompletionStage completionStage = CompletableFuture.supplyAsync(() -> DatabaseManager.queryAll$lambda$3(this, statement, parameters, rowMapper)).exceptionally(arg_0 -> DatabaseManager.queryAll$lambda$4(this, arg_0));
        Intrinsics.checkNotNullExpressionValue(completionStage, "exceptionally(...)");
        return completionStage;
    }

    public static /* synthetic */ CompletableFuture queryAll$default(DatabaseManager databaseManager, String string, List list, RowMapper rowMapper, int n, Object object) {
        if ((n & 2) != 0) {
            list = null;
        }
        return databaseManager.queryAll(string, list, rowMapper);
    }

    @NotNull
    public final CompletableFuture<Boolean> queryExists(@NotNull String query, @Nullable List<? extends Object> parameters) {
        PreparedStatement preparedStatement;
        Intrinsics.checkNotNullParameter(query, "query");
        Connection connection = this.connection;
        if (connection == null || (preparedStatement = connection.prepareStatement(query)) == null) {
            return this.connectionInactive();
        }
        PreparedStatement statement = preparedStatement;
        CompletionStage completionStage = CompletableFuture.supplyAsync(() -> DatabaseManager.queryExists$lambda$5(this, statement, parameters)).exceptionally(arg_0 -> DatabaseManager.queryExists$lambda$6(this, arg_0));
        Intrinsics.checkNotNullExpressionValue(completionStage, "exceptionally(...)");
        return completionStage;
    }

    public static /* synthetic */ CompletableFuture queryExists$default(DatabaseManager databaseManager, String string, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = null;
        }
        return databaseManager.queryExists(string, list);
    }

    @NotNull
    public final CompletableFuture<Integer> queryUpdate(@NotNull String query, @Nullable List<? extends Object> parameters) {
        PreparedStatement preparedStatement;
        Intrinsics.checkNotNullParameter(query, "query");
        Connection connection = this.connection;
        if (connection == null || (preparedStatement = connection.prepareStatement(query)) == null) {
            return this.connectionInactive();
        }
        PreparedStatement statement = preparedStatement;
        CompletionStage completionStage = CompletableFuture.supplyAsync(() -> DatabaseManager.queryUpdate$lambda$7(this, statement, parameters)).exceptionally(arg_0 -> DatabaseManager.queryUpdate$lambda$8(this, arg_0));
        Intrinsics.checkNotNullExpressionValue(completionStage, "exceptionally(...)");
        return completionStage;
    }

    public static /* synthetic */ CompletableFuture queryUpdate$default(DatabaseManager databaseManager, String string, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = null;
        }
        return databaseManager.queryUpdate(string, list);
    }

    private final <T> CompletableFuture<T> connectionInactive() {
        CompletableFuture completableFuture = CompletableFuture.failedFuture(new IllegalStateException("Connection is not active!"));
        Intrinsics.checkNotNullExpressionValue(completableFuture, "failedFuture(...)");
        return completableFuture;
    }

    /*
     * WARNING - void declaration
     */
    private final PreparedStatement populateParameters(PreparedStatement $this$populateParameters, List<? extends Object> parameters) {
        PreparedStatement preparedStatement;
        block3: {
            PreparedStatement $this$populateParameters_u24lambda_u2410 = preparedStatement = $this$populateParameters;
            boolean bl = false;
            List<? extends Object> list = parameters;
            if (list == null) break block3;
            Iterable $this$forEachIndexed$iv = list;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void p;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv;
                int i = n;
                boolean bl2 = false;
                if (p instanceof UUID) {
                    $this$populateParameters_u24lambda_u2410.setObject(i + 1, ((UUID)p).toString());
                    continue;
                }
                $this$populateParameters_u24lambda_u2410.setObject(i + 1, p);
            }
        }
        return preparedStatement;
    }

    private final <T> T logAndDefault(Throwable ex, T value) {
        logger.error("Failed transaction: " + ex.getMessage());
        return value;
    }

    @Override
    public void close() {
        logger.info("Shutting down database connection...");
        Connection connection = this.connection;
        if (connection != null) {
            connection.close();
        }
        this.connection = null;
    }

    private static final CharSequence logFailedMigration$lambda$0(MigrateOutput it) {
        return it.version + " - " + it.description;
    }

    private static final Object query$lambda$1(DatabaseManager this$0, PreparedStatement $statement, List $parameters, RowMapper $rowMapper) {
        ResultSet result = this$0.populateParameters($statement, $parameters).executeQuery();
        return result.next() ? $rowMapper.mapRow(result) : null;
    }

    private static final Object query$lambda$2(DatabaseManager this$0, Throwable it) {
        Intrinsics.checkNotNull(it);
        return this$0.logAndDefault(it, null);
    }

    private static final List queryAll$lambda$3(DatabaseManager this$0, PreparedStatement $statement, List $parameters, RowMapper $rowMapper) {
        List output = new ArrayList();
        ResultSet result = this$0.populateParameters($statement, $parameters).executeQuery();
        while (result.next()) {
            output.add($rowMapper.mapRow(result));
        }
        return output;
    }

    private static final List queryAll$lambda$4(DatabaseManager this$0, Throwable it) {
        Intrinsics.checkNotNull(it);
        return this$0.logAndDefault(it, null);
    }

    private static final Boolean queryExists$lambda$5(DatabaseManager this$0, PreparedStatement $statement, List $parameters) {
        return this$0.populateParameters($statement, $parameters).executeQuery().next();
    }

    private static final Boolean queryExists$lambda$6(DatabaseManager this$0, Throwable it) {
        Intrinsics.checkNotNull(it);
        return this$0.logAndDefault(it, false);
    }

    private static final Integer queryUpdate$lambda$7(DatabaseManager this$0, PreparedStatement $statement, List $parameters) {
        return this$0.populateParameters($statement, $parameters).executeUpdate();
    }

    private static final Integer queryUpdate$lambda$8(DatabaseManager this$0, Throwable it) {
        Intrinsics.checkNotNull(it);
        return this$0.logAndDefault(it, 0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lxyz/atrius/waystones/manager/DatabaseManager$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "xyz.atrius.jvm.PlatformType", "waystones"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

