/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.context;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.KoinApplication;
import org.koin.core.context.KoinContext;
import org.koin.core.error.KoinApplicationAlreadyStartedException;
import org.koin.core.module.Module;
import xyz.atrius.Metadata;
import xyz.atrius.Unit;
import xyz.atrius.collections.CollectionsKt;
import xyz.atrius.jvm.functions.Function1;
import xyz.atrius.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\u0005H\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010\n\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007H\u0002J\b\u0010\u000e\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0016J%\u0010\u000f\u001a\u00020\u00072\u001b\u0010\u0010\u001a\u0017\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u0011j\u0002`\u0013\u00a2\u0006\u0002\b\u0012H\u0016J\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001e\u0010\u0014\u001a\u00020\f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u001b\u001a\u00020\f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u001aH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/koin/core/context/GlobalContext;", "Lorg/koin/core/context/KoinContext;", "<init>", "()V", "_koin", "Lorg/koin/core/Koin;", "_koinApplication", "Lorg/koin/core/KoinApplication;", "get", "getOrNull", "getKoinApplicationOrNull", "register", "", "koinApplication", "stopKoin", "startKoin", "appDeclaration", "Lxyz/atrius/Function1;", "Lxyz/atrius/ExtensionFunctionType;", "Lorg/koin/dsl/KoinAppDeclaration;", "loadKoinModules", "module", "Lorg/koin/core/module/Module;", "createEagerInstances", "", "modules", "", "unloadKoinModules", "koin-core"})
public final class GlobalContext
implements KoinContext {
    @NotNull
    public static final GlobalContext INSTANCE = new GlobalContext();
    @Nullable
    private static Koin _koin;
    @Nullable
    private static KoinApplication _koinApplication;

    private GlobalContext() {
    }

    @Override
    @NotNull
    public Koin get() {
        Koin koin = _koin;
        if (koin == null) {
            throw new IllegalStateException("KoinApplication has not been started".toString());
        }
        return koin;
    }

    @Override
    @Nullable
    public Koin getOrNull() {
        return _koin;
    }

    @Nullable
    public final KoinApplication getKoinApplicationOrNull() {
        return _koinApplication;
    }

    private final void register(KoinApplication koinApplication) {
        if (_koin != null) {
            throw new KoinApplicationAlreadyStartedException("A Koin Application has already been started");
        }
        _koinApplication = koinApplication;
        _koin = koinApplication.getKoin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopKoin() {
        GlobalContext globalContext = this;
        synchronized (globalContext) {
            boolean bl = false;
            Koin koin = _koin;
            if (koin != null) {
                koin.close();
            }
            _koin = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public KoinApplication startKoin(@NotNull KoinApplication koinApplication) {
        Intrinsics.checkNotNullParameter(koinApplication, "koinApplication");
        GlobalContext globalContext = this;
        synchronized (globalContext) {
            boolean bl = false;
            INSTANCE.register(koinApplication);
            koinApplication.createEagerInstances();
            KoinApplication koinApplication2 = koinApplication;
            return koinApplication2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public KoinApplication startKoin(@NotNull Function1<? super KoinApplication, Unit> appDeclaration) {
        Intrinsics.checkNotNullParameter(appDeclaration, "appDeclaration");
        GlobalContext globalContext = this;
        synchronized (globalContext) {
            boolean bl = false;
            KoinApplication koinApplication = KoinApplication.Companion.init();
            INSTANCE.register(koinApplication);
            appDeclaration.invoke(koinApplication);
            koinApplication.createEagerInstances();
            KoinApplication koinApplication2 = koinApplication;
            return koinApplication2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadKoinModules(@NotNull Module module, boolean createEagerInstances) {
        Intrinsics.checkNotNullParameter(module, "module");
        GlobalContext globalContext = this;
        synchronized (globalContext) {
            boolean bl = false;
            Koin.loadModules$default(INSTANCE.get(), CollectionsKt.listOf(module), false, createEagerInstances, 2, null);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadKoinModules(@NotNull List<Module> modules, boolean createEagerInstances) {
        Intrinsics.checkNotNullParameter(modules, "modules");
        GlobalContext globalContext = this;
        synchronized (globalContext) {
            boolean bl = false;
            Koin.loadModules$default(INSTANCE.get(), modules, false, createEagerInstances, 2, null);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unloadKoinModules(@NotNull Module module) {
        Intrinsics.checkNotNullParameter(module, "module");
        GlobalContext globalContext = this;
        synchronized (globalContext) {
            boolean bl = false;
            INSTANCE.get().unloadModules(CollectionsKt.listOf(module));
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unloadKoinModules(@NotNull List<Module> modules) {
        Intrinsics.checkNotNullParameter(modules, "modules");
        GlobalContext globalContext = this;
        synchronized (globalContext) {
            boolean bl = false;
            INSTANCE.get().unloadModules(modules);
            Unit unit = Unit.INSTANCE;
        }
    }
}

