/*
 * Decompiled with CFR 0.152.
 */
package xyz.atrius.waystones.event;

import arrow.core.Either;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.koin.core.annotation.Single;
import xyz.atrius.waystones.advancement.SecretTunnelAdvancement;
import xyz.atrius.waystones.advancement.ShootTheMessengerAdvancement;
import xyz.atrius.waystones.data.config.property.DamageStopsWarpingProperty;
import xyz.atrius.waystones.kotlin.Metadata;
import xyz.atrius.waystones.kotlin.NoWhenBranchMatchedException;
import xyz.atrius.waystones.kotlin.Unit;
import xyz.atrius.waystones.kotlin.jvm.internal.Intrinsics;
import xyz.atrius.waystones.kotlin.jvm.internal.SourceDebugExtension;
import xyz.atrius.waystones.manager.AdvancementManager;
import xyz.atrius.waystones.manager.LocalizationManager;
import xyz.atrius.waystones.service.KeyService;
import xyz.atrius.waystones.service.TeleportService;
import xyz.atrius.waystones.service.WaystoneService;
import xyz.atrius.waystones.utility.EventKt;
import xyz.atrius.waystones.utility.LocationKt;
import xyz.atrius.waystones.utility.PlayerKt;

@Single
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001dH\u0007J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lxyz/atrius/waystones/event/WarpEvent;", "Lorg/bukkit/event/Listener;", "teleportService", "Lxyz/atrius/waystones/service/TeleportService;", "localization", "Lxyz/atrius/waystones/manager/LocalizationManager;", "damageStopsWarping", "Lxyz/atrius/waystones/data/config/property/DamageStopsWarpingProperty;", "keyService", "Lxyz/atrius/waystones/service/KeyService;", "waystoneService", "Lxyz/atrius/waystones/service/WaystoneService;", "advancementManager", "Lxyz/atrius/waystones/manager/AdvancementManager;", "secretTunnelAdvancement", "Lxyz/atrius/waystones/advancement/SecretTunnelAdvancement;", "shootTheMessenger", "Lxyz/atrius/waystones/advancement/ShootTheMessengerAdvancement;", "<init>", "(Lxyz/atrius/waystones/service/TeleportService;Lxyz/atrius/waystones/manager/LocalizationManager;Lxyz/atrius/waystones/data/config/property/DamageStopsWarpingProperty;Lxyz/atrius/waystones/service/KeyService;Lxyz/atrius/waystones/service/WaystoneService;Lxyz/atrius/waystones/manager/AdvancementManager;Lxyz/atrius/waystones/advancement/SecretTunnelAdvancement;Lxyz/atrius/waystones/advancement/ShootTheMessengerAdvancement;)V", "onClick", "", "event", "Lorg/bukkit/event/player/PlayerInteractEvent;", "onMove", "Lorg/bukkit/event/player/PlayerMoveEvent;", "onDropItem", "Lorg/bukkit/event/player/PlayerDropItemEvent;", "onDamage", "Lorg/bukkit/event/entity/EntityDamageEvent;", "waystoneAdvancement", "player", "Lorg/bukkit/entity/Player;", "waystones"})
@SourceDebugExtension(value={"SMAP\nWarpEvent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WarpEvent.kt\nxyz/atrius/waystones/event/WarpEvent\n+ 2 Arrow.kt\nxyz/atrius/waystones/utility/ArrowKt\n+ 3 Either.kt\narrow/core/Either\n*L\n1#1,128:1\n6#2:129\n6#2:133\n596#3,3:130\n596#3,3:134\n*S KotlinDebug\n*F\n+ 1 WarpEvent.kt\nxyz/atrius/waystones/event/WarpEvent\n*L\n55#1:129\n59#1:133\n55#1:130,3\n59#1:134,3\n*E\n"})
public final class WarpEvent
implements Listener {
    @NotNull
    private final TeleportService teleportService;
    @NotNull
    private final LocalizationManager localization;
    @NotNull
    private final DamageStopsWarpingProperty damageStopsWarping;
    @NotNull
    private final KeyService keyService;
    @NotNull
    private final WaystoneService waystoneService;
    @NotNull
    private final AdvancementManager advancementManager;
    @NotNull
    private final SecretTunnelAdvancement secretTunnelAdvancement;
    @NotNull
    private final ShootTheMessengerAdvancement shootTheMessenger;

    public WarpEvent(@NotNull TeleportService teleportService, @NotNull LocalizationManager localization, @NotNull DamageStopsWarpingProperty damageStopsWarping, @NotNull KeyService keyService, @NotNull WaystoneService waystoneService, @NotNull AdvancementManager advancementManager, @NotNull SecretTunnelAdvancement secretTunnelAdvancement, @NotNull ShootTheMessengerAdvancement shootTheMessenger) {
        Intrinsics.checkNotNullParameter(teleportService, "teleportService");
        Intrinsics.checkNotNullParameter(localization, "localization");
        Intrinsics.checkNotNullParameter(damageStopsWarping, "damageStopsWarping");
        Intrinsics.checkNotNullParameter(keyService, "keyService");
        Intrinsics.checkNotNullParameter(waystoneService, "waystoneService");
        Intrinsics.checkNotNullParameter(advancementManager, "advancementManager");
        Intrinsics.checkNotNullParameter(secretTunnelAdvancement, "secretTunnelAdvancement");
        Intrinsics.checkNotNullParameter(shootTheMessenger, "shootTheMessenger");
        this.teleportService = teleportService;
        this.localization = localization;
        this.damageStopsWarping = damageStopsWarping;
        this.keyService = keyService;
        this.waystoneService = waystoneService;
        this.advancementManager = advancementManager;
        this.secretTunnelAdvancement = secretTunnelAdvancement;
        this.shootTheMessenger = shootTheMessenger;
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler
    public final void onClick(@NotNull PlayerInteractEvent event) {
        void $this$foldResult$iv;
        void $this$foldResult$iv2;
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        if (player2.isGliding() || !event.getAction().isRightClick() || this.waystoneService.isWaystone(event.getClickedBlock())) {
            return;
        }
        Either<KeyService.KeyServiceError, KeyService.Key> either = this.keyService.process(player2, event);
        boolean $i$f$foldResult22 = false;
        void this_$iv$iv = $this$foldResult$iv2;
        boolean $i$f$fold = false;
        void var8_10 = this_$iv$iv;
        if (!(var8_10 instanceof Either.Right)) {
            if (var8_10 instanceof Either.Left) {
                KeyService.KeyServiceError it = (KeyService.KeyServiceError)((Either.Left)this_$iv$iv).getValue();
                boolean bl = false;
                PlayerKt.sendActionError(player2, it.getMessage().invoke());
                return;
            }
            throw new NoWhenBranchMatchedException();
        }
        Object it$iv = ((Either.Right)this_$iv$iv).getValue();
        boolean bl = false;
        KeyService.Key key = (KeyService.Key)it$iv;
        Block block = key.getLocation().getBlock();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        Either<WaystoneService.WaystoneServiceError, WaystoneService.Warp> $i$f$foldResult22 = this.waystoneService.process(player2, block, key.getLocation());
        boolean $i$f$foldResult = false;
        void this_$iv$iv2 = $this$foldResult$iv;
        boolean $i$f$fold2 = false;
        void var9_12 = this_$iv$iv2;
        if (!(var9_12 instanceof Either.Right)) {
            if (var9_12 instanceof Either.Left) {
                WaystoneService.WaystoneServiceError it = (WaystoneService.WaystoneServiceError)((Either.Left)this_$iv$iv2).getValue();
                boolean bl2 = false;
                Location location = player2.getLocation();
                Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
                Sound sound = Sound.ENTITY_ENDER_EYE_DEATH;
                Intrinsics.checkNotNullExpressionValue(sound, "ENTITY_ENDER_EYE_DEATH");
                LocationKt.playSound(location, sound, 1.0f, 0.0f);
                PlayerKt.sendActionError(player2, it.getMessage().invoke());
                return;
            }
            throw new NoWhenBranchMatchedException();
        }
        Object it$iv2 = ((Either.Right)this_$iv$iv2).getValue();
        $i$a$-fold-ArrowKt$foldResult$1$iv = false;
        WaystoneService.Warp warp = (WaystoneService.Warp)it$iv2;
        this.teleportService.queueEvent(warp, key, () -> WarpEvent.onClick$lambda$2(this, player2, warp));
        EventKt.cancel((Cancellable)event);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onMove(@NotNull PlayerMoveEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!EventKt.hasMovedBlock(event)) {
            return;
        }
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        if (!this.teleportService.contains(player2)) {
            return;
        }
        this.teleportService.cancel(player2);
        PlayerKt.sendActionError(player2, this.localization.get("warp-cancel", new Object[0]));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public final void onDropItem(@NotNull PlayerDropItemEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        ItemStack itemStack = event.getItemDrop().getItemStack();
        Intrinsics.checkNotNullExpressionValue(itemStack, "getItemStack(...)");
        ItemStack item = itemStack;
        if (!this.teleportService.contains(player2) || !this.keyService.isWarpKey(item)) {
            return;
        }
        this.teleportService.cancel(player2);
        PlayerKt.sendActionError(player2, this.localization.get("warp-cancel", new Object[0]));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onDamage(@NotNull EntityDamageEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Entity entity = event.getEntity();
        Intrinsics.checkNotNullExpressionValue(entity, "getEntity(...)");
        Entity entity2 = entity;
        if (!((Boolean)this.damageStopsWarping.value()).booleanValue() || !(entity2 instanceof Player)) {
            return;
        }
        if (!this.teleportService.contains((Player)entity2)) {
            return;
        }
        this.teleportService.cancel((Player)entity2);
        PlayerKt.sendActionError((Player)entity2, this.localization.get("warp-interrupt", new Object[0]));
        this.waystoneAdvancement((Player)entity2);
    }

    private final void waystoneAdvancement(Player player) {
        Entity attacker;
        EntityDamageEvent entityDamageEvent = player.getLastDamageCause();
        EntityDamageByEntityEvent entityDamageByEntityEvent = entityDamageEvent instanceof EntityDamageByEntityEvent ? (EntityDamageByEntityEvent)entityDamageEvent : null;
        Object object = attacker = entityDamageByEntityEvent != null ? entityDamageByEntityEvent.getDamager() : null;
        if (!(attacker instanceof Arrow) || !(((Arrow)attacker).getShooter() instanceof Skeleton)) {
            return;
        }
        double d = player.getHealth();
        boolean bl = 1.0 <= d ? d <= 2.0 : false;
        if (bl) {
            this.advancementManager.awardAdvancement(player, this.shootTheMessenger);
        }
    }

    private static final Unit onClick$lambda$2(WarpEvent this$0, Player $player, WaystoneService.Warp $warp) {
        this$0.advancementManager.awardAdvancement($player, this$0.secretTunnelAdvancement);
        this$0.waystoneService.gigawarpsAdvancement($player, $warp);
        this$0.waystoneService.cleanEnergyAdvancement($player, $warp);
        return Unit.INSTANCE;
    }
}

